/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.backup;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.james.mailbox.backup.MailArchiveEntry;
import org.apache.james.mailbox.backup.SerializedMailboxId;
import org.apache.james.mailbox.model.MailboxAnnotation;

public class MailboxWithAnnotationsArchiveEntry
implements MailArchiveEntry {
    private final String mailboxName;
    private final SerializedMailboxId mailboxId;
    private final ImmutableList<MailboxAnnotation> annotations;

    public MailboxWithAnnotationsArchiveEntry(String mailboxName, SerializedMailboxId mailboxId, List<MailboxAnnotation> annotations) {
        this.mailboxName = mailboxName;
        this.mailboxId = mailboxId;
        this.annotations = ImmutableList.copyOf(annotations);
    }

    public String getMailboxName() {
        return this.mailboxName;
    }

    public SerializedMailboxId getMailboxId() {
        return this.mailboxId;
    }

    public List<MailboxAnnotation> getAnnotations() {
        return this.annotations;
    }

    public MailboxWithAnnotationsArchiveEntry appendAnnotation(MailboxAnnotation annotation) {
        ImmutableList newAnnotations = ImmutableList.builder().addAll(this.annotations).add((Object)annotation).build();
        return new MailboxWithAnnotationsArchiveEntry(this.mailboxName, this.mailboxId, (List<MailboxAnnotation>)newAnnotations);
    }

    @Override
    public MailArchiveEntry.ArchiveEntryType getType() {
        return MailArchiveEntry.ArchiveEntryType.MAILBOX;
    }

    public boolean equals(Object o) {
        if (o instanceof MailboxWithAnnotationsArchiveEntry) {
            MailboxWithAnnotationsArchiveEntry that = (MailboxWithAnnotationsArchiveEntry)o;
            return Objects.equals(this.mailboxName, that.mailboxName) && Objects.equals(this.mailboxId, that.mailboxId) && Objects.equals(this.annotations, that.annotations);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mailboxName, this.mailboxId, this.annotations);
    }
}

