/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.mail.MessagingException;
import javax.mail.util.SharedByteArrayInputStream;
import javax.mail.util.SharedFileInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.james.lifecycle.api.Disposable;
import org.apache.james.server.core.BufferedDeferredFileOutputStream;
import org.apache.james.server.core.MimeMessageSource;
import org.apache.james.util.SizeFormat;

public class MimeMessageInputStreamSource
extends MimeMessageSource
implements Disposable {
    private static final int DEFAULT_THRESHOLD = 102400;
    private static final int THRESHOLD = MimeMessageInputStreamSource.threshold();
    private final Set<InputStream> streams = new HashSet<InputStream>();
    private BufferedDeferredFileOutputStream out;
    private final String sourceId;

    private static int threshold() {
        return Optional.ofNullable(System.getProperty("james.message.memory.threshold")).map(SizeFormat::parseAsByteCount).map(Math::toIntExact).orElse(102400);
    }

    public MimeMessageInputStreamSource(String key, InputStream in) throws MessagingException {
        try {
            this.out = new BufferedDeferredFileOutputStream(THRESHOLD, "mimemessage-" + key, ".m64");
            IOUtils.copy((InputStream)in, (OutputStream)((Object)this.out));
            this.sourceId = key;
        }
        catch (IOException ioe) {
            File file = this.out.getFile();
            if (file != null) {
                FileUtils.deleteQuietly((File)file);
            }
            throw new MessagingException("Unable to retrieve the data: " + ioe.getMessage(), (Exception)ioe);
        }
        finally {
            try {
                if (this.out != null) {
                    this.out.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public MimeMessageInputStreamSource(String key) {
        this.out = new BufferedDeferredFileOutputStream(THRESHOLD, key, ".m64");
        this.sourceId = key;
    }

    @Override
    public String getSourceId() {
        return this.sourceId;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        Object in = this.out.isInMemory() ? new SharedByteArrayInputStream(this.out.getData()) : new SharedFileInputStream(this.out.getFile());
        this.streams.add((InputStream)in);
        return in;
    }

    @Override
    public long getMessageSize() throws IOException {
        return this.out.getByteCount();
    }

    public OutputStream getWritableOutputStream() {
        return this.out;
    }

    public void dispose() {
        for (InputStream stream : this.streams) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            File file = this.out.getFile();
            if (file != null) {
                FileUtils.deleteQuietly((File)file);
                file = null;
            }
            this.out = null;
        }
    }
}

