/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import org.apache.mailet.Experimental;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetException;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class OnlyText
extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(OnlyText.class);
    private static final String PARAMETER_NAME_NOTEXT_PROCESSOR = "NoTextProcessor";
    private String optionsNotextProcessor = null;
    private final HashMap<String, String> charMap = new HashMap();

    public String getMailetInfo() {
        return "OnlyText";
    }

    public void init() throws MailetException {
        this.optionsNotextProcessor = this.getInitParameter(PARAMETER_NAME_NOTEXT_PROCESSOR);
        this.initEntityTable();
    }

    private int[] process(Mail mail, Multipart mp, int found, int htmlPart, int stringPart) throws MessagingException, IOException {
        for (int i = 0; found < 0 && i < mp.getCount(); ++i) {
            Object content = null;
            try {
                content = mp.getBodyPart(i).getContent();
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("Caught error in a text/plain part, skipping...", (Throwable)e);
            }
            if (content == null) continue;
            if (mp.getBodyPart(i).isMimeType("text/plain")) {
                OnlyText.setContentFromPart((Message)mail.getMessage(), (Part)mp.getBodyPart(i), null, false);
                found = 1;
                continue;
            }
            if (htmlPart == -1 && mp.getBodyPart(i).isMimeType("text/html")) {
                htmlPart = i;
                continue;
            }
            if (stringPart == -1 && content instanceof String) {
                stringPart = i;
                continue;
            }
            if (!(content instanceof Multipart)) continue;
            int[] res = this.process(mail, (Multipart)content, found, htmlPart, stringPart);
            found = res[0];
            htmlPart = res[1];
            stringPart = res[2];
        }
        return new int[]{found, htmlPart, stringPart};
    }

    public void service(Mail mail) throws MailetException {
        try {
            Object content = mail.getMessage().getContent();
            if (content instanceof Multipart) {
                Multipart mp = (Multipart)content;
                int found = -1;
                int htmlPart = -1;
                int stringPart = -1;
                int[] res = this.process(mail, (Multipart)content, found, htmlPart, stringPart);
                found = res[0];
                htmlPart = res[1];
                stringPart = res[2];
                if (found < 0 && htmlPart != -1) {
                    OnlyText.setContentFromPart((Message)mail.getMessage(), (Part)mp.getBodyPart(htmlPart), this.html2Text((String)mp.getBodyPart(htmlPart).getContent()), true);
                    found = 1;
                }
                if (found < 0 && stringPart != -1) {
                    OnlyText.setContentFromPart((Message)mail.getMessage(), (Part)mp.getBodyPart(htmlPart), null, false);
                    found = 1;
                }
                if (found < 0 && this.optionsNotextProcessor != null) {
                    mail.setState(this.optionsNotextProcessor);
                }
            } else if (!(content instanceof String) && this.optionsNotextProcessor != null) {
                mail.setState(this.optionsNotextProcessor);
            } else if (mail.getMessage().isMimeType("text/html")) {
                OnlyText.setContentFromPart((Message)mail.getMessage(), (Part)mail.getMessage(), this.html2Text((String)mail.getMessage().getContent()), true);
            }
        }
        catch (IOException | MessagingException e) {
            throw new MailetException("Failed fetching text part", (Exception)e);
        }
    }

    private static void setContentFromPart(Message m, Part p, String newText, boolean setTextPlain) throws MessagingException, IOException {
        String contentType = p.getContentType();
        if (setTextPlain) {
            ContentType ct = new ContentType(contentType);
            ct.setPrimaryType("text");
            ct.setSubType("plain");
            contentType = ct.toString();
        }
        m.setContent(newText != null ? newText : p.getContent(), contentType);
        String[] h = p.getHeader("Content-Transfer-Encoding");
        if (h != null && h.length > 0) {
            m.setHeader("Content-Transfer-Encoding", h[0]);
        }
        m.saveChanges();
    }

    public String html2Text(String html) {
        return this.decodeEntities(html.replaceAll("\\<([bB][rR]|[dD][lL])[ ]*[/]*[ ]*\\>", "\n").replaceAll("\\</([pP]|[hH]5|[dD][tT]|[dD][dD]|[dD][iI][vV])[ ]*\\>", "\n").replaceAll("\\<[lL][iI][ ]*[/]*[ ]*\\>", "\n* ").replaceAll("\\<[dD][dD][ ]*[/]*[ ]*\\>", " - ").replaceAll("\\<.*?\\>", ""));
    }

    public String decodeEntities(String data) {
        StringBuffer buffer = new StringBuffer();
        StringBuilder res = new StringBuilder();
        int lastAmp = -1;
        for (int i = 0; i < data.length(); ++i) {
            char c = data.charAt(i);
            if (c == '&' && lastAmp == -1) {
                lastAmp = buffer.length();
                continue;
            }
            if (c == ';' && lastAmp > -1) {
                if (this.charMap.containsKey(buffer.toString())) {
                    res.append(this.charMap.get(buffer.toString()));
                } else {
                    res.append("&").append(buffer.toString()).append(";");
                }
                lastAmp = -1;
                buffer = new StringBuffer();
                continue;
            }
            if (lastAmp == -1) {
                res.append(c);
                continue;
            }
            buffer.append(c);
        }
        return res.toString();
    }

    private void initEntityTable() {
        int index;
        for (index = 11; index < 32; ++index) {
            this.charMap.put("#0" + index, String.valueOf((char)index));
        }
        for (index = 32; index < 128; ++index) {
            this.charMap.put("#" + index, String.valueOf((char)index));
        }
        for (index = 128; index < 256; ++index) {
            this.charMap.put("#" + index, String.valueOf((char)index));
        }
        this.charMap.put("#09", "\t");
        this.charMap.put("#10", "\n");
        this.charMap.put("#13", "\r");
        this.charMap.put("#60", "<");
        this.charMap.put("#62", ">");
        this.charMap.put("lt", "<");
        this.charMap.put("gt", ">");
        this.charMap.put("amp", "&");
        this.charMap.put("nbsp", " ");
        this.charMap.put("quot", "\"");
        this.charMap.put("Ouml", "\u00d6");
        this.charMap.put("Oacute", "\u00d3");
        this.charMap.put("iquest", "\u00bf");
        this.charMap.put("yuml", "\u00ff");
        this.charMap.put("cent", "\u00a2");
        this.charMap.put("deg", "\u00b0");
        this.charMap.put("aacute", "\u00e1");
        this.charMap.put("uuml", "\u00fc");
        this.charMap.put("Otilde", "\u00d5");
        this.charMap.put("Iacute", "\u00cd");
        this.charMap.put("frac12", "\u00bd");
        this.charMap.put("atilde", "\u00e3");
        this.charMap.put("ordf", "\u00aa");
        this.charMap.put("sup2", "\u00b2");
        this.charMap.put("sup3", "\u00b3");
        this.charMap.put("frac14", "\u00bc");
        this.charMap.put("ucirc", "\u00fb");
        this.charMap.put("brvbar", "\u00a6");
        this.charMap.put("reg", "\u00ae");
        this.charMap.put("sup1", "\u00b9");
        this.charMap.put("THORN", "\u00de");
        this.charMap.put("ordm", "\u00ba");
        this.charMap.put("eth", "\u00f0");
        this.charMap.put("Acirc", "\u00c2");
        this.charMap.put("aring", "\u00e5");
        this.charMap.put("Uacute", "\u00da");
        this.charMap.put("oslash", "\u00f8");
        this.charMap.put("eacute", "\u00e9");
        this.charMap.put("agrave", "\u00e0");
        this.charMap.put("Ecirc", "\u00ca");
        this.charMap.put("laquo", "\u00ab");
        this.charMap.put("Igrave", "\u00cc");
        this.charMap.put("Agrave", "\u00c0");
        this.charMap.put("macr", "\u00af");
        this.charMap.put("Ucirc", "\u00db");
        this.charMap.put("igrave", "\u00ec");
        this.charMap.put("ouml", "\u00f6");
        this.charMap.put("iexcl", "\u00a1");
        this.charMap.put("otilde", "\u00f5");
        this.charMap.put("ugrave", "\u00f9");
        this.charMap.put("Aring", "\u00c5");
        this.charMap.put("Ograve", "\u00d2");
        this.charMap.put("Ugrave", "\u00d9");
        this.charMap.put("ograve", "\u00f2");
        this.charMap.put("acute", "\u00b4");
        this.charMap.put("ecirc", "\u00ea");
        this.charMap.put("euro", "\u20ac");
        this.charMap.put("uacute", "\u00fa");
        this.charMap.put("shy", "\\u00AD");
        this.charMap.put("cedil", "\u00b8");
        this.charMap.put("raquo", "\u00bb");
        this.charMap.put("Atilde", "\u00c3");
        this.charMap.put("Iuml", "\u00cf");
        this.charMap.put("iacute", "\u00ed");
        this.charMap.put("ocirc", "\u00f4");
        this.charMap.put("curren", "\u00a4");
        this.charMap.put("frac34", "\u00be");
        this.charMap.put("Euml", "\u00cb");
        this.charMap.put("szlig", "\u00df");
        this.charMap.put("pound", "\u00a3");
        this.charMap.put("not", "\u00ac");
        this.charMap.put("AElig", "\u00c6");
        this.charMap.put("times", "\u00d7");
        this.charMap.put("Aacute", "\u00c1");
        this.charMap.put("Icirc", "\u00ce");
        this.charMap.put("para", "\u00b6");
        this.charMap.put("uml", "\u00a8");
        this.charMap.put("oacute", "\u00f3");
        this.charMap.put("copy", "\u00a9");
        this.charMap.put("Eacute", "\u00c9");
        this.charMap.put("Oslash", "\u00d8");
        this.charMap.put("divid", "\u00f7");
        this.charMap.put("aelig", "\u00e6");
        this.charMap.put("euml", "\u00eb");
        this.charMap.put("Ocirc", "\u00d4");
        this.charMap.put("yen", "\u00a5");
        this.charMap.put("ntilde", "\u00f1");
        this.charMap.put("Ntilde", "\u00d1");
        this.charMap.put("thorn", "\u00fe");
        this.charMap.put("yacute", "\u00fd");
        this.charMap.put("Auml", "\u00c4");
        this.charMap.put("Yacute", "\u00dd");
        this.charMap.put("ccedil", "\u00e7");
        this.charMap.put("micro", "\u00b5");
        this.charMap.put("Ccedil", "\u00c7");
        this.charMap.put("sect", "\u00a7");
        this.charMap.put("icirc", "\u00ee");
        this.charMap.put("middot", "\u00b7");
        this.charMap.put("Uuml", "\u00dc");
        this.charMap.put("ETH", "\u00d0");
        this.charMap.put("egrave", "\u00e8");
        this.charMap.put("iuml", "\u00ef");
        this.charMap.put("plusmn", "\u00b1");
        this.charMap.put("acirc", "\u00e2");
        this.charMap.put("auml", "\u00e4");
        this.charMap.put("Egrave", "\u00c8");
    }
}

