/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import org.apache.commons.io.IOUtils;
import org.apache.james.transport.SMIMEKeyHolder;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.base.GenericMailet;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.mail.smime.SMIMEEnveloped;
import org.bouncycastle.mail.smime.SMIMEUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMIMEDecrypt
extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(SMIMEDecrypt.class);
    private SMIMEKeyHolder keyHolder;
    private X509CertificateHolder certificateHolder;
    private AttributeName mailAttribute = AttributeName.of("org.apache.james.SMIMEDecrypt");

    @Override
    public void init() throws MessagingException {
        super.init();
        MailetConfig config = this.getMailetConfig();
        String privateStoreType = config.getInitParameter("keyStoreType");
        String privateStoreFile = config.getInitParameter("keyStoreFileName");
        if (privateStoreFile == null) {
            throw new MessagingException("No keyStoreFileName specified");
        }
        String privateStorePass = config.getInitParameter("keyStorePassword");
        String keyAlias = config.getInitParameter("keyAlias");
        String keyPass = config.getInitParameter("keyAliasPassword");
        String mailAttributeConf = config.getInitParameter("mailAttribute");
        if (mailAttributeConf != null) {
            this.mailAttribute = AttributeName.of(mailAttributeConf);
        }
        try {
            this.keyHolder = new SMIMEKeyHolder(privateStoreFile, privateStorePass, keyAlias, keyPass, privateStoreType);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new MessagingException("Error loading keystore", e);
        }
        this.certificateHolder = this.from(this.keyHolder.getCertificate());
    }

    private X509CertificateHolder from(X509Certificate certificate) throws MessagingException {
        try {
            return new X509CertificateHolder(certificate.getEncoded());
        }
        catch (IOException | CertificateEncodingException e) {
            throw new MessagingException("Error during the parsing of the certificate", e);
        }
    }

    @Override
    public void service(Mail mail) throws MessagingException {
        MimeMessage message = mail.getMessage();
        MimeBodyPart strippedMessage = null;
        LOGGER.info("Starting message decryption..");
        if (message.isMimeType("application/x-pkcs7-mime") || message.isMimeType("application/pkcs7-mime")) {
            try {
                SMIMEEnveloped env = new SMIMEEnveloped(message);
                RecipientInformationStore informationStore = env.getRecipientInfos();
                Collection<RecipientInformation> recipients = informationStore.getRecipients();
                for (RecipientInformation info : recipients) {
                    RecipientId id = info.getRID();
                    if (id.match(this.certificateHolder)) {
                        try {
                            JceKeyTransEnvelopedRecipient recipient = new JceKeyTransEnvelopedRecipient(this.keyHolder.getPrivateKey());
                            strippedMessage = SMIMEUtil.toMimeBodyPart(info.getContent(recipient));
                            LOGGER.info("Encrypted message decrypted");
                            continue;
                        }
                        catch (Exception e) {
                            throw new MessagingException("Error during the decryption of the message", e);
                        }
                    }
                    LOGGER.info("Found an encrypted message but it isn't encrypted for the supplied key");
                }
            }
            catch (CMSException e) {
                throw new MessagingException("Error during the decryption of the message", e);
            }
        }
        if (strippedMessage != null) {
            ArrayList list = new ArrayList(1);
            try {
                list.add(AttributeValue.of(this.keyHolder.getCertificate().getEncoded()));
            }
            catch (CertificateEncodingException e) {
                LOGGER.warn("Failed to encode certificate", e);
            }
            mail.setAttribute(new Attribute(this.mailAttribute, AttributeValue.of(list)));
            try {
                MimeMessage newMessage = new MimeMessage(message);
                newMessage.setText(this.text(strippedMessage), StandardCharsets.UTF_8.name());
                if (!strippedMessage.isMimeType("multipart/*")) {
                    newMessage.setDisposition(null);
                }
                newMessage.saveChanges();
                mail.setMessage(newMessage);
            }
            catch (IOException e) {
                LOGGER.error("Error during the strip of the encrypted message", e);
                throw new MessagingException("Error during the stripping of the encrypted message", e);
            }
        }
    }

    private String text(Part mimePart) throws IOException, MessagingException {
        return IOUtils.toString(mimePart.getDataHandler().getInputStream(), StandardCharsets.UTF_8);
    }
}

