/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.protocol;

import com.datastax.oss.driver.internal.core.protocol.ByteBufSegmentBuilder;
import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.protocol.internal.FrameCodec;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class FrameToSegmentEncoder
extends ChannelOutboundHandlerAdapter {
    private final PrimitiveCodec<ByteBuf> primitiveCodec;
    private final FrameCodec<ByteBuf> frameCodec;
    private final String logPrefix;
    private ByteBufSegmentBuilder segmentBuilder;

    public FrameToSegmentEncoder(@NonNull PrimitiveCodec<ByteBuf> primitiveCodec, @NonNull FrameCodec<ByteBuf> frameCodec, @NonNull String logPrefix) {
        this.primitiveCodec = primitiveCodec;
        this.frameCodec = frameCodec;
        this.logPrefix = logPrefix;
    }

    public void handlerAdded(@NonNull ChannelHandlerContext ctx) {
        this.segmentBuilder = new ByteBufSegmentBuilder(ctx, this.primitiveCodec, this.frameCodec, this.logPrefix);
    }

    public void write(@NonNull ChannelHandlerContext ctx, @NonNull Object msg, @NonNull ChannelPromise promise) throws Exception {
        if (msg instanceof Frame) {
            this.segmentBuilder.addFrame((Frame)msg, promise);
        } else {
            super.write(ctx, msg, promise);
        }
    }

    public void flush(@NonNull ChannelHandlerContext ctx) throws Exception {
        this.segmentBuilder.flush();
        super.flush(ctx);
    }
}

