/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.mac;

import com.google.crypto.tink.AccessesPartialKey;
import com.google.crypto.tink.Key;
import com.google.crypto.tink.mac.AesCmacParameters;
import com.google.crypto.tink.mac.MacKey;
import com.google.crypto.tink.util.Bytes;
import com.google.crypto.tink.util.SecretBytes;
import com.google.errorprone.annotations.RestrictedApi;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.Objects;
import javax.annotation.Nullable;

public final class AesCmacKey
extends MacKey {
    private final AesCmacParameters parameters;
    private final SecretBytes aesKeyBytes;
    @Nullable
    private final Integer idRequirement;

    private AesCmacKey(AesCmacParameters parameters, SecretBytes aesKeyBytes, @Nullable Integer idRequirement) {
        this.parameters = parameters;
        this.aesKeyBytes = aesKeyBytes;
        this.idRequirement = idRequirement;
    }

    @RestrictedApi(explanation="Accessing parts of keys can produce unexpected incompatibilities", link="https://developers.google.com/tink/design/access_control#accessing_partial_keys", allowedOnPath=".*Test\\.java", allowlistAnnotations={AccessesPartialKey.class})
    public static AesCmacKey create(AesCmacParameters parameters, SecretBytes aesKey) throws GeneralSecurityException {
        if (aesKey.size() != 32) {
            throw new GeneralSecurityException("Invalid key size");
        }
        if (parameters.hasIdRequirement()) {
            throw new GeneralSecurityException("Must use createForKeyset for parameters with ID requirement");
        }
        return new AesCmacKey(parameters, aesKey, null);
    }

    @RestrictedApi(explanation="Accessing parts of keys can produce unexpected incompatibilities", link="https://developers.google.com/tink/design/access_control#accessing_partial_keys", allowedOnPath=".*Test\\.java", allowlistAnnotations={AccessesPartialKey.class})
    public static AesCmacKey createForKeyset(AesCmacParameters parameters, SecretBytes aesKeyBytes, @Nullable Integer idRequirement) throws GeneralSecurityException {
        if (aesKeyBytes.size() != 32) {
            throw new GeneralSecurityException("Invalid key size");
        }
        if (parameters.hasIdRequirement() && idRequirement == null) {
            throw new GeneralSecurityException("Cannot create key without ID requirement with format with ID requirement");
        }
        if (!parameters.hasIdRequirement() && idRequirement != null) {
            throw new GeneralSecurityException("Cannot create key with ID requirement with format without ID requirement");
        }
        return new AesCmacKey(parameters, aesKeyBytes, idRequirement);
    }

    @RestrictedApi(explanation="Accessing parts of keys can produce unexpected incompatibilities", link="https://developers.google.com/tink/design/access_control#accessing_partial_keys", allowedOnPath=".*Test\\.java", allowlistAnnotations={AccessesPartialKey.class})
    public SecretBytes getAesKey() {
        return this.aesKeyBytes;
    }

    @Override
    public Bytes getOutputPrefix() {
        if (this.parameters.getVariant() == AesCmacParameters.Variant.NO_PREFIX) {
            return Bytes.copyFrom(new byte[0]);
        }
        if (this.parameters.getVariant() == AesCmacParameters.Variant.LEGACY || this.parameters.getVariant() == AesCmacParameters.Variant.CRUNCHY) {
            return Bytes.copyFrom(ByteBuffer.allocate(5).put((byte)0).putInt(this.idRequirement).array());
        }
        if (this.parameters.getVariant() == AesCmacParameters.Variant.TINK) {
            return Bytes.copyFrom(ByteBuffer.allocate(5).put((byte)1).putInt(this.idRequirement).array());
        }
        throw new IllegalStateException("Unknown AesCmacParameters.Variant: " + this.parameters.getVariant());
    }

    @Override
    public AesCmacParameters getParameters() {
        return this.parameters;
    }

    @Override
    @Nullable
    public Integer getIdRequirementOrNull() {
        return this.idRequirement;
    }

    @Override
    public boolean equalsKey(Key o) {
        if (!(o instanceof AesCmacKey)) {
            return false;
        }
        AesCmacKey that = (AesCmacKey)o;
        return that.parameters.equals(this.parameters) && that.aesKeyBytes.equalsSecretBytes(this.aesKeyBytes) && Objects.equals(that.idRequirement, this.idRequirement);
    }
}

