/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.cassandra;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.rrt.cassandra.tables.CassandraMappingsSourcesTable;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraMappingsSourcesDAO {
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement insertStatement;
    private final PreparedStatement deleteStatement;
    private final PreparedStatement retrieveSourcesStatement;
    private final PreparedStatement truncateStatement;

    @Inject
    public CassandraMappingsSourcesDAO(CqlSession session) {
        this.executor = new CassandraAsyncExecutor(session);
        this.insertStatement = session.prepare(QueryBuilder.insertInto((String)"mappings_sources").value(CassandraMappingsSourcesTable.MAPPING_TYPE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMappingsSourcesTable.MAPPING_TYPE)).value(CassandraMappingsSourcesTable.MAPPING_VALUE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMappingsSourcesTable.MAPPING_VALUE)).value(CassandraMappingsSourcesTable.SOURCE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMappingsSourcesTable.SOURCE)).build());
        this.deleteStatement = session.prepare(((Delete)((Delete)((Delete)QueryBuilder.deleteFrom((String)"mappings_sources").whereColumn(CassandraMappingsSourcesTable.MAPPING_TYPE).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMappingsSourcesTable.MAPPING_TYPE))).whereColumn(CassandraMappingsSourcesTable.MAPPING_VALUE).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMappingsSourcesTable.MAPPING_VALUE))).whereColumn(CassandraMappingsSourcesTable.SOURCE).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMappingsSourcesTable.SOURCE))).build());
        this.retrieveSourcesStatement = session.prepare(((Select)((Select)QueryBuilder.selectFrom((String)"mappings_sources").column(CassandraMappingsSourcesTable.SOURCE).whereColumn(CassandraMappingsSourcesTable.MAPPING_TYPE).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMappingsSourcesTable.MAPPING_TYPE))).whereColumn(CassandraMappingsSourcesTable.MAPPING_VALUE).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMappingsSourcesTable.MAPPING_VALUE))).build());
        this.truncateStatement = session.prepare(QueryBuilder.truncate((String)"mappings_sources").build());
    }

    public Mono<Void> addMapping(Mapping mapping, MappingSource source) {
        return this.executor.executeVoid((Statement)((BoundStatement)((BoundStatement)this.insertStatement.bind(new Object[0]).setString(CassandraMappingsSourcesTable.MAPPING_TYPE, mapping.getType().asPrefix())).setString(CassandraMappingsSourcesTable.MAPPING_VALUE, mapping.getMappingValue())).setString(CassandraMappingsSourcesTable.SOURCE, source.asMailAddressString()));
    }

    Mono<Void> removeMapping(Mapping mapping, MappingSource source) {
        return this.executor.executeVoid((Statement)((BoundStatement)((BoundStatement)this.deleteStatement.bind(new Object[0]).setString(CassandraMappingsSourcesTable.MAPPING_TYPE, mapping.getType().asPrefix())).setString(CassandraMappingsSourcesTable.MAPPING_VALUE, mapping.getMappingValue())).setString(CassandraMappingsSourcesTable.SOURCE, source.asMailAddressString()));
    }

    public Flux<MappingSource> retrieveSources(Mapping mapping) {
        return this.executor.executeRows((Statement)((BoundStatement)this.retrieveSourcesStatement.bind(new Object[0]).setString(CassandraMappingsSourcesTable.MAPPING_TYPE, mapping.getType().asPrefix())).setString(CassandraMappingsSourcesTable.MAPPING_VALUE, mapping.getMappingValue())).map(row -> MappingSource.parse((String)row.getString(CassandraMappingsSourcesTable.SOURCE)));
    }

    public Mono<Void> removeAllData() {
        return this.executor.executeVoid((Statement)this.truncateStatement.bind(new Object[0]));
    }
}

