/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import javax.inject.Inject;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.SubscribeRequest;
import org.apache.james.imap.processor.AbstractSubscriptionProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.exception.SubscriptionException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class SubscribeProcessor
extends AbstractSubscriptionProcessor<SubscribeRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscribeProcessor.class);

    @Inject
    public SubscribeProcessor(MailboxManager mailboxManager, SubscriptionManager subscriptionManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(SubscribeRequest.class, mailboxManager, subscriptionManager, factory, metricFactory);
    }

    @Override
    protected Mono<Void> doProcessRequest(SubscribeRequest request, ImapSession session, ImapProcessor.Responder responder) {
        MailboxPath mailboxPath = PathConverter.forSession(session).buildFullPath(request.getMailboxName());
        MailboxSession mailboxSession = session.getMailboxSession();
        return Mono.from((Publisher)this.getSubscriptionManager().subscribeReactive(mailboxPath, mailboxSession)).then(this.unsolicitedResponses(session, responder, false)).then(Mono.fromRunnable(() -> this.okComplete(request, responder))).onErrorResume(SubscriptionException.class, e -> {
            this.no(request, responder, HumanReadableText.GENERIC_SUBSCRIPTION_FAILURE);
            return ReactorUtils.logAsMono(() -> LOGGER.info("Subscribe failed for mailbox {}", (Object)request.getMailboxName(), (Object)e));
        }).then();
    }

    @Override
    protected MDCBuilder mdc(SubscribeRequest message) {
        return MDCBuilder.create().addToContext("action", "SUBSCRIBE").addToContext("mailbox", message.getMailboxName());
    }
}

