/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mdn.modifier;

import com.google.common.base.Preconditions;
import java.util.Objects;

public class DispositionModifier {
    public static final DispositionModifier Error = new DispositionModifier("error");
    public static final DispositionModifier Expired = new DispositionModifier("expired");
    public static final DispositionModifier Failed = new DispositionModifier("failed");
    public static final DispositionModifier MailboxTerminated = new DispositionModifier("mailbox-terminated");
    public static final DispositionModifier Superseded = new DispositionModifier("superseded");
    public static final DispositionModifier Warning = new DispositionModifier("warning");
    private final String value;

    public DispositionModifier(String value) {
        Preconditions.checkNotNull(value);
        Preconditions.checkArgument(!value.contains("\n"), "Multiline Disposition modifier are forbiden");
        String trimmedValue = value.trim();
        Preconditions.checkArgument(!trimmedValue.isEmpty(), "Disposition modifier can not be empty");
        this.value = trimmedValue;
    }

    public String getValue() {
        return this.value;
    }

    public final boolean equals(Object o) {
        if (o instanceof DispositionModifier) {
            DispositionModifier that = (DispositionModifier)o;
            return Objects.equals(this.value, that.value);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.getValue();
    }
}

