/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import jakarta.activation.MimeType;
import jakarta.activation.MimeTypeParseException;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.core.MailAddress;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetException;
import org.apache.mailet.base.GenericMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HasMimeTypeParameter
extends GenericMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(HasMimeTypeParameter.class);
    @VisibleForTesting
    List<Pair<String, String>> filteredMimeTypeParameters;

    public void init() throws MessagingException {
        this.filteredMimeTypeParameters = this.parseConfigurationString(Optional.ofNullable(this.getCondition()));
    }

    private List<Pair<String, String>> parseConfigurationString(Optional<String> maybeConfiguration) {
        return maybeConfiguration.map(this.tokenizeConfiguration()).orElse((List<Pair<String, String>>)ImmutableList.of());
    }

    private Function<String, List<Pair<String, String>>> tokenizeConfiguration() {
        return Throwing.function(value -> {
            try {
                return (List)Splitter.on((String)",").trimResults().splitToStream((CharSequence)value).map(this::conditionToPair).collect(ImmutableList.toImmutableList());
            }
            catch (IllegalArgumentException e) {
                throw new MailetException("error parsing configuration", (Exception)e);
            }
        }).sneakyThrow();
    }

    private Pair<String, String> conditionToPair(String s) {
        Preconditions.checkArgument((boolean)s.contains("="));
        List pairElements = Splitter.on((String)"=").limit(2).splitToList((CharSequence)s);
        this.validateCondition(pairElements);
        return Pair.of((Object)((String)pairElements.get(0)), (Object)this.unQuote((String)pairElements.get(1)));
    }

    private void validateCondition(List<String> pairElements) {
        Preconditions.checkArgument((boolean)pairElements.stream().noneMatch(Strings::isNullOrEmpty), (Object)"Empty name or value for the parameter argument");
    }

    private String unQuote(String value) {
        return StringUtils.unwrap((String)value, (char)'\"');
    }

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        Optional<MimeType> maybeMimeType = this.getMimeTypeFromMessage(mail.getMessage());
        if (maybeMimeType.map(this::mimeTypeMatchParameter).orElse(false).booleanValue()) {
            return mail.getRecipients();
        }
        return ImmutableList.of();
    }

    private Optional<MimeType> getMimeTypeFromMessage(MimeMessage message) throws MessagingException {
        try {
            return Optional.of(new MimeType(message.getContentType()));
        }
        catch (MimeTypeParseException e) {
            LOGGER.warn("Error while parsing message's mimeType {}", (Object)message.getContentType(), (Object)e);
            return Optional.empty();
        }
    }

    private boolean mimeTypeMatchParameter(MimeType mimeType) {
        return this.filteredMimeTypeParameters.stream().anyMatch(entry -> this.mimeTypeContainsParameter(mimeType, (String)entry.getKey(), (String)entry.getValue()));
    }

    private boolean mimeTypeContainsParameter(MimeType mimeType, String name, String value) {
        return Optional.ofNullable(mimeType.getParameter(name)).map(value::equals).orElse(false);
    }
}

