/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.client.SendAcknowledgementHandler;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionContinuationMessage;

public class SessionSendContinuationMessage
extends SessionContinuationMessage {
    protected boolean requiresResponse;
    protected Message message;
    private final transient SendAcknowledgementHandler handler;
    protected long messageBodySize = -1L;

    public SessionSendContinuationMessage() {
        super((byte)73);
        this.handler = null;
    }

    protected SessionSendContinuationMessage(byte type) {
        super(type);
        this.handler = null;
    }

    public SessionSendContinuationMessage(Message message, byte[] body, boolean continues, boolean requiresResponse, long messageBodySize, SendAcknowledgementHandler handler) {
        super((byte)73, body, continues);
        this.requiresResponse = requiresResponse;
        this.message = message;
        this.handler = handler;
        this.messageBodySize = messageBodySize;
    }

    protected SessionSendContinuationMessage(byte type, Message message, byte[] body, boolean continues, boolean requiresResponse, long messageBodySize, SendAcknowledgementHandler handler) {
        super(type, body, continues);
        this.requiresResponse = requiresResponse;
        this.message = message;
        this.handler = handler;
        this.messageBodySize = messageBodySize;
    }

    @Override
    public boolean isRequiresResponse() {
        return this.requiresResponse;
    }

    public long getMessageBodySize() {
        return this.messageBodySize;
    }

    public Message getMessage() {
        return this.message;
    }

    @Override
    public int expectedEncodeSize() {
        return super.expectedEncodeSize() + (!this.continues ? 8 : 0) + 1;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        super.encodeRest(buffer);
        if (!this.continues) {
            buffer.writeLong(this.messageBodySize);
        }
        buffer.writeBoolean(this.requiresResponse);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        super.decodeRest(buffer);
        if (!this.continues) {
            this.messageBodySize = buffer.readLong();
        }
        this.requiresResponse = buffer.readBoolean();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (int)(this.messageBodySize ^ this.messageBodySize >>> 32);
        result = 31 * result + (this.requiresResponse ? 1231 : 1237);
        return result;
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", continues=" + this.continues);
        sb.append(", message=" + String.valueOf(this.message));
        sb.append(", messageBodySize=" + this.messageBodySize);
        sb.append(", requiresResponse=" + this.requiresResponse);
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionSendContinuationMessage)) {
            return false;
        }
        SessionSendContinuationMessage other = (SessionSendContinuationMessage)obj;
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.messageBodySize != other.messageBodySize) {
            return false;
        }
        return this.requiresResponse == other.requiresResponse;
    }

    public SendAcknowledgementHandler getHandler() {
        return this.handler;
    }

    public int getSenderID() {
        return -1;
    }
}

