/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.exception;

import io.r2dbc.spi.R2dbcException;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.exception.ExceptionTools;
import org.jooq.exception.SQLStateClass;
import org.jooq.exception.SQLStateSubclass;
import org.jooq.tools.StringUtils;

public class DataAccessException
extends RuntimeException {
    SQLStateClass sqlStateClass;
    SQLStateSubclass sqlStateSubclass;

    public DataAccessException(String message) {
        super(message);
    }

    public DataAccessException(String message, Throwable cause) {
        super(message, cause);
    }

    @NotNull
    public String sqlState() {
        SQLException s = this.getCause(SQLException.class);
        if (s != null) {
            return StringUtils.defaultIfNull(s.getSQLState(), "00000");
        }
        R2dbcException r = this.getCause(R2dbcException.class);
        if (r != null) {
            return StringUtils.defaultIfNull(r.getSqlState(), "00000");
        }
        return "00000";
    }

    @NotNull
    public SQLStateClass sqlStateClass() {
        if (this.sqlStateClass != null) {
            return this.sqlStateClass;
        }
        SQLException s = this.getCause(SQLException.class);
        if (s != null) {
            return DataAccessException.sqlStateClass(s);
        }
        R2dbcException r = this.getCause(R2dbcException.class);
        if (r != null) {
            return DataAccessException.sqlStateClass(r);
        }
        return SQLStateClass.NONE;
    }

    public DataAccessException sqlStateClass(SQLStateClass c) {
        this.sqlStateClass = c;
        return this;
    }

    @NotNull
    public static SQLStateClass sqlStateClass(SQLException e) {
        if (e.getSQLState() != null) {
            return SQLStateClass.fromCode(e.getSQLState());
        }
        if (DataAccessException.causePrefix(e, "org.sqlite")) {
            return SQLStateClass.fromSQLiteVendorCode(e.getErrorCode());
        }
        if (DataAccessException.causePrefix(e, "io.trino")) {
            return SQLStateClass.fromTrinoVendorCode(e.getErrorCode());
        }
        return SQLStateClass.NONE;
    }

    private static final boolean causePrefix(SQLException e, String prefix) {
        return e.getClass().getName().startsWith(prefix) || e.getCause() != null && e.getCause().getClass().getName().startsWith(prefix);
    }

    @NotNull
    public static SQLStateClass sqlStateClass(R2dbcException e) {
        if (e.getSqlState() != null) {
            return SQLStateClass.fromCode(e.getSqlState());
        }
        return SQLStateClass.NONE;
    }

    public DataAccessException sqlStateSubclass(SQLStateSubclass c) {
        this.sqlStateSubclass = c;
        return this;
    }

    @NotNull
    public SQLStateSubclass sqlStateSubclass() {
        if (this.sqlStateSubclass != null) {
            return this.sqlStateSubclass;
        }
        return SQLStateSubclass.fromCode(this.sqlState());
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        return super.getStackTrace();
    }

    @Nullable
    public <T extends Throwable> T getCause(Class<? extends T> type) {
        return ExceptionTools.getCause(this, type);
    }
}

