/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.util.CollectionFactory;
import org.apache.jena.util.iterator.NiceIterator;

public abstract class ObjectIterator
extends NiceIterator<Node> {
    final Iterator<?> domain;
    final Set<Node> seen = CollectionFactory.createHashedSet();
    final List<Node> pending = new ArrayList<Node>();

    public ObjectIterator(Iterator<?> domain) {
        this.domain = domain;
    }

    protected abstract Iterator<Triple> iteratorFor(Object var1);

    @Override
    public boolean hasNext() {
        while (this.pending.isEmpty() && this.domain.hasNext()) {
            this.refillPending();
        }
        return !this.pending.isEmpty();
    }

    @Override
    public Node next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("ObjectIterator.next()");
        }
        return this.pending.remove(this.pending.size() - 1);
    }

    public void forEachRemaining(Consumer<? super Node> action) {
        this.pending.forEach(action);
        this.domain.forEachRemaining((? super E y) -> {
            if (y instanceof Node) {
                action.accept((Node)y);
            } else {
                this.iteratorFor(y).forEachRemaining((? super E triple) -> {
                    if (this.seen.add(triple.getObject())) {
                        action.accept(triple.getObject());
                    }
                });
            }
        });
    }

    protected void refillPending() {
        Object y = this.domain.next();
        if (y instanceof Node) {
            this.pending.add((Node)y);
        } else {
            this.iteratorFor(y).forEachRemaining((? super E triple) -> {
                if (this.seen.add(triple.getObject())) {
                    this.pending.add(triple.getObject());
                }
            });
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("listObjects remove()");
    }
}

