/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.gui.JBooleanPropertyEditor;
import org.apache.jmeter.gui.JTextComponentBinding;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.protocol.http.config.gui.UrlConfigGui;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBaseSchema;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerFactory;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerProxy;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.schema.PropertyDescriptor;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JEditableCheckBox;
import org.apache.jorphan.gui.JFactory;

@GUIMenuSortOrder(value=1)
@TestElementMetadata(labelResource="web_testing_title")
public class HttpTestSampleGui
extends AbstractSamplerGui {
    private static final long serialVersionUID = 242L;
    private UrlConfigGui urlConfigGui;
    private final JBooleanPropertyEditor retrieveEmbeddedResources = new JBooleanPropertyEditor(HTTPSamplerBaseSchema.INSTANCE.getRetrieveEmbeddedResources(), JMeterUtils.getResString((String)"web_testing_retrieve_images"));
    private final JBooleanPropertyEditor concurrentDwn = new JBooleanPropertyEditor(HTTPSamplerBaseSchema.INSTANCE.getConcurrentDownload(), JMeterUtils.getResString((String)"web_testing_concurrent_download"));
    private JTextField concurrentPool;
    private final JBooleanPropertyEditor useMD5 = new JBooleanPropertyEditor(HTTPSamplerBaseSchema.INSTANCE.getStoreAsMD5(), JMeterUtils.getResString((String)"response_save_as_md5"));
    private JTextField embeddedAllowRE;
    private JTextField embeddedExcludeRE;
    private JTextField sourceIpAddr;
    private final JComboBox<String> sourceIpType = new JComboBox<String>(HTTPSamplerBase.getSourceTypeList());
    private JTextField proxyScheme;
    private JTextField proxyHost;
    private JTextField proxyPort;
    private JTextField proxyUser;
    private JPasswordField proxyPass;
    private final JComboBox<String> httpImplementation = new JComboBox<String>(HTTPSamplerFactory.getImplementations());
    private JTextField connectTimeOut;
    private JTextField responseTimeOut;
    private final boolean isAJP;

    public HttpTestSampleGui() {
        this(false);
    }

    protected HttpTestSampleGui(boolean ajp) {
        this.isAJP = ajp;
        this.init();
        HTTPSamplerBaseSchema.INSTANCE schema = HTTPSamplerBaseSchema.INSTANCE;
        this.bindingGroup.addAll(Arrays.asList(this.retrieveEmbeddedResources, this.concurrentDwn, new JTextComponentBinding((JTextComponent)this.concurrentPool, schema.getConcurrentDownloadPoolSize()), this.useMD5, new JTextComponentBinding((JTextComponent)this.embeddedAllowRE, schema.getEmbeddedUrlAllowRegex()), new JTextComponentBinding((JTextComponent)this.embeddedExcludeRE, schema.getEmbeddedUrlExcludeRegex())));
        if (!this.isAJP) {
            this.bindingGroup.addAll(Arrays.asList(new JTextComponentBinding((JTextComponent)this.sourceIpAddr, schema.getIpSource()), new JTextComponentBinding((JTextComponent)this.proxyScheme, schema.getProxy().getScheme()), new JTextComponentBinding((JTextComponent)this.proxyHost, schema.getProxy().getHost()), new JTextComponentBinding((JTextComponent)this.proxyPort, schema.getProxy().getPort()), new JTextComponentBinding((JTextComponent)this.proxyUser, schema.getProxy().getUsername()), new JTextComponentBinding((JTextComponent)this.proxyPass, schema.getProxy().getPassword()), new JTextComponentBinding((JTextComponent)this.connectTimeOut, schema.getConnectTimeout()), new JTextComponentBinding((JTextComponent)this.responseTimeOut, schema.getResponseTimeout())));
        }
    }

    public void configure(TestElement element) {
        super.configure(element);
        HTTPSamplerBase samplerBase = (HTTPSamplerBase)element;
        HTTPSamplerBaseSchema.INSTANCE httpSchema = HTTPSamplerBaseSchema.INSTANCE;
        this.urlConfigGui.configure(element);
        if (!this.isAJP) {
            this.sourceIpType.setSelectedIndex(samplerBase.getIpSourceType());
            this.httpImplementation.setSelectedItem(samplerBase.getString((PropertyDescriptor)httpSchema.getImplementation()));
        }
    }

    public TestElement makeTestElement() {
        return new HTTPSamplerProxy();
    }

    public void assignDefaultValues(TestElement element) {
        super.assignDefaultValues(element);
        HTTPSamplerBaseSchema.INSTANCE schema = HTTPSamplerBaseSchema.INSTANCE;
        element.set(schema.getMethod(), "GET");
        element.set(schema.getFollowRedirects(), Boolean.valueOf(true));
        element.set(schema.getUseKeepalive(), Boolean.valueOf(true));
        this.urlConfigGui.assignDefaultValues(element);
    }

    public void modifyTestElement(TestElement sampler) {
        super.modifyTestElement(sampler);
        this.urlConfigGui.modifyTestElement(sampler);
        HTTPSamplerBase samplerBase = (HTTPSamplerBase)sampler;
        HTTPSamplerBaseSchema httpSchema = samplerBase.getSchema();
        this.enableConcurrentDwn();
        if (!this.isAJP) {
            if (!StringUtils.isEmpty((CharSequence)this.sourceIpAddr.getText())) {
                samplerBase.set(httpSchema.getIpSourceType(), this.sourceIpType.getSelectedIndex());
            } else {
                samplerBase.removeProperty((PropertyDescriptor)httpSchema.getIpSourceType());
            }
            String selectedImplementation = String.valueOf(this.httpImplementation.getSelectedItem());
            samplerBase.set((PropertyDescriptor)httpSchema.getImplementation(), (String)StringUtils.defaultIfBlank((CharSequence)selectedImplementation, null));
        }
    }

    public String getLabelResource() {
        return "web_testing_title";
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(BorderFactory.createEmptyBorder());
        JTabbedPane tabbedPane = this.createTabbedConfigPane();
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.setBorder(this.makeBorder());
        wrapper.add((Component)this.makeTitlePanel(), "Center");
        JSplitPane splitPane = new JSplitPane(0, wrapper, tabbedPane);
        splitPane.setBorder(BorderFactory.createEmptyBorder());
        splitPane.setOneTouchExpandable(true);
        this.add(splitPane);
    }

    protected JTabbedPane createTabbedConfigPane() {
        JTabbedPane tabbedPane = new JTabbedPane();
        this.urlConfigGui = this.createUrlConfigGui();
        tabbedPane.add(JMeterUtils.getResString((String)"web_testing_basic"), this.urlConfigGui);
        JPanel advancedPanel = this.createAdvancedConfigPanel();
        tabbedPane.add(JMeterUtils.getResString((String)"web_testing_advanced"), advancedPanel);
        return tabbedPane;
    }

    protected UrlConfigGui createUrlConfigGui() {
        UrlConfigGui configGui = new UrlConfigGui(true, true, true);
        configGui.setBorder(this.makeBorder());
        return configGui;
    }

    private JPanel createAdvancedConfigPanel() {
        HorizontalPanel httpOptions = new HorizontalPanel();
        httpOptions.add(this.getImplementationPanel());
        httpOptions.add(this.getTimeOutPanel());
        VerticalPanel advancedPanel = new VerticalPanel();
        advancedPanel.setBorder(this.makeBorder());
        if (!this.isAJP) {
            advancedPanel.add((Component)httpOptions);
        }
        advancedPanel.add(this.createEmbeddedRsrcPanel());
        if (!this.isAJP) {
            advancedPanel.add(this.createSourceAddrPanel());
            advancedPanel.add(this.getProxyServerPanel());
        }
        advancedPanel.add(this.createOptionalTasksPanel());
        return advancedPanel;
    }

    private JPanel getTimeOutPanel() {
        HorizontalPanel timeOut = new HorizontalPanel();
        timeOut.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"web_server_timeout_title")));
        JPanel connPanel = this.getConnectTimeOutPanel();
        JPanel reqPanel = this.getResponseTimeOutPanel();
        timeOut.add(connPanel);
        timeOut.add(reqPanel);
        return timeOut;
    }

    private JPanel getConnectTimeOutPanel() {
        this.connectTimeOut = new JTextField(10);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"web_server_timeout_connect"));
        label.setLabelFor(this.connectTimeOut);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.connectTimeOut, "Center");
        return panel;
    }

    private JPanel getResponseTimeOutPanel() {
        this.responseTimeOut = new JTextField(10);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"web_server_timeout_response"));
        label.setLabelFor(this.responseTimeOut);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.responseTimeOut, "Center");
        return panel;
    }

    protected JPanel createEmbeddedRsrcPanel() {
        this.retrieveEmbeddedResources.addPropertyChangeListener("value", ev -> this.enableConcurrentDwn());
        this.concurrentDwn.addPropertyChangeListener("value", ev -> this.enableConcurrentDwn());
        this.concurrentPool = new JTextField(2);
        this.concurrentPool.setMinimumSize(new Dimension(10, (int)this.concurrentPool.getPreferredSize().getHeight()));
        this.concurrentPool.setMaximumSize(new Dimension(60, (int)this.concurrentPool.getPreferredSize().getHeight()));
        JPanel embeddedRsrcPanel = new JPanel((LayoutManager)new MigLayout());
        embeddedRsrcPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"web_testing_retrieve_title")));
        embeddedRsrcPanel.add((Component)this.retrieveEmbeddedResources);
        embeddedRsrcPanel.add((Component)this.concurrentDwn);
        embeddedRsrcPanel.add((Component)this.concurrentPool, "wrap");
        this.embeddedAllowRE = HttpTestSampleGui.addTextFieldWithLabel(embeddedRsrcPanel, JMeterUtils.getResString((String)"web_testing_embedded_url_pattern"));
        this.embeddedExcludeRE = HttpTestSampleGui.addTextFieldWithLabel(embeddedRsrcPanel, JMeterUtils.getResString((String)"web_testing_embedded_url_exclude_pattern"));
        return embeddedRsrcPanel;
    }

    private static JTextField addTextFieldWithLabel(JPanel panel, String labelText) {
        JLabel label = new JLabel(labelText);
        JTextField field = new JTextField(100);
        label.setLabelFor(field);
        panel.add(label);
        panel.add((Component)field, "span");
        return field;
    }

    protected final JPanel getImplementationPanel() {
        HorizontalPanel implPanel = new HorizontalPanel();
        implPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"web_server_client")));
        implPanel.add(new JLabel(JMeterUtils.getResString((String)"http_implementation")));
        this.httpImplementation.addItem("");
        implPanel.add(this.httpImplementation);
        return implPanel;
    }

    protected JPanel createOptionalTasksPanel() {
        VerticalPanel checkBoxPanel = new VerticalPanel();
        checkBoxPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"optional_tasks")));
        checkBoxPanel.add((Component)this.useMD5);
        return checkBoxPanel;
    }

    protected JPanel createSourceAddrPanel() {
        HorizontalPanel sourceAddrPanel = new HorizontalPanel();
        sourceAddrPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"web_testing_source_ip")));
        this.sourceIpType.setSelectedIndex(HTTPSamplerBase.SourceType.HOSTNAME.ordinal());
        sourceAddrPanel.add(this.sourceIpType);
        this.sourceIpAddr = new JTextField();
        sourceAddrPanel.add(this.sourceIpAddr);
        return sourceAddrPanel;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void clearGui() {
        super.clearGui();
        this.urlConfigGui.clear();
    }

    private void enableConcurrentDwn() {
        boolean enable = !JEditableCheckBox.Value.of((boolean)false).equals(this.retrieveEmbeddedResources.getValue());
        this.concurrentDwn.setEnabled(enable);
        this.embeddedAllowRE.setEnabled(enable);
        this.embeddedExcludeRE.setEnabled(enable);
        this.concurrentPool.setEnabled(enable && !this.concurrentDwn.getValue().equals(JEditableCheckBox.Value.of((boolean)false)));
    }

    protected final JPanel getProxyServerPanel() {
        HorizontalPanel proxyServer = new HorizontalPanel();
        proxyServer.add((Component)this.getProxySchemePanel(), "West");
        proxyServer.add((Component)this.getProxyHostPanel(), "Center");
        proxyServer.add((Component)this.getProxyPortPanel(), "East");
        HorizontalPanel proxyLogin = new HorizontalPanel();
        proxyLogin.add(this.getProxyUserPanel());
        proxyLogin.add(this.getProxyPassPanel());
        HorizontalPanel proxyServerPanel = new HorizontalPanel();
        proxyServerPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"web_proxy_server_title")));
        proxyServerPanel.add((Component)proxyServer);
        proxyServerPanel.add((Component)proxyLogin);
        return proxyServerPanel;
    }

    private JPanel getProxySchemePanel() {
        this.proxyScheme = new JTextField(5);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"web_proxy_scheme"));
        label.setLabelFor(this.proxyScheme);
        JFactory.small((JLabel)label);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.proxyScheme, "Center");
        return panel;
    }

    private JPanel getProxyHostPanel() {
        this.proxyHost = new JTextField(10);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"web_server_domain"));
        label.setLabelFor(this.proxyHost);
        JFactory.small((JLabel)label);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.proxyHost, "Center");
        return panel;
    }

    private JPanel getProxyPortPanel() {
        this.proxyPort = new JTextField(10);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"web_server_port"));
        label.setLabelFor(this.proxyPort);
        JFactory.small((JLabel)label);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.proxyPort, "Center");
        return panel;
    }

    private JPanel getProxyUserPanel() {
        this.proxyUser = new JTextField(5);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"username"));
        label.setLabelFor(this.proxyUser);
        JFactory.small((JLabel)label);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.proxyUser, "Center");
        return panel;
    }

    private JPanel getProxyPassPanel() {
        this.proxyPass = new JPasswordField(5);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"password"));
        label.setLabelFor(this.proxyPass);
        JFactory.small((JLabel)label);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.proxyPass, "Center");
        return panel;
    }
}

