/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.spec.back.transform.bistro.corr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.values.Color;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002J*\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\t\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\n0\b2\u000e\u0010\u000b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\bJ\u0018\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u00062\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002J\u0018\u0010\r\u001a\u0006\u0012\u0002\b\u00030\n2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\nH\u0002J\u001e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\n2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0001\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/letsPlot/core/spec/back/transform/bistro/corr/DataUtil;", "", "()V", "needToStandardizeValues", "", "series", "", "standardiseData", "", "", "", "rawData", "standardizeIterable", "standardizeList", "toList", "key", "rawValue", "plot-stem"})
@SourceDebugExtension(value={"SMAP\nDataUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataUtil.kt\norg/jetbrains/letsPlot/core/spec/back/transform/bistro/corr/DataUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1549#2:83\n1620#2,3:84\n1747#2,3:87\n*S KotlinDebug\n*F\n+ 1 DataUtil.kt\norg/jetbrains/letsPlot/core/spec/back/transform/bistro/corr/DataUtil\n*L\n59#1:83\n59#1:84,3\n75#1:87,3\n*E\n"})
public final class DataUtil {
    @NotNull
    public static final DataUtil INSTANCE = new DataUtil();

    private DataUtil() {
    }

    @NotNull
    public final Map<String, List<Object>> standardiseData(@NotNull Map<?, ?> rawData) {
        Intrinsics.checkNotNullParameter(rawData, (String)"rawData");
        LinkedHashMap standardisedData = new LinkedHashMap();
        for (Map.Entry<?, ?> entry : rawData.entrySet()) {
            Object rawKey = entry.getKey();
            Object rawValue = entry.getValue();
            String key = String.valueOf(rawKey);
            Map map2 = standardisedData;
            Object obj = rawValue;
            Intrinsics.checkNotNull(obj);
            map2.put(key, this.toList(key, obj));
        }
        return standardisedData;
    }

    @NotNull
    public final List<Object> toList(@NotNull String key, @NotNull Object rawValue) {
        List<?> list2;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)rawValue, (String)"rawValue");
        Object object = rawValue;
        if (object instanceof List) {
            list2 = this.standardizeList((List)rawValue);
        } else if (object instanceof Iterable) {
            list2 = CollectionsKt.toList(this.standardizeIterable((Iterable)rawValue));
        } else if (object instanceof Sequence) {
            list2 = CollectionsKt.toList(this.standardizeIterable(SequencesKt.asIterable((Sequence)((Sequence)rawValue))));
        } else if (object instanceof Object[]) {
            list2 = this.standardizeList(ArraysKt.asList((Object[])((Object[])rawValue)));
        } else if (object instanceof byte[]) {
            list2 = this.standardizeList(ArraysKt.asList((byte[])((byte[])rawValue)));
        } else if (object instanceof short[]) {
            list2 = this.standardizeList(ArraysKt.asList((short[])((short[])rawValue)));
        } else if (object instanceof int[]) {
            list2 = this.standardizeList(ArraysKt.asList((int[])((int[])rawValue)));
        } else if (object instanceof long[]) {
            list2 = this.standardizeList(ArraysKt.asList((long[])((long[])rawValue)));
        } else if (object instanceof float[]) {
            list2 = this.standardizeList(ArraysKt.asList((float[])((float[])rawValue)));
        } else if (object instanceof double[]) {
            list2 = this.standardizeList(ArraysKt.asList((double[])((double[])rawValue)));
        } else if (object instanceof char[]) {
            list2 = this.standardizeList(ArraysKt.asList((char[])((char[])rawValue)));
        } else if (object instanceof Pair) {
            list2 = this.standardizeList(TuplesKt.toList((Pair)((Pair)rawValue)));
        } else {
            throw new IllegalArgumentException("Can't transform data[\"" + key + "\"] of type " + Reflection.getOrCreateKotlinClass(rawValue.getClass()).getSimpleName() + " to a list");
        }
        return list2;
    }

    private final List<?> standardizeList(List<?> series) {
        Iterable<?> iterable = this.standardizeIterable((Iterable)series);
        Intrinsics.checkNotNull(iterable, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
        return (List)iterable;
    }

    /*
     * WARNING - void declaration
     */
    private final Iterable<?> standardizeIterable(Iterable<?> series) {
        Iterable iterable;
        if (this.needToStandardizeValues(series)) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = series;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object object;
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void var11_11 = it;
                if (var11_11 == null) {
                    object = it;
                } else if (var11_11 instanceof String) {
                    object = it;
                } else if (var11_11 instanceof Number) {
                    object = DataUtil.standardizeIterable$toDouble((Number)it);
                } else if (var11_11 instanceof Character) {
                    object = String.valueOf(((Character)it).charValue());
                } else if (var11_11 instanceof Color) {
                    object = ((Color)it).toHexColor();
                } else {
                    throw new IllegalArgumentException("Can't standardize the value \"" + it + "\" of type " + Reflection.getOrCreateKotlinClass(it.getClass()).getSimpleName() + " as a string, number or date-time.");
                }
                collection.add(object);
            }
            iterable = (List)destination$iv$iv;
        } else {
            iterable = series;
        }
        return iterable;
    }

    private final boolean needToStandardizeValues(Iterable<?> series) {
        boolean bl;
        block3: {
            Iterable<?> $this$any$iv = series;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator<?> iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    double d;
                    Object element$iv;
                    Object it = element$iv = iterator.next();
                    boolean bl2 = false;
                    boolean bl3 = it != null && (!(it instanceof String) && !(it instanceof Double) || it instanceof Double && !(!Double.isInfinite(d = ((Number)it).doubleValue()) && !Double.isNaN(d)));
                    if (!bl3) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final Void standardizeIterable$noTimeZoneError(Object time) {
        throw new IllegalArgumentException("Can't convert " + Reflection.getOrCreateKotlinClass(time.getClass()).getSimpleName() + " to the number of milliseconds from the epoch of 1970-01-01T00:00:00Z.");
    }

    private static final Double standardizeIterable$toDouble(Number n) {
        double d;
        float f;
        Number number = n;
        Double d2 = number instanceof Float ? (!Float.isInfinite(f = n.floatValue()) && !Float.isNaN(f) ? Double.valueOf(n.doubleValue()) : null) : (number instanceof Double ? (!Double.isInfinite(d = n.doubleValue()) && !Double.isNaN(d) ? (Double)n : null) : Double.valueOf(n.doubleValue()));
        return d2;
    }
}

