/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.command;

import java.util.Queue;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.karaf.jaas.command.JaasCommandSupport;
import org.apache.karaf.jaas.config.JaasRealm;
import org.apache.karaf.jaas.modules.BackingEngine;
import org.apache.karaf.shell.commands.Command;

@Command(scope="jaas", name="pending-list", description="List the pending modification on the active JAAS Realm/Login Module")
public class ListPendingCommand
extends JaasCommandSupport {
    @Override
    protected Object doExecute() throws Exception {
        JaasRealm realm = (JaasRealm)this.session.get("JaasCommand.REALM");
        AppConfigurationEntry entry = (AppConfigurationEntry)this.session.get("JaasCommand.ENTRY");
        Queue commandQueue = (Queue)this.session.get("JaasCommand.COMMANDS");
        if (realm != null && entry != null) {
            String moduleClass = (String)entry.getOptions().get("org.apache.karaf.jaas.module");
            System.out.println(String.format("JAAS Realm %s/JAAS Login Module %s", realm.getName(), moduleClass));
            if (commandQueue != null && !commandQueue.isEmpty()) {
                for (JaasCommandSupport command : commandQueue) {
                    System.out.println((Object)command);
                }
            } else {
                System.err.println("No JAAS modification command in queue");
            }
        } else {
            System.err.println("No JAAS Realm/Login Module selected");
        }
        return null;
    }

    @Override
    protected Object doExecute(BackingEngine engine) throws Exception {
        return null;
    }
}

