/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.proxy.impl.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.apache.aries.proxy.InvocationListener;
import org.apache.aries.proxy.UnableToProxyException;
import org.apache.aries.proxy.impl.NLS;
import org.apache.aries.proxy.impl.ProxyUtils;
import org.apache.aries.proxy.impl.common.ConstructorFinder;
import org.apache.aries.proxy.impl.common.MethodCopyingClassAdapter;
import org.apache.aries.proxy.impl.common.TypeMethod;
import org.apache.aries.proxy.weaving.WovenProxy;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.AdviceAdapter;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWovenProxyAdapter
extends ClassVisitor
implements Opcodes {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractWovenProxyAdapter.class);
    private static final int PUBLIC_GENERATED_METHOD_ACCESS = 4113;
    static final String THROWABLE_INAME = Type.getInternalName(Throwable.class);
    private static final String UU_ID = "04df3c80_2877_4f6c_99e2_5a25e11d5535";
    static final Type[] NO_ARGS = new Type[0];
    private static final String[] annotationTypeDescriptors = new String[]{"Ljavax/persistence/Transient;"};
    protected static final String LISTENER_FIELD = "org_apache_aries_proxy_InvocationListener_04df3c80_2877_4f6c_99e2_5a25e11d5535";
    public static final String DISPATCHER_FIELD = "woven_proxy_dispatcher_04df3c80_2877_4f6c_99e2_5a25e11d5535";
    static final Type LISTENER_TYPE = Type.getType(InvocationListener.class);
    public static final Type DISPATCHER_TYPE = Type.getType(Callable.class);
    private static final Type CLASS_TYPE = Type.getType(Class.class);
    private static final Type CLASS_ARRAY_TYPE = Type.getType(Class[].class);
    private static final Type STRING_TYPE = Type.getType(String.class);
    public static final Type OBJECT_TYPE = Type.getType(Object.class);
    static final Type METHOD_TYPE = Type.getType(java.lang.reflect.Method.class);
    static final Type WOVEN_PROXY_IFACE_TYPE = Type.getType(WovenProxy.class);
    private static final Type NPE_TYPE = Type.getType(NullPointerException.class);
    private static final Type[] DISPATCHER_LISTENER_METHOD_ARGS = new Type[]{DISPATCHER_TYPE, LISTENER_TYPE};
    private static final Method ARGS_CONSTRUCTOR = new Method("<init>", Type.VOID_TYPE, DISPATCHER_LISTENER_METHOD_ARGS);
    private static final Method NO_ARGS_CONSTRUCTOR = new Method("<init>", Type.VOID_TYPE, NO_ARGS);
    private static final Method NPE_CONSTRUCTOR = new Method("<init>", Type.VOID_TYPE, new Type[]{STRING_TYPE});
    static final Method getInovcationTargetMethod = new Method("getInvocationTarget04df3c80_2877_4f6c_99e2_5a25e11d5535", OBJECT_TYPE, NO_ARGS);
    static final Method listenerPreInvokeMethod = new Method("getListener04df3c80_2877_4f6c_99e2_5a25e11d5535", OBJECT_TYPE, new Type[]{OBJECT_TYPE, Type.getType(java.lang.reflect.Method.class), Type.getType(Object[].class)});
    protected final Type typeBeingWoven;
    private Type superType;
    private final ClassLoader loader;
    private boolean implementWovenProxy = false;
    protected final List<Class<?>> nonObjectSupers = new ArrayList();
    protected final Map<String, TypeMethod> transformedMethods = new HashMap<String, TypeMethod>();
    private final Set<Method> knownMethods = new HashSet<Method>();
    private boolean superHasNoArgsConstructor = false;
    private boolean hasNoArgsConstructor = false;
    protected boolean isSerializable = false;
    private Method staticInitMethod = new Method("<clinit>", Type.VOID_TYPE, NO_ARGS);
    private int staticInitMethodFlags = 4106;
    protected Type currentMethodDeclaringType;
    protected boolean currentMethodDeclaringTypeIsInterface;
    public static final boolean IS_AT_LEAST_JAVA_6 = ProxyUtils.JAVA_CLASS_VERSION >= 50;

    public AbstractWovenProxyAdapter(ClassVisitor writer, String className, ClassLoader loader) {
        super(327680, writer);
        this.currentMethodDeclaringType = this.typeBeingWoven = Type.getType((String)("L" + className.replace('.', '/') + ";"));
        this.currentMethodDeclaringTypeIsInterface = false;
        this.loader = loader;
    }

    public final void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        LOGGER.debug("Method entry: {}, args {}", (Object)"visit", (Object)new Object[]{version, access, name, signature, superName, interfaces});
        version = ProxyUtils.JAVA_CLASS_VERSION;
        this.superType = Type.getType((String)("L" + superName + ";"));
        try {
            Class<?> superClass = Class.forName(superName.replace('/', '.'), false, this.loader);
            boolean bl = this.isSerializable = Serializable.class.isAssignableFrom(superClass) || Arrays.asList(interfaces).contains(Type.getInternalName(Serializable.class)) || this.checkInterfacesForSerializability(interfaces);
            if (!WovenProxy.class.isAssignableFrom(superClass)) {
                this.implementWovenProxy = true;
                if (superClass != Object.class) {
                    this.nonObjectSupers.add(superClass);
                    for (Class<?> nextSuper = superClass.getSuperclass(); nextSuper != Object.class; nextSuper = nextSuper.getSuperclass()) {
                        this.nonObjectSupers.add(nextSuper);
                    }
                    this.superHasNoArgsConstructor = this.superHasNoArgsConstructor(superName, name);
                } else {
                    this.superHasNoArgsConstructor = true;
                }
                String[] interfacesPlusWovenProxy = new String[interfaces.length + 1];
                System.arraycopy(interfaces, 0, interfacesPlusWovenProxy, 0, interfaces.length);
                interfacesPlusWovenProxy[interfaces.length] = WOVEN_PROXY_IFACE_TYPE.getInternalName();
                this.cv.visit(version, access, name, signature, superName, interfacesPlusWovenProxy);
            } else {
                this.cv.visit(version, access, name, signature, superName, interfaces);
            }
        }
        catch (ClassNotFoundException e) {
            UnableToProxyException u = new UnableToProxyException(name, (Throwable)e);
            throw new RuntimeException(NLS.MESSAGES.getMessage("cannot.load.superclass", new Object[]{superName.replace('/', '.'), this.typeBeingWoven.getClassName()}), (Throwable)u);
        }
    }

    private final boolean superHasNoArgsConstructor(String superName, String name) {
        ConstructorFinder cf = new ConstructorFinder();
        try {
            InputStream is = this.loader.getResourceAsStream(superName + ".class");
            if (is == null) {
                throw new IOException();
            }
            new ClassReader(is).accept((ClassVisitor)cf, 7);
        }
        catch (IOException ioe) {
            UnableToProxyException u = new UnableToProxyException(name, (Throwable)ioe);
            throw new RuntimeException(NLS.MESSAGES.getMessage("cannot.load.superclass", new Object[]{superName.replace('/', '.'), this.typeBeingWoven.getClassName()}), (Throwable)u);
        }
        return cf.hasNoArgsConstructor();
    }

    private boolean checkInterfacesForSerializability(String[] interfaces) throws ClassNotFoundException {
        for (String iface : interfaces) {
            if (!Serializable.class.isAssignableFrom(Class.forName(iface.replace('/', '.'), false, this.loader))) continue;
            return true;
        }
        return false;
    }

    public final MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        LOGGER.debug("Method entry: {}, args {}", (Object)"visitMethod", (Object)new Object[]{access, name, desc, signature, exceptions});
        Method currentMethod = new Method(name, desc);
        this.getKnownMethods().add(currentMethod);
        Object methodVisitorToReturn = null;
        if ((access & 0x114A) == 0 && !name.equals("<init>") && !name.equals("<clinit>")) {
            String methodStaticFieldName = "methodField" + AbstractWovenProxyAdapter.getSanitizedUUIDString();
            this.transformedMethods.put(methodStaticFieldName, new TypeMethod(this.currentMethodDeclaringType, currentMethod));
            methodVisitorToReturn = this.getWeavingMethodVisitor(access, name, desc, signature, exceptions, currentMethod, methodStaticFieldName, this.currentMethodDeclaringType, this.currentMethodDeclaringTypeIsInterface);
        } else if (name.equals("<clinit>")) {
            this.staticInitMethod = new Method("static_init_04df3c80_2877_4f6c_99e2_5a25e11d5535", Type.VOID_TYPE, NO_ARGS);
            this.staticInitMethodFlags |= 0x10;
            methodVisitorToReturn = new AdviceAdapter(327680, this.cv.visitMethod(access, name, desc, signature, exceptions), access, name, desc){

                protected void onMethodEnter() {
                    this.invokeStatic(AbstractWovenProxyAdapter.this.typeBeingWoven, AbstractWovenProxyAdapter.this.staticInitMethod);
                    super.onMethodEnter();
                }
            };
        } else {
            if (currentMethod.getArgumentTypes().length == 0 && name.equals("<init>")) {
                this.hasNoArgsConstructor = true;
            }
            methodVisitorToReturn = this.cv.visitMethod(access, name, desc, signature, exceptions);
        }
        LOGGER.debug("Method exit: {}, returning {}", (Object)"visitMethod", methodVisitorToReturn);
        return methodVisitorToReturn;
    }

    public void visitEnd() {
        LOGGER.debug("Method entry: {}, args {}", (Object)"visitEnd");
        for (Class<?> c : this.nonObjectSupers) {
            this.setCurrentMethodDeclaringType(Type.getType(c), false);
            try {
                AbstractWovenProxyAdapter.readClass(c, new MethodCopyingClassAdapter(this, this.loader, c, this.typeBeingWoven, this.getKnownMethods(), this.transformedMethods));
            }
            catch (IOException e) {
                throw new RuntimeException(NLS.MESSAGES.getMessage("unexpected.error.processing.class", new Object[]{c.getName(), this.typeBeingWoven.getClassName()}), e);
            }
        }
        if (this.implementWovenProxy) {
            this.writeFinalWovenProxyMethods();
        }
        this.writeStaticInitMethod();
        this.writeCreateNewProxyInstanceAndConstructor();
        this.cv.visitEnd();
        LOGGER.debug("Method exit: {}, returning {}", (Object)"visitEnd");
    }

    public Set<Method> getKnownMethods() {
        return this.knownMethods;
    }

    protected abstract MethodVisitor getWeavingMethodVisitor(int var1, String var2, String var3, String var4, String[] var5, Method var6, String var7, Type var8, boolean var9);

    private final void writeFinalWovenProxyMethods() {
        this.generateField(DISPATCHER_FIELD, Type.getDescriptor(Callable.class));
        this.generateField(LISTENER_FIELD, Type.getDescriptor(InvocationListener.class));
        GeneratorAdapter methodAdapter = this.getMethodGenerator(4113, new Method("org_apache_aries_proxy_weaving_WovenProxy_unwrap", DISPATCHER_TYPE, NO_ARGS));
        methodAdapter.loadThis();
        methodAdapter.getField(this.typeBeingWoven, DISPATCHER_FIELD, DISPATCHER_TYPE);
        methodAdapter.returnValue();
        methodAdapter.endMethod();
        methodAdapter = this.getMethodGenerator(4113, new Method("org_apache_aries_proxy_weaving_WovenProxy_isProxyInstance", Type.BOOLEAN_TYPE, NO_ARGS));
        methodAdapter.loadThis();
        Label returnTrueLabel = methodAdapter.newLabel();
        methodAdapter.getField(this.typeBeingWoven, DISPATCHER_FIELD, DISPATCHER_TYPE);
        methodAdapter.ifNonNull(returnTrueLabel);
        methodAdapter.loadThis();
        methodAdapter.getField(this.typeBeingWoven, LISTENER_FIELD, LISTENER_TYPE);
        methodAdapter.ifNonNull(returnTrueLabel);
        methodAdapter.push(false);
        methodAdapter.returnValue();
        methodAdapter.mark(returnTrueLabel);
        methodAdapter.push(true);
        methodAdapter.returnValue();
        methodAdapter.endMethod();
    }

    private final void writeCreateNewProxyInstanceAndConstructor() {
        GeneratorAdapter methodAdapter = this.getMethodGenerator(1, new Method("org_apache_aries_proxy_weaving_WovenProxy_createNewProxyInstance", WOVEN_PROXY_IFACE_TYPE, DISPATCHER_LISTENER_METHOD_ARGS));
        methodAdapter.newInstance(this.typeBeingWoven);
        methodAdapter.dup();
        methodAdapter.loadArgs();
        methodAdapter.invokeConstructor(this.typeBeingWoven, new Method("<init>", Type.VOID_TYPE, DISPATCHER_LISTENER_METHOD_ARGS));
        methodAdapter.returnValue();
        methodAdapter.endMethod();
        methodAdapter = this.getMethodGenerator(4100, ARGS_CONSTRUCTOR);
        if (this.implementWovenProxy) {
            methodAdapter.loadThis();
            if (this.superHasNoArgsConstructor) {
                methodAdapter.invokeConstructor(this.superType, NO_ARGS_CONSTRUCTOR);
            } else if (this.hasNoArgsConstructor) {
                methodAdapter.invokeConstructor(this.typeBeingWoven, NO_ARGS_CONSTRUCTOR);
            } else {
                throw new RuntimeException((Throwable)new UnableToProxyException(this.typeBeingWoven.getClassName(), NLS.MESSAGES.getMessage("type.lacking.no.arg.constructor", new Object[]{this.typeBeingWoven.getClassName(), this.superType.getClassName()})));
            }
            methodAdapter.loadThis();
            methodAdapter.loadArg(0);
            methodAdapter.putField(this.typeBeingWoven, DISPATCHER_FIELD, DISPATCHER_TYPE);
            methodAdapter.loadThis();
            methodAdapter.loadArg(1);
            methodAdapter.putField(this.typeBeingWoven, LISTENER_FIELD, LISTENER_TYPE);
        } else {
            methodAdapter.loadThis();
            methodAdapter.loadArgs();
            methodAdapter.invokeConstructor(this.superType, ARGS_CONSTRUCTOR);
        }
        methodAdapter.loadArg(0);
        Label returnValue = methodAdapter.newLabel();
        methodAdapter.ifNonNull(returnValue);
        methodAdapter.newInstance(NPE_TYPE);
        methodAdapter.dup();
        methodAdapter.push("The dispatcher must never be null!");
        methodAdapter.invokeConstructor(NPE_TYPE, NPE_CONSTRUCTOR);
        methodAdapter.throwException();
        methodAdapter.mark(returnValue);
        methodAdapter.returnValue();
        methodAdapter.endMethod();
    }

    private final void writeStaticInitMethod() {
        for (String methodStaticFieldName : this.transformedMethods.keySet()) {
            this.cv.visitField(4122, methodStaticFieldName, METHOD_TYPE.getDescriptor(), null, null).visitEnd();
        }
        GeneratorAdapter staticAdapter = new GeneratorAdapter(this.staticInitMethodFlags, this.staticInitMethod, null, null, this.cv);
        for (Map.Entry<String, TypeMethod> entry : this.transformedMethods.entrySet()) {
            TypeMethod m = entry.getValue();
            Type[] targetMethodParameters = m.method.getArgumentTypes();
            String methodStaticFieldName = entry.getKey();
            Label beginPopulate = staticAdapter.newLabel();
            Label endPopulate = staticAdapter.newLabel();
            Label catchHandler = staticAdapter.newLabel();
            staticAdapter.visitTryCatchBlock(beginPopulate, endPopulate, catchHandler, THROWABLE_INAME);
            staticAdapter.mark(beginPopulate);
            staticAdapter.push(m.declaringClass);
            staticAdapter.push(m.method.getName());
            staticAdapter.push(targetMethodParameters.length);
            staticAdapter.newArray(CLASS_TYPE);
            int index = 0;
            for (Type t : targetMethodParameters) {
                staticAdapter.dup();
                staticAdapter.push(index);
                staticAdapter.push(t);
                staticAdapter.arrayStore(CLASS_TYPE);
                ++index;
            }
            staticAdapter.invokeVirtual(CLASS_TYPE, new Method("getDeclaredMethod", METHOD_TYPE, new Type[]{STRING_TYPE, CLASS_ARRAY_TYPE}));
            staticAdapter.putStatic(this.typeBeingWoven, methodStaticFieldName, METHOD_TYPE);
            Label afterCatch = staticAdapter.newLabel();
            staticAdapter.mark(endPopulate);
            staticAdapter.goTo(afterCatch);
            staticAdapter.mark(catchHandler);
            staticAdapter.pop();
            staticAdapter.visitInsn(1);
            staticAdapter.putStatic(this.typeBeingWoven, methodStaticFieldName, METHOD_TYPE);
            staticAdapter.mark(afterCatch);
        }
        staticAdapter.returnValue();
        staticAdapter.endMethod();
    }

    public static final String getSanitizedUUIDString() {
        return UUID.randomUUID().toString().replace('-', '_');
    }

    public static void readClass(Class<?> c, ClassVisitor adapter) throws IOException {
        String className = c.getName();
        className = className.substring(className.lastIndexOf(46) + 1) + ".class";
        ClassReader cReader = new ClassReader(c.getResourceAsStream(className));
        cReader.accept(adapter, 7);
    }

    private final void generateField(String fieldName, String fieldDescriptor) {
        FieldVisitor fv = this.cv.visitField(4244, fieldName, fieldDescriptor, null, null);
        for (String s : annotationTypeDescriptors) {
            fv.visitAnnotation(s, true).visitEnd();
        }
        fv.visitEnd();
    }

    private final GeneratorAdapter getMethodGenerator(int access, Method method) {
        GeneratorAdapter ga = new GeneratorAdapter(access |= 0x1000, method, null, null, this.cv);
        for (String s : annotationTypeDescriptors) {
            ga.visitAnnotation(s, true).visitEnd();
        }
        ga.visitCode();
        return ga;
    }

    public final void setCurrentMethodDeclaringType(Type type, boolean isInterface) {
        this.currentMethodDeclaringType = type;
        this.currentMethodDeclaringTypeIsInterface = isInterface;
    }
}

