/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LogEventListener;
import org.apache.logging.log4j.core.net.server.AbstractLogEventBridge;
import org.apache.logging.log4j.core.util.FilteredObjectInputStream;

public class ObjectInputStreamLogEventBridge
extends AbstractLogEventBridge<ObjectInputStream> {
    private final List<String> allowedClasses;

    public ObjectInputStreamLogEventBridge() {
        this(Collections.emptyList());
    }

    public ObjectInputStreamLogEventBridge(List<String> allowedClasses) {
        this.allowedClasses = allowedClasses;
    }

    @Override
    public void logEvents(ObjectInputStream inputStream, LogEventListener logEventListener) throws IOException {
        try {
            logEventListener.log((LogEvent)inputStream.readObject());
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    @Override
    public ObjectInputStream wrapStream(InputStream inputStream) throws IOException {
        return new FilteredObjectInputStream(inputStream, this.allowedClasses);
    }
}

