/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.ha.provider.impl;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.knox.gateway.ha.provider.HaServiceConfig;
import org.apache.knox.gateway.ha.provider.impl.DefaultURLManager;
import org.apache.knox.gateway.ha.provider.impl.i18n.HaMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;

public class HS2ZookeeperURLManager
extends DefaultURLManager {
    private static final HaMessages LOG = (HaMessages)MessagesFactory.get(HaMessages.class);
    private static final Pattern kvPattern = Pattern.compile("([^=;]*)=([^;]*)[;]?");
    private String zooKeeperEnsemble;
    private String zooKeeperNamespace;
    private HashSet<String> failedSet = new LinkedHashSet<String>();

    @Override
    public boolean supportsConfig(HaServiceConfig config) {
        if (!config.getServiceName().equalsIgnoreCase("HIVE")) {
            return false;
        }
        String zookeeperEnsemble = config.getZookeeperEnsemble();
        String zookeeperNamespace = config.getZookeeperNamespace();
        return zookeeperEnsemble != null && zookeeperNamespace != null && zookeeperEnsemble.trim().length() > 0 && zookeeperNamespace.trim().length() > 0;
    }

    @Override
    public void setConfig(HaServiceConfig config) {
        this.zooKeeperEnsemble = config.getZookeeperEnsemble();
        this.zooKeeperNamespace = config.getZookeeperNamespace();
        this.setURLs(this.lookupURLs());
    }

    public List<String> lookupURLs() {
        ArrayList<String> serverHosts = new ArrayList<String>();
        try (CuratorFramework zooKeeperClient = CuratorFrameworkFactory.builder().connectString(this.zooKeeperEnsemble).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(1000, 3)).build();){
            zooKeeperClient.start();
            zooKeeperClient.blockUntilConnected(10, TimeUnit.SECONDS);
            List serverNodes = (List)zooKeeperClient.getChildren().forPath("/" + this.zooKeeperNamespace);
            for (String serverNode : serverNodes) {
                String serverInfo = new String((byte[])zooKeeperClient.getData().forPath("/" + this.zooKeeperNamespace + "/" + serverNode), StandardCharsets.UTF_8);
                String serverURL = this.constructURL(serverInfo);
                serverHosts.add(serverURL);
            }
        }
        catch (Exception e) {
            LOG.failedToGetZookeeperUrls(e);
            throw new RuntimeException(e);
        }
        return serverHosts;
    }

    private String constructURL(String serverInfo) {
        Matcher matcher = kvPattern.matcher(serverInfo);
        String scheme = "http";
        String host = null;
        String port = "10001";
        String httpPath = "cliservice";
        while (matcher.find()) {
            if (matcher.group(1) == null || matcher.group(2) == null) continue;
            switch (matcher.group(1)) {
                case "hive.server2.thrift.bind.host": {
                    host = matcher.group(2);
                    break;
                }
                case "hive.server2.thrift.http.port": {
                    port = matcher.group(2);
                    break;
                }
                case "hive.server2.thrift.http.path": {
                    httpPath = matcher.group(2);
                    break;
                }
                case "hive.server2.use.SSL": {
                    if (!Boolean.parseBoolean(matcher.group(2))) break;
                    scheme = "https";
                }
            }
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(scheme);
        buffer.append("://");
        buffer.append(host);
        buffer.append(":");
        buffer.append(port);
        buffer.append("/");
        buffer.append(httpPath);
        return buffer.toString();
    }

    @Override
    public synchronized void markFailed(String url) {
        this.failedSet.add(url);
        if (this.failedSet.size() >= this.getURLs().size()) {
            this.failedSet.clear();
            this.setURLs(this.lookupURLs());
        }
        super.markFailed(url);
    }
}

