/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.http.callback;

import org.pac4j.core.context.WebContext;
import org.pac4j.core.http.callback.CallbackUrlResolver;
import org.pac4j.core.http.url.UrlResolver;
import org.pac4j.core.util.CommonHelper;

public class PathParameterCallbackUrlResolver
implements CallbackUrlResolver {
    @Override
    public String compute(UrlResolver urlResolver, String url, String clientName, WebContext context) {
        String newUrl = urlResolver.compute(url, context);
        if (newUrl != null) {
            if (!newUrl.endsWith("/")) {
                newUrl = newUrl + "/";
            }
            newUrl = newUrl + clientName;
        }
        return newUrl;
    }

    @Override
    public boolean matches(String clientName, WebContext context) {
        String path = context.getPath();
        if (path != null) {
            int pos = path.lastIndexOf("/");
            String name = pos >= 0 ? path.substring(pos + 1) : path;
            return CommonHelper.areEqualsIgnoreCaseAndTrim(name, clientName);
        }
        return false;
    }
}

