/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.util;

import java.io.StringWriter;
import java.util.HashMap;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.InitializationService;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallerFactory;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.pac4j.saml.exceptions.SAMLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public final class Configuration {
    protected static final Logger logger = LoggerFactory.getLogger(Configuration.class);
    private static BasicParserPool parserPool;

    private Configuration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void bootstrap() {
        parserPool = new BasicParserPool();
        parserPool.setMaxPoolSize(100);
        parserPool.setCoalescing(true);
        parserPool.setIgnoreComments(true);
        parserPool.setNamespaceAware(true);
        parserPool.setExpandEntityReferences(false);
        parserPool.setXincludeAware(false);
        parserPool.setIgnoreElementContentWhitespace(true);
        HashMap builderAttributes = new HashMap();
        parserPool.setBuilderAttributes(builderAttributes);
        HashMap<String, Boolean> features = new HashMap<String, Boolean>();
        features.put("http://apache.org/xml/features/disallow-doctype-decl", Boolean.TRUE);
        features.put("http://apache.org/xml/features/validation/schema/normalized-value", Boolean.FALSE);
        features.put("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        features.put("http://xml.org/sax/features/external-general-entities", Boolean.FALSE);
        features.put("http://xml.org/sax/features/external-parameter-entities", Boolean.FALSE);
        parserPool.setBuilderFeatures(features);
        try {
            parserPool.initialize();
        }
        catch (ComponentInitializationException e) {
            throw new RuntimeException("Exception initializing parserPool", e);
        }
        try {
            InitializationService.initialize();
        }
        catch (InitializationException e) {
            throw new RuntimeException("Exception initializing OpenSAML", e);
        }
        Class<ConfigurationService> clazz = ConfigurationService.class;
        synchronized (ConfigurationService.class) {
            XMLObjectProviderRegistry registry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class);
            if (registry == null) {
                registry = new XMLObjectProviderRegistry();
                ConfigurationService.register(XMLObjectProviderRegistry.class, (Object)registry);
            }
            // ** MonitorExit[var3_5] (shouldn't be in output)
            registry.setParserPool((ParserPool)parserPool);
            return;
        }
    }

    public static ParserPool getParserPool() {
        return parserPool;
    }

    public static XMLObjectBuilderFactory getBuilderFactory() {
        return XMLObjectProviderRegistrySupport.getBuilderFactory();
    }

    public static MarshallerFactory getMarshallerFactory() {
        return XMLObjectProviderRegistrySupport.getMarshallerFactory();
    }

    public static UnmarshallerFactory getUnmarshallerFactory() {
        return XMLObjectProviderRegistrySupport.getUnmarshallerFactory();
    }

    public static StringWriter serializeSamlObject(XMLObject samlObject) {
        StringWriter writer = new StringWriter();
        try {
            Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller(samlObject.getElementQName());
            if (marshaller != null) {
                Element element = marshaller.marshall(samlObject);
                DOMSource domSource = new DOMSource(element);
                StreamResult result = new StreamResult(writer);
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                transformer.transform(domSource, result);
            }
        }
        catch (Exception e) {
            throw new SAMLException(e.getMessage(), e);
        }
        return writer;
    }

    static {
        logger.info("Bootstrapping OpenSAML configuration via Pac4j...");
        Configuration.bootstrap();
    }
}

