/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.transaction;

import net.sf.ehcache.Element;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.transaction.SoftLock;
import net.sf.ehcache.transaction.SoftLockID;

public class SoftLockHelper {
    public static void commit(SoftLock softLock, Store underlyingStore, ElementValueComparator comparator) {
        Element element;
        Element e = underlyingStore.getQuiet(softLock.getKey());
        if (e == null || !(e.getObjectValue() instanceof SoftLockID)) {
            return;
        }
        SoftLockID softLockId = (SoftLockID)e.getObjectValue();
        if (!softLockId.wasPinned()) {
            underlyingStore.setPinned(softLock.getKey(), false);
        }
        if ((element = softLockId.getNewElement()) != null) {
            underlyingStore.replace(e, element, comparator);
        } else {
            underlyingStore.removeElement(e, comparator);
        }
    }

    public static void rollback(SoftLock softLock, Store underlyingStore, ElementValueComparator comparator) {
        Element element;
        Element e = underlyingStore.getQuiet(softLock.getKey());
        if (e == null || !(e.getObjectValue() instanceof SoftLockID)) {
            return;
        }
        SoftLockID softLockId = (SoftLockID)e.getObjectValue();
        if (!softLockId.wasPinned()) {
            underlyingStore.setPinned(softLock.getKey(), false);
        }
        if ((element = softLockId.getOldElement()) != null) {
            underlyingStore.replace(e, element, comparator);
        } else {
            underlyingStore.removeElement(e, comparator);
        }
    }
}

