/*
 * Decompiled with CFR 0.152.
 */
package com.thetransactioncompany.cors.autoreconf;

import com.thetransactioncompany.cors.autoreconf.CORSConfigurationWatcher;
import com.thetransactioncompany.cors.environment.Environment;
import com.thetransactioncompany.cors.environment.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.servlet.FilterConfig;

public class CORSConfigurationFileWatcher
implements CORSConfigurationWatcher {
    public static final String POLL_INTERVAL_PARAM_NAME = "cors.configFilePollInterval";
    public static final long DEFAULT_POLL_INTERVAL_SECONDS = 20L;
    private static final Logger LOG = LogManager.getLogManager().getLogger("");
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private WatchService watcher;
    private final FilterConfig filterConfig;
    private Environment environment;
    private String configFile;
    private boolean reloadRequired;

    public CORSConfigurationFileWatcher(FilterConfig filterConfig) {
        if (filterConfig == null) {
            throw new IllegalArgumentException("The servlet filter configuration must not be null");
        }
        this.filterConfig = filterConfig;
        try {
            this.watcher = FileSystems.getDefault().newWatchService();
            Path dir = this.determineConfigDir();
            dir.register(this.watcher, StandardWatchEventKinds.ENTRY_MODIFY);
            LOG.fine("CORS Filter: Started watching for configuration file changes within " + dir);
        }
        catch (IOException e) {
            LOG.severe("CORS Filter: Failed to initialize file system watcher: " + e.getMessage());
        }
    }

    @Override
    public void start() {
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                LOG.finest("CORS Filter: Initiated configuration file poll");
                try {
                    CORSConfigurationFileWatcher.this.pollConfigFileForChanges();
                }
                catch (Throwable throwable) {
                    LOG.severe("CORS Filter: Configuration file polling failed: " + throwable);
                }
            }
        }, this.getPollIntervalSeconds(), this.getPollIntervalSeconds(), TimeUnit.SECONDS);
    }

    @Override
    public boolean reloadRequired() {
        return this.reloadRequired;
    }

    @Override
    public void stop() {
        this.scheduler.shutdown();
    }

    @Override
    public void reset() {
        this.reloadRequired = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollConfigFileForChanges() {
        WatchKey key = this.watcher.poll();
        try {
            if (key == null) {
                return;
            }
            for (WatchEvent<?> event : key.pollEvents()) {
                Path filename;
                WatchEvent.Kind<?> kind = event.kind();
                if (StandardWatchEventKinds.OVERFLOW == kind || !this.configFile.endsWith((filename = (Path)event.context()).toString())) continue;
                LOG.info("CORS Filter: Detected change in " + this.configFile + " , configuration reload required");
                this.reloadRequired = true;
            }
        }
        finally {
            if (key != null) {
                key.reset();
            }
        }
    }

    private Path determineConfigDir() {
        try {
            File file;
            this.configFile = this.getEnvironment().getProperty("cors.configurationFile");
            if (this.configFile == null || this.configFile.trim().isEmpty()) {
                this.configFile = this.filterConfig.getInitParameter("cors.configurationFile");
            }
            if (this.configFile == null) {
                throw new RuntimeException("CORS configuration file is not defined");
            }
            URL url = this.filterConfig.getServletContext().getResource(this.configFile);
            if (url == null && (file = new File(this.configFile)).isFile()) {
                url = file.toURI().toURL();
            }
            if (url == null) {
                String msg = "CORS Filter: Configuration file not found: " + this.configFile;
                LOG.severe(msg);
                throw new RuntimeException(msg);
            }
            return Paths.get(url.toURI()).getParent();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private Environment getEnvironment() {
        if (this.environment == null) {
            this.environment = new SystemProperties();
        }
        return this.environment;
    }

    public long getPollIntervalSeconds() {
        String period = this.getEnvironment().getProperty(POLL_INTERVAL_PARAM_NAME);
        if (period == null) {
            LOG.fine("CORS Filter: Defaulted configuration file poll period to 20 seconds, may be overridden with cors.configFilePollInterval system property");
            return 20L;
        }
        long overriddenPeriod = Long.parseLong(period);
        LOG.fine("CORS Filter: Set configuration file poll period to " + overriddenPeriod + " seconds from " + POLL_INTERVAL_PARAM_NAME + " system property");
        return overriddenPeriod;
    }
}

