/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.deploy.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.deploy.DeploymentContext;
import org.apache.knox.gateway.deploy.DeploymentException;
import org.apache.knox.gateway.deploy.ServiceDeploymentContributorBase;
import org.apache.knox.gateway.descriptor.FilterDescriptor;
import org.apache.knox.gateway.descriptor.FilterParamDescriptor;
import org.apache.knox.gateway.descriptor.ResourceDescriptor;
import org.apache.knox.gateway.filter.XForwardedHeaderFilter;
import org.apache.knox.gateway.filter.rewrite.api.CookieScopeServletFilter;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteRulesDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteRulesDescriptorFactory;
import org.apache.knox.gateway.service.definition.Policy;
import org.apache.knox.gateway.service.definition.Rewrite;
import org.apache.knox.gateway.service.definition.Route;
import org.apache.knox.gateway.service.definition.ServiceDefinition;
import org.apache.knox.gateway.topology.Application;
import org.apache.knox.gateway.topology.Service;
import org.apache.knox.gateway.topology.Version;

public class ApplicationDeploymentContributor
extends ServiceDeploymentContributorBase {
    private static final String SERVICE_DEFINITION_FILE_NAME = "service.xml";
    private static final String REWRITE_RULES_FILE_NAME = "rewrite.xml";
    private static final String XFORWARDED_FILTER_NAME = "XForwardedHeaderFilter";
    private static final String XFORWARDED_FILTER_ROLE = "xforwardedheaders";
    private static final String COOKIE_SCOPING_FILTER_NAME = "CookieScopeServletFilter";
    private static final String COOKIE_SCOPING_FILTER_ROLE = "cookiescopef";
    private ServiceDefinition serviceDefinition;
    private UrlRewriteRulesDescriptor serviceRules;

    private static ServiceDefinition loadServiceDefinition(Application application, File file) throws JAXBException, FileNotFoundException, IOException {
        ServiceDefinition definition;
        if (!file.exists()) {
            definition = new ServiceDefinition();
            definition.setName(application.getName());
            ArrayList<Route> routes = new ArrayList<Route>(1);
            Route route = new Route();
            route.setPath("/?**");
            routes.add(route);
            route = new Route();
            route.setPath("/**?**");
            routes.add(route);
            definition.setRoutes(routes);
        } else {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ServiceDefinition.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            try (FileInputStream inputStream = new FileInputStream(file);){
                definition = (ServiceDefinition)unmarshaller.unmarshal((InputStream)inputStream);
            }
        }
        return definition;
    }

    private static UrlRewriteRulesDescriptor loadRewriteRules(Application application, File file) throws IOException {
        UrlRewriteRulesDescriptor rules;
        if (!file.exists()) {
            rules = UrlRewriteRulesDescriptorFactory.load((String)"xml", (Reader)new StringReader("<rules/>"));
        } else {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
            rules = UrlRewriteRulesDescriptorFactory.load((String)"xml", (Reader)reader);
            reader.close();
        }
        return rules;
    }

    public ApplicationDeploymentContributor(GatewayConfig config, Application application) throws DeploymentException {
        try {
            File appsDir = new File(config.getGatewayApplicationsDir());
            File appDir = new File(appsDir, application.getName());
            File serviceFile = new File(appDir, SERVICE_DEFINITION_FILE_NAME);
            File rewriteFile = new File(appDir, REWRITE_RULES_FILE_NAME);
            this.serviceDefinition = ApplicationDeploymentContributor.loadServiceDefinition(application, serviceFile);
            this.serviceRules = ApplicationDeploymentContributor.loadRewriteRules(application, rewriteFile);
        }
        catch (IOException e) {
            throw new DeploymentException("Failed to deploy application: " + application.getName(), e);
        }
        catch (JAXBException e) {
            throw new DeploymentException("Failed to deploy application: " + application.getName(), (Exception)((Object)e));
        }
    }

    public String getRole() {
        return this.serviceDefinition.getRole();
    }

    public String getName() {
        return this.serviceDefinition.getName();
    }

    public Version getVersion() {
        return new Version(this.serviceDefinition.getVersion());
    }

    public void contributeService(DeploymentContext context, Service service) throws Exception {
        this.contributeRewriteRules(context, service);
        this.contributeResources(context, service);
    }

    private void contributeRewriteRules(DeploymentContext context, Service service) {
        UrlRewriteRulesDescriptor clusterRules;
        if (this.serviceRules != null && (clusterRules = (UrlRewriteRulesDescriptor)context.getDescriptor("rewrite")) != null) {
            clusterRules.addRules(this.serviceRules);
        }
    }

    private void contributeResources(DeploymentContext context, Service service) {
        HashMap<String, String> filterParams = new HashMap<String, String>();
        List bindings = this.serviceDefinition.getRoutes();
        for (Route binding : bindings) {
            List filters = binding.getRewrites();
            if (filters != null && !filters.isEmpty()) {
                filterParams.clear();
                for (Rewrite filter : filters) {
                    filterParams.put(filter.getTo(), filter.getApply());
                }
            }
            try {
                this.contributeResource(context, service, binding, filterParams);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    private void contributeResource(DeploymentContext context, Service service, Route binding, Map<String, String> filterParams) throws URISyntaxException {
        List policyBindings;
        ArrayList<FilterParamDescriptor> params = new ArrayList<FilterParamDescriptor>();
        ResourceDescriptor resource = context.getGatewayDescriptor().addResource();
        resource.role(service.getRole());
        resource.pattern(binding.getPath());
        if (context.getGatewayConfig().isXForwardedEnabled()) {
            resource.addFilter().name(XFORWARDED_FILTER_NAME).role(XFORWARDED_FILTER_ROLE).impl(XForwardedHeaderFilter.class);
        }
        if (context.getGatewayConfig().isCookieScopingToPathEnabled()) {
            FilterDescriptor filter = resource.addFilter().name(COOKIE_SCOPING_FILTER_NAME).role(COOKIE_SCOPING_FILTER_ROLE).impl(CookieScopeServletFilter.class);
            filter.param().name("gateway.path").value(context.getGatewayConfig().getGatewayPath());
        }
        if ((policyBindings = binding.getPolicies()) == null) {
            policyBindings = this.serviceDefinition.getPolicies();
        }
        if (policyBindings == null) {
            this.addDefaultPolicies(context, service, filterParams, params, resource);
        } else {
            this.addPolicies(context, service, filterParams, params, resource, policyBindings);
        }
    }

    private void addPolicies(DeploymentContext context, Service service, Map<String, String> filterParams, List<FilterParamDescriptor> params, ResourceDescriptor resource, List<Policy> policyBindings) throws URISyntaxException {
        for (Policy policyBinding : policyBindings) {
            String role = policyBinding.getRole();
            if (role == null) {
                throw new IllegalArgumentException("Policy defined has no role for service " + service.getName());
            }
            if ("rewrite".equals(role = role.trim().toLowerCase(Locale.ROOT))) {
                this.addRewriteFilter(context, service, filterParams, params, resource);
                continue;
            }
            if (!this.topologyContainsProviderType(context, role)) continue;
            context.contributeFilter(service, resource, role, policyBinding.getName(), null);
        }
    }

    private void addDefaultPolicies(DeploymentContext context, Service service, Map<String, String> filterParams, List<FilterParamDescriptor> params, ResourceDescriptor resource) throws URISyntaxException {
        this.addWebAppSecFilters(context, service, resource);
        this.addAuthenticationFilter(context, service, resource);
        this.addRewriteFilter(context, service, filterParams, params, resource);
        this.addIdentityAssertionFilter(context, service, resource);
        this.addAuthorizationFilter(context, service, resource);
    }

    private void addRewriteFilter(DeploymentContext context, Service service, Map<String, String> filterParams, List<FilterParamDescriptor> params, ResourceDescriptor resource) throws URISyntaxException {
        if (!filterParams.isEmpty()) {
            for (Map.Entry<String, String> filterParam : filterParams.entrySet()) {
                params.add(resource.createFilterParam().name(filterParam.getKey()).value(filterParam.getValue()));
            }
        }
        this.addRewriteFilter(context, service, resource, params);
    }
}

