/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiEntityTag;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Host templates will contain information about the role config groups that should be applied to a host. This basically means a host will have a role corresponding to each config group.")
public class ApiClusterTemplateHostTemplate {
    @SerializedName(value="refName")
    private String refName = null;
    @SerializedName(value="roleConfigGroupsRefNames")
    private List<String> roleConfigGroupsRefNames = null;
    @SerializedName(value="cardinality")
    private BigDecimal cardinality = null;
    @SerializedName(value="tags")
    private List<ApiEntityTag> tags = null;

    public ApiClusterTemplateHostTemplate refName(String refName) {
        this.refName = refName;
        return this;
    }

    @ApiModelProperty(value="Reference name")
    public String getRefName() {
        return this.refName;
    }

    public void setRefName(String refName) {
        this.refName = refName;
    }

    public ApiClusterTemplateHostTemplate roleConfigGroupsRefNames(List<String> roleConfigGroupsRefNames) {
        this.roleConfigGroupsRefNames = roleConfigGroupsRefNames;
        return this;
    }

    public ApiClusterTemplateHostTemplate addRoleConfigGroupsRefNamesItem(String roleConfigGroupsRefNamesItem) {
        if (this.roleConfigGroupsRefNames == null) {
            this.roleConfigGroupsRefNames = new ArrayList<String>();
        }
        this.roleConfigGroupsRefNames.add(roleConfigGroupsRefNamesItem);
        return this;
    }

    @ApiModelProperty(value="List of role config groups")
    public List<String> getRoleConfigGroupsRefNames() {
        return this.roleConfigGroupsRefNames;
    }

    public void setRoleConfigGroupsRefNames(List<String> roleConfigGroupsRefNames) {
        this.roleConfigGroupsRefNames = roleConfigGroupsRefNames;
    }

    public ApiClusterTemplateHostTemplate cardinality(BigDecimal cardinality) {
        this.cardinality = cardinality;
        return this;
    }

    @ApiModelProperty(value="Represent the cardinality of this host template on source. Defaults to 0.")
    public BigDecimal getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(BigDecimal cardinality) {
        this.cardinality = cardinality;
    }

    public ApiClusterTemplateHostTemplate tags(List<ApiEntityTag> tags) {
        this.tags = tags;
        return this;
    }

    public ApiClusterTemplateHostTemplate addTagsItem(ApiEntityTag tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<ApiEntityTag>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @ApiModelProperty(value="The tags to be added to hosts when this template is applied")
    public List<ApiEntityTag> getTags() {
        return this.tags;
    }

    public void setTags(List<ApiEntityTag> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiClusterTemplateHostTemplate apiClusterTemplateHostTemplate = (ApiClusterTemplateHostTemplate)o;
        return Objects.equals(this.refName, apiClusterTemplateHostTemplate.refName) && Objects.equals(this.roleConfigGroupsRefNames, apiClusterTemplateHostTemplate.roleConfigGroupsRefNames) && Objects.equals(this.cardinality, apiClusterTemplateHostTemplate.cardinality) && Objects.equals(this.tags, apiClusterTemplateHostTemplate.tags);
    }

    public int hashCode() {
        return Objects.hash(this.refName, this.roleConfigGroupsRefNames, this.cardinality, this.tags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiClusterTemplateHostTemplate {\n");
        sb.append("    refName: ").append(this.toIndentedString(this.refName)).append("\n");
        sb.append("    roleConfigGroupsRefNames: ").append(this.toIndentedString(this.roleConfigGroupsRefNames)).append("\n");
        sb.append("    cardinality: ").append(this.toIndentedString(this.cardinality)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

