/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.hadoop.common.utils;

import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Paths;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.hadoop.common.conf.HadoopConf$;
import org.apache.linkis.hadoop.common.entity.HDFSFileSystemContainer;
import org.apache.linkis.hadoop.common.utils.HDFSUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

public final class HDFSUtils$
implements Logging {
    public static HDFSUtils$ MODULE$;
    private final Map<String, HDFSFileSystemContainer> org$apache$linkis$hadoop$common$utils$HDFSUtils$$fileSystemCache;
    private final String org$apache$linkis$hadoop$common$utils$HDFSUtils$$LOCKER_SUFFIX;
    private final String DEFAULT_CACHE_LABEL;
    private final String org$apache$linkis$hadoop$common$utils$HDFSUtils$$JOINT;
    private final AtomicLong count;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new HDFSUtils$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        HDFSUtils$ hDFSUtils$ = this;
        synchronized (hDFSUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public Map<String, HDFSFileSystemContainer> org$apache$linkis$hadoop$common$utils$HDFSUtils$$fileSystemCache() {
        return this.org$apache$linkis$hadoop$common$utils$HDFSUtils$$fileSystemCache;
    }

    public String org$apache$linkis$hadoop$common$utils$HDFSUtils$$LOCKER_SUFFIX() {
        return this.org$apache$linkis$hadoop$common$utils$HDFSUtils$$LOCKER_SUFFIX;
    }

    private String DEFAULT_CACHE_LABEL() {
        return this.DEFAULT_CACHE_LABEL;
    }

    public String org$apache$linkis$hadoop$common$utils$HDFSUtils$$JOINT() {
        return this.org$apache$linkis$hadoop$common$utils$HDFSUtils$$JOINT;
    }

    private AtomicLong count() {
        return this.count;
    }

    public Configuration getConfiguration(String user) {
        return this.getConfiguration(user, HadoopConf$.MODULE$.hadoopConfDir());
    }

    public Configuration getConfigurationByLabel(String user, String label) {
        return this.getConfiguration(user, this.getHadoopConDirByLabel(label));
    }

    private String getHadoopConDirByLabel(String label) {
        if (StringUtils.isBlank((CharSequence)label)) {
            return HadoopConf$.MODULE$.hadoopConfDir();
        }
        String prefix = ((String)HadoopConf$.MODULE$.HADOOP_EXTERNAL_CONF_DIR_PREFIX().getValue()).endsWith("/") ? (String)HadoopConf$.MODULE$.HADOOP_EXTERNAL_CONF_DIR_PREFIX().getValue() : new StringBuilder(1).append((String)HadoopConf$.MODULE$.HADOOP_EXTERNAL_CONF_DIR_PREFIX().getValue()).append("/").toString();
        return new StringBuilder(0).append(prefix).append(label).toString();
    }

    public Configuration getConfiguration(String user, String hadoopConfDir) {
        File confPath = new File(hadoopConfDir);
        if (!confPath.exists() || confPath.isFile()) {
            throw new RuntimeException(new StringBuilder(53).append("Create hadoop configuration failed, path ").append(hadoopConfDir).append(" not exists.").toString());
        }
        Configuration conf = new Configuration();
        conf.addResource(new Path(Paths.get(hadoopConfDir, "core-site.xml").toAbsolutePath().toFile().getAbsolutePath()));
        conf.addResource(new Path(Paths.get(hadoopConfDir, "hdfs-site.xml").toAbsolutePath().toFile().getAbsolutePath()));
        return conf;
    }

    public FileSystem getHDFSRootUserFileSystem() {
        return this.getHDFSRootUserFileSystem(this.getConfiguration((String)HadoopConf$.MODULE$.HADOOP_ROOT_USER().getValue()));
    }

    public FileSystem getHDFSRootUserFileSystem(Configuration conf) {
        return this.getHDFSUserFileSystem((String)HadoopConf$.MODULE$.HADOOP_ROOT_USER().getValue(), null, conf);
    }

    public FileSystem getHDFSUserFileSystem(String userName) {
        return this.getHDFSUserFileSystem(userName, null);
    }

    public FileSystem getHDFSUserFileSystem(String userName, String label) {
        if (HadoopConf$.MODULE$.HDFS_ENABLE_CACHE()) {
            FileSystem fileSystem;
            String cacheLabel = label == null ? this.DEFAULT_CACHE_LABEL() : label;
            String cacheKey = new StringBuilder(0).append(userName).append(this.org$apache$linkis$hadoop$common$utils$HDFSUtils$$JOINT()).append(cacheLabel).toString();
            String locker = new StringBuilder(0).append(userName).append(this.org$apache$linkis$hadoop$common$utils$HDFSUtils$$LOCKER_SUFFIX()).toString();
            String string = locker.intern();
            synchronized (string) {
                FileSystem fileSystem2;
                if (this.org$apache$linkis$hadoop$common$utils$HDFSUtils$$fileSystemCache().containsKey(cacheKey)) {
                    HDFSFileSystemContainer hdfsFileSystemContainer = this.org$apache$linkis$hadoop$common$utils$HDFSUtils$$fileSystemCache().get(cacheKey);
                    hdfsFileSystemContainer.addAccessCount();
                    hdfsFileSystemContainer.updateLastAccessTime();
                    fileSystem2 = hdfsFileSystemContainer.getFileSystem();
                } else {
                    fileSystem2 = this.getHDFSUserFileSystem(userName, label, this.getConfigurationByLabel(userName, label));
                }
                fileSystem = fileSystem2;
            }
            return fileSystem;
        }
        return this.getHDFSUserFileSystem(userName, label, this.getConfigurationByLabel(userName, label));
    }

    public FileSystem getHDFSUserFileSystem(String userName, String label, Configuration conf) {
        if (Predef$.MODULE$.Boolean2boolean((Boolean)HadoopConf$.MODULE$.FS_CACHE_DISABLE().getValue()) && conf != null) {
            conf.set("fs.hdfs.impl.disable.cache", "true");
        }
        if (HadoopConf$.MODULE$.HDFS_ENABLE_CACHE()) {
            FileSystem fileSystem;
            String locker = new StringBuilder(0).append(userName).append(this.org$apache$linkis$hadoop$common$utils$HDFSUtils$$LOCKER_SUFFIX()).toString();
            String cacheLabel = label == null ? this.DEFAULT_CACHE_LABEL() : label;
            String cacheKey = new StringBuilder(0).append(userName).append(this.org$apache$linkis$hadoop$common$utils$HDFSUtils$$JOINT()).append(cacheLabel).toString();
            String string = locker.intern();
            synchronized (string) {
                HDFSFileSystemContainer hDFSFileSystemContainer;
                if (this.org$apache$linkis$hadoop$common$utils$HDFSUtils$$fileSystemCache().containsKey(cacheKey)) {
                    hDFSFileSystemContainer = this.org$apache$linkis$hadoop$common$utils$HDFSUtils$$fileSystemCache().get(cacheKey);
                } else {
                    HDFSFileSystemContainer newHDFSFileSystemContainer = new HDFSFileSystemContainer(this.createFileSystem(userName, label, conf), userName, cacheLabel);
                    this.org$apache$linkis$hadoop$common$utils$HDFSUtils$$fileSystemCache().put(cacheKey, newHDFSFileSystemContainer);
                    hDFSFileSystemContainer = newHDFSFileSystemContainer;
                }
                HDFSFileSystemContainer hdfsFileSystemContainer = hDFSFileSystemContainer;
                hdfsFileSystemContainer.addAccessCount();
                hdfsFileSystemContainer.updateLastAccessTime();
                fileSystem = hdfsFileSystemContainer.getFileSystem();
            }
            return fileSystem;
        }
        return this.createFileSystem(userName, label, conf);
    }

    public FileSystem createFileSystem(String userName, Configuration conf) {
        return this.createFileSystem(userName, null, conf);
    }

    public FileSystem createFileSystem(String userName, String label, Configuration conf) {
        long createCount = this.count().getAndIncrement();
        this.logger().info(new StringBuilder(32).append("user ").append(userName).append(" to create Fs, create time ").append(createCount).toString());
        return (FileSystem)this.getUserGroupInformation(userName, label).doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(conf){
            private final Configuration conf$1;

            public FileSystem run() {
                return FileSystem.newInstance((Configuration)this.conf$1);
            }
            {
                this.conf$1 = conf$1;
            }
        });
    }

    public void closeHDFSFIleSystem(FileSystem fileSystem, String userName) {
        if (fileSystem != null && StringUtils.isNotBlank((CharSequence)userName)) {
            this.closeHDFSFIleSystem(fileSystem, userName, null, false);
            return;
        }
    }

    public void closeHDFSFIleSystem(FileSystem fileSystem, String userName, String label) {
        this.closeHDFSFIleSystem(fileSystem, userName, label, false);
    }

    public void closeHDFSFIleSystem(FileSystem fileSystem, String userName, boolean isForce) {
        this.closeHDFSFIleSystem(fileSystem, userName, null, isForce);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void closeHDFSFIleSystem(FileSystem fileSystem, String userName, String label, boolean isForce) {
        if (fileSystem == null) return;
        if (!StringUtils.isNotBlank((CharSequence)userName)) return;
        String locker = new StringBuilder(0).append(userName).append(this.org$apache$linkis$hadoop$common$utils$HDFSUtils$$LOCKER_SUFFIX()).toString();
        if (!HadoopConf$.MODULE$.HDFS_ENABLE_CACHE()) {
            IOUtils.closeQuietly((Closeable)fileSystem);
            return;
        }
        String string = locker.intern();
        // MONITORENTER : string
        String cacheLabel = label == null ? this.DEFAULT_CACHE_LABEL() : label;
        String cacheKey = new StringBuilder(0).append(userName).append(this.org$apache$linkis$hadoop$common$utils$HDFSUtils$$JOINT()).append(cacheLabel).toString();
        HDFSFileSystemContainer hdfsFileSystemContainer = this.org$apache$linkis$hadoop$common$utils$HDFSUtils$$fileSystemCache().get(cacheKey);
        if (hdfsFileSystemContainer != null) {
            FileSystem fileSystem2 = fileSystem;
            FileSystem fileSystem3 = hdfsFileSystemContainer.getFileSystem();
            if (!(fileSystem2 != null ? !fileSystem2.equals(fileSystem3) : fileSystem3 != null)) {
                if (isForce) {
                    this.org$apache$linkis$hadoop$common$utils$HDFSUtils$$fileSystemCache().remove(hdfsFileSystemContainer.getUser());
                    IOUtils.closeQuietly((Closeable)hdfsFileSystemContainer.getFileSystem());
                    this.logger().info(new StringBuilder(44).append("user").append(hdfsFileSystemContainer.getUser()).append(" to Force remove hdfsFileSystemContainer").toString());
                    return;
                }
                hdfsFileSystemContainer.minusAccessCount();
                return;
            }
        }
        IOUtils.closeQuietly((Closeable)fileSystem);
        // MONITOREXIT : string
        return;
    }

    public UserGroupInformation getUserGroupInformation(String userName) {
        return this.getUserGroupInformation(userName, null);
    }

    public UserGroupInformation getUserGroupInformation(String userName, String label) {
        if (this.isKerberosEnabled(label)) {
            if (!this.isKeytabProxyUserEnabled(label)) {
                String path = new File(this.getKeytabPath(label), new StringBuilder(7).append(userName).append(".keytab").toString()).getPath();
                String user = this.getKerberosUser(userName, label);
                UserGroupInformation.setConfiguration((Configuration)this.getConfigurationByLabel(userName, label));
                return UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)user, (String)path);
            }
            String superUser = this.getKeytabSuperUser(label);
            String path = new File(this.getKeytabPath(label), new StringBuilder(7).append(superUser).append(".keytab").toString()).getPath();
            String user = this.getKerberosUser(superUser, label);
            UserGroupInformation.setConfiguration((Configuration)this.getConfigurationByLabel(superUser, label));
            return UserGroupInformation.createProxyUser((String)userName, (UserGroupInformation)UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)user, (String)path));
        }
        return UserGroupInformation.createRemoteUser((String)userName);
    }

    public boolean isKerberosEnabled(String label) {
        if (label == null) {
            return HadoopConf$.MODULE$.KERBEROS_ENABLE();
        }
        return this.kerberosValueMapParser((String)HadoopConf$.MODULE$.KERBEROS_ENABLE_MAP().getValue()).get((Object)label).contains((Object)"true");
    }

    public boolean isKeytabProxyUserEnabled(String label) {
        if (label == null) {
            return BoxesRunTime.unboxToBoolean((Object)HadoopConf$.MODULE$.KEYTAB_PROXYUSER_ENABLED().getValue());
        }
        return this.kerberosValueMapParser((String)HadoopConf$.MODULE$.KEYTAB_PROXYUSER_SUPERUSER_MAP().getValue()).contains((Object)label);
    }

    public String getKerberosUser(String userName, String label) {
        String user;
        block1: {
            block0: {
                user = userName;
                if (label != null) break block0;
                if (!BoxesRunTime.unboxToBoolean((Object)HadoopConf$.MODULE$.KEYTAB_HOST_ENABLED().getValue())) break block1;
                user = new StringBuilder(1).append(user).append("/").append(HadoopConf$.MODULE$.KEYTAB_HOST().getValue()).toString();
                break block1;
            }
            scala.collection.immutable.Map<String, String> hostMap = this.kerberosValueMapParser((String)HadoopConf$.MODULE$.KEYTAB_HOST_MAP().getValue());
            if (!hostMap.contains((Object)label)) break block1;
            user = new StringBuilder(1).append(user).append("/").append(hostMap.apply((Object)label)).toString();
        }
        return user;
    }

    public String getKeytabSuperUser(String label) {
        if (label == null) {
            return (String)HadoopConf$.MODULE$.KEYTAB_PROXYUSER_SUPERUSER().getValue();
        }
        return (String)this.kerberosValueMapParser((String)HadoopConf$.MODULE$.KEYTAB_PROXYUSER_SUPERUSER_MAP().getValue()).apply((Object)label);
    }

    public String getKeytabPath(String label) {
        if (label == null) {
            return (String)HadoopConf$.MODULE$.KEYTAB_FILE().getValue();
        }
        String prefix = ((String)HadoopConf$.MODULE$.EXTERNAL_KEYTAB_FILE_PREFIX().getValue()).endsWith("/") ? (String)HadoopConf$.MODULE$.EXTERNAL_KEYTAB_FILE_PREFIX().getValue() : new StringBuilder(1).append((String)HadoopConf$.MODULE$.EXTERNAL_KEYTAB_FILE_PREFIX().getValue()).append("/").toString();
        return new StringBuilder(0).append(prefix).append(label).toString();
    }

    private scala.collection.immutable.Map<String, String> kerberosValueMapParser(String configV) {
        String confDelimiter = ",";
        if (configV == null || "".equals(configV)) {
            return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        }
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configV.split(confDelimiter))).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)HDFSUtils$.$anonfun$kerberosValueMapParser$1(x))))).map((Function1 & Serializable & scala.Serializable)x -> {
            String[] confArr = x.split("=");
            if (confArr.length == 2) {
                return new Tuple2((Object)confArr[0].trim(), (Object)confArr[1].trim());
            }
            return null;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).filter((Function1 & Serializable & scala.Serializable)kerberosValue -> BoxesRunTime.boxToBoolean((boolean)HDFSUtils$.$anonfun$kerberosValueMapParser$3(kerberosValue))))).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ boolean $anonfun$kerberosValueMapParser$1(String x) {
        return x != null && !"".equals(x);
    }

    public static final /* synthetic */ boolean $anonfun$kerberosValueMapParser$3(Tuple2 kerberosValue) {
        return kerberosValue != null && StringUtils.isNotBlank((CharSequence)((CharSequence)kerberosValue._1())) && kerberosValue._2() != null;
    }

    private HDFSUtils$() {
        Object object;
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.org$apache$linkis$hadoop$common$utils$HDFSUtils$$fileSystemCache = new ConcurrentHashMap<String, HDFSFileSystemContainer>();
        this.org$apache$linkis$hadoop$common$utils$HDFSUtils$$LOCKER_SUFFIX = "_HDFS";
        this.DEFAULT_CACHE_LABEL = "default";
        this.org$apache$linkis$hadoop$common$utils$HDFSUtils$$JOINT = "_";
        this.count = new AtomicLong();
        if (HadoopConf$.MODULE$.HDFS_ENABLE_CACHE() && HadoopConf$.MODULE$.HDFS_ENABLE_CACHE_CLOSE()) {
            this.logger().info("HDFS Cache clear enabled ");
            object = Utils$.MODULE$.defaultScheduler().scheduleAtFixedRate(new Runnable(){

                public void run() {
                    Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(HDFSUtils$.MODULE$.org$apache$linkis$hadoop$common$utils$HDFSUtils$$fileSystemCache().values()).asScala()).filter((Function1 & Serializable & scala.Serializable)hdfsFileSystemContainer -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$run$2(hdfsFileSystemContainer)))).foreach((Function1 & Serializable & scala.Serializable)hdfsFileSystemContainer -> {
                        anon.1.$anonfun$run$3(hdfsFileSystemContainer);
                        return BoxedUnit.UNIT;
                    }), HDFSUtils$.MODULE$.logger());
                }

                public static final /* synthetic */ boolean $anonfun$run$2(HDFSFileSystemContainer hdfsFileSystemContainer) {
                    return hdfsFileSystemContainer.canRemove() && StringUtils.isNotBlank((CharSequence)hdfsFileSystemContainer.getUser());
                }

                public static final /* synthetic */ void $anonfun$run$3(HDFSFileSystemContainer hdfsFileSystemContainer) {
                    String locker = new StringBuilder(0).append(hdfsFileSystemContainer.getUser()).append(HDFSUtils$.MODULE$.org$apache$linkis$hadoop$common$utils$HDFSUtils$$LOCKER_SUFFIX()).toString();
                    String string = locker.intern();
                    synchronized (string) {
                        if (hdfsFileSystemContainer.canRemove() && !HadoopConf$.MODULE$.HDFS_ENABLE_NOT_CLOSE_USERS().contains(hdfsFileSystemContainer.getUser())) {
                            HDFSUtils$.MODULE$.org$apache$linkis$hadoop$common$utils$HDFSUtils$$fileSystemCache().remove(new StringBuilder(0).append(hdfsFileSystemContainer.getUser()).append(HDFSUtils$.MODULE$.org$apache$linkis$hadoop$common$utils$HDFSUtils$$JOINT()).append(hdfsFileSystemContainer.getLabel()).toString());
                            IOUtils.closeQuietly((Closeable)hdfsFileSystemContainer.getFileSystem());
                            HDFSUtils$.MODULE$.logger().info(new StringBuilder(81).append("user").append(hdfsFileSystemContainer.getUser()).append(" to remove hdfsFileSystemContainer,because hdfsFileSystemContainer can remove").toString());
                        }
                    }
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(), $anonfun$run$2$adapted(org.apache.linkis.hadoop.common.entity.HDFSFileSystemContainer ), $anonfun$run$3$adapted(org.apache.linkis.hadoop.common.entity.HDFSFileSystemContainer )}, serializedLambda);
                }
            }, 180000L, 60000L, TimeUnit.MILLISECONDS);
        } else {
            object = BoxedUnit.UNIT;
        }
    }
}

