/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.client.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.common.listener.Event;
import org.apache.linkis.common.utils.Utils;
import org.apache.linkis.cs.client.builder.ContextClientConfig;
import org.apache.linkis.cs.client.builder.HttpContextClientConfig;
import org.apache.linkis.cs.client.http.ContextHeartBeatAction;
import org.apache.linkis.cs.client.http.ContextHeartBeatResult;
import org.apache.linkis.cs.client.listener.ContextClientListener;
import org.apache.linkis.cs.client.listener.ContextClientListenerBus;
import org.apache.linkis.cs.client.listener.ContextClientListenerManager;
import org.apache.linkis.cs.client.listener.HeartBeater;
import org.apache.linkis.cs.client.utils.SerializeHelper;
import org.apache.linkis.cs.common.entity.source.CommonContextKeyValue;
import org.apache.linkis.cs.common.entity.source.ContextKeyValue;
import org.apache.linkis.cs.listener.callback.imp.ContextKeyValueBean;
import org.apache.linkis.cs.listener.event.enumeration.OperateType;
import org.apache.linkis.cs.listener.event.impl.DefaultContextKeyEvent;
import org.apache.linkis.httpclient.config.ClientConfig;
import org.apache.linkis.httpclient.dws.DWSHttpClient;
import org.apache.linkis.httpclient.dws.config.DWSClientConfig;
import org.apache.linkis.httpclient.request.Action;
import org.apache.linkis.httpclient.response.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHeartBeater
implements HeartBeater {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpHeartBeater.class);
    private ContextClientListenerBus<ContextClientListener, Event> contextClientListenerBus = ContextClientListenerManager.getContextClientListenerBus();
    private final String name = "ContextClientHTTPHeatBeater";
    private final String client_source = "TestClient";
    private DWSHttpClient dwsHttpClient;

    public HttpHeartBeater(ContextClientConfig contextClientConfig) {
        if (contextClientConfig instanceof HttpContextClientConfig) {
            HttpContextClientConfig httpContextClientConfig = (HttpContextClientConfig)contextClientConfig;
            ClientConfig clientConfig = httpContextClientConfig.getClientConfig();
            DWSClientConfig dwsClientConfig = new DWSClientConfig(clientConfig);
            dwsClientConfig.setDWSVersion((String)Configuration.LINKIS_WEB_VERSION().getValue());
            this.dwsHttpClient = new DWSHttpClient(dwsClientConfig, "ContextClientHTTPHeatBeater");
        }
    }

    @Override
    public void heartBeat() {
        ContextHeartBeatAction contextHeartBeatAction = new ContextHeartBeatAction("TestClient");
        contextHeartBeatAction.getRequestPayloads().put("source", "TestClient");
        Result result = null;
        try {
            result = this.dwsHttpClient.execute((Action)contextHeartBeatAction);
        }
        catch (Exception e) {
            LOGGER.error("\u6267\u884cheartbeat\u51fa\u73b0\u5931\u8d25", (Throwable)e);
            return;
        }
        if (result instanceof ContextHeartBeatResult) {
            ContextHeartBeatResult contextHeartBeatResult = (ContextHeartBeatResult)result;
            Map<String, Object> data = contextHeartBeatResult.getData();
            Object object = data.get("ContextKeyValueBean");
            ArrayList<ContextKeyValueBean> kvBeans = new ArrayList<ContextKeyValueBean>();
            if (object instanceof List) {
                List list = (List)object;
                list.stream().filter(Objects::nonNull).map(Object::toString).map(str -> {
                    try {
                        return SerializeHelper.deserializeContextKVBean(str);
                    }
                    catch (ErrorException e) {
                        return null;
                    }
                }).filter(Objects::nonNull).forEach(kvBeans::add);
            }
            if (kvBeans.size() > 0) {
                this.dealCallBack(kvBeans);
            }
        }
    }

    @Override
    public void dealCallBack(List<ContextKeyValueBean> kvs) {
        for (ContextKeyValueBean kv : kvs) {
            CommonContextKeyValue contextKeyValue = new CommonContextKeyValue();
            contextKeyValue.setContextKey(kv.getCsKey());
            contextKeyValue.setContextValue(kv.getCsValue());
            DefaultContextKeyEvent event = new DefaultContextKeyEvent();
            event.setContextID(kv.getCsID());
            event.setOperateType(OperateType.UPDATE);
            event.setContextKeyValue((ContextKeyValue)contextKeyValue);
            this.contextClientListenerBus.post((Event)event);
        }
    }

    @Override
    public void start() {
        Utils.defaultScheduler().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                HttpHeartBeater.this.heartBeat();
            }
        }, 0L, 1L, TimeUnit.HOURS);
    }

    @Override
    public void close() throws IOException {
        try {
            if (null != this.dwsHttpClient) {
                this.dwsHttpClient.close();
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to close httpContextClient", (Throwable)e);
            throw new IOException(e);
        }
    }
}

