/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.filesystem.restful.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math3.util.Pair;
import org.apache.http.Consts;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.io.FsWriter;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.utils.ByteTimeUtils;
import org.apache.linkis.common.utils.ResultSetUtils;
import org.apache.linkis.filesystem.conf.WorkSpaceConfiguration;
import org.apache.linkis.filesystem.entity.DirFileTree;
import org.apache.linkis.filesystem.entity.LogLevel;
import org.apache.linkis.filesystem.exception.WorkSpaceException;
import org.apache.linkis.filesystem.exception.WorkspaceExceptionManager;
import org.apache.linkis.filesystem.service.FsService;
import org.apache.linkis.filesystem.util.WorkspaceUtil;
import org.apache.linkis.filesystem.utils.UserGroupUtils;
import org.apache.linkis.filesystem.validator.PathValidator$;
import org.apache.linkis.governance.common.utils.LoggerUtils;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.apache.linkis.storage.conf.LinkisStorageConf;
import org.apache.linkis.storage.csv.CSVFsWriter;
import org.apache.linkis.storage.domain.FsPathListWithError;
import org.apache.linkis.storage.excel.ExcelFsWriter;
import org.apache.linkis.storage.excel.ExcelStorageReader;
import org.apache.linkis.storage.excel.StorageMultiExcelWriter;
import org.apache.linkis.storage.excel.XlsUtils;
import org.apache.linkis.storage.excel.XlsxUtils;
import org.apache.linkis.storage.exception.ColLengthExceedException;
import org.apache.linkis.storage.fs.FileSystem;
import org.apache.linkis.storage.script.ScriptFsWriter;
import org.apache.linkis.storage.script.ScriptMetaData;
import org.apache.linkis.storage.script.ScriptRecord;
import org.apache.linkis.storage.script.Variable;
import org.apache.linkis.storage.script.VariableParser;
import org.apache.linkis.storage.source.FileSource;
import org.apache.linkis.storage.source.FileSource$;
import org.apache.linkis.storage.utils.StorageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"file system"})
@RestController
@RequestMapping(path={"/filesystem"})
public class FsRestfulApi {
    @Autowired
    private FsService fsService;
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());

    private boolean checkIsUsersDirectory(String requestPath, String userName, Boolean withAdmin) {
        boolean ownerCheck = (Boolean)WorkSpaceConfiguration.FILESYSTEM_PATH_CHECK_OWNER.getValue();
        if (!ownerCheck && withAdmin.booleanValue()) {
            this.LOGGER.debug("not check filesystem owner.");
            return true;
        }
        requestPath = requestPath.toLowerCase().trim() + "/";
        String hdfsUserRootPathPrefix = WorkspaceUtil.suffixTuning((String)WorkSpaceConfiguration.HDFS_USER_ROOT_PATH_PREFIX.getValue());
        String hdfsUserRootPathSuffix = (String)WorkSpaceConfiguration.HDFS_USER_ROOT_PATH_SUFFIX.getValue();
        String localUserRootPath = WorkspaceUtil.suffixTuning((String)WorkSpaceConfiguration.LOCAL_USER_ROOT_PATH.getValue());
        String workspacePath = hdfsUserRootPathPrefix + userName + hdfsUserRootPathSuffix;
        String enginconnPath = localUserRootPath + userName;
        if (withAdmin.booleanValue() && Configuration.isJobHistoryAdmin((String)userName)) {
            workspacePath = hdfsUserRootPathPrefix;
            enginconnPath = localUserRootPath;
        }
        this.LOGGER.debug("requestPath:" + requestPath);
        this.LOGGER.debug("workspacePath:" + workspacePath);
        this.LOGGER.debug("enginconnPath:" + enginconnPath);
        this.LOGGER.debug("adminUser:" + String.join((CharSequence)",", Configuration.getJobHistoryAdmin()));
        return requestPath.contains(workspacePath) || requestPath.contains(enginconnPath);
    }

    private boolean checkIsUsersDirectory(String requestPath, String userName) {
        return this.checkIsUsersDirectory(requestPath, userName, true);
    }

    @ApiOperation(value="getUserRootPath", notes="get user root path", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="pathType", required=false, dataType="String", value="path type")})
    @RequestMapping(path={"/getUserRootPath"}, method={RequestMethod.GET})
    public Message getUserRootPath(HttpServletRequest req, @RequestParam(value="pathType", required=false) String pathType) throws IOException, WorkSpaceException {
        String returnType;
        String path;
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"getUserRootPath");
        String hdfsUserRootPathPrefix = WorkspaceUtil.suffixTuning((String)WorkSpaceConfiguration.HDFS_USER_ROOT_PATH_PREFIX.getValue());
        String hdfsUserRootPathSuffix = (String)WorkSpaceConfiguration.HDFS_USER_ROOT_PATH_SUFFIX.getValue();
        String localUserRootPath = WorkspaceUtil.suffixTuning((String)WorkSpaceConfiguration.LOCAL_USER_ROOT_PATH.getValue());
        if (StorageUtils.HDFS().equalsIgnoreCase(pathType)) {
            path = hdfsUserRootPathPrefix + userName + hdfsUserRootPathSuffix;
            returnType = StorageUtils.HDFS().toUpperCase();
        } else if (StorageUtils.S3().equalsIgnoreCase(pathType)) {
            path = localUserRootPath + userName;
            returnType = StorageUtils.S3().toUpperCase();
        } else {
            path = localUserRootPath + userName;
            returnType = "Local";
        }
        FsPath fsPath = new FsPath(path);
        FileSystem fileSystem = this.fsService.getFileSystem(userName, fsPath);
        if (!fileSystem.exists(fsPath)) {
            if (!FsPath.WINDOWS && !UserGroupUtils.isUserExist(userName)) {
                this.LOGGER.warn("User {} not exist in linkis node.", (Object)userName);
                throw WorkspaceExceptionManager.createException(80031, userName);
            }
            if (((Boolean)WorkSpaceConfiguration.FILESYSTEM_PATH_AUTO_CREATE.getValue()).booleanValue()) {
                try {
                    fileSystem.mkdirs(fsPath);
                    return Message.ok().data(String.format("user%sRootPath", returnType), (Object)path);
                }
                catch (IOException e) {
                    this.LOGGER.error(e.getMessage(), (Throwable)e);
                    throw WorkspaceExceptionManager.createException(80030, path);
                }
            }
            throw WorkspaceExceptionManager.createException(80003, path);
        }
        return Message.ok().data(String.format("user%sRootPath", returnType), (Object)path);
    }

    @ApiOperation(value="createNewDir", notes="create new dir", response=Message.class)
    @ApiOperationSupport(ignoreParameters={"json"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="path", required=true, dataType="String", value="Path")})
    @RequestMapping(path={"/createNewDir"}, method={RequestMethod.POST})
    public Message createNewDir(HttpServletRequest req, @RequestBody JsonNode json) throws IOException, WorkSpaceException {
        String path = json.get("path").textValue();
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("createNewDir " + path));
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw WorkspaceExceptionManager.createException(80004, path);
        }
        if (!this.checkIsUsersDirectory(path, userName)) {
            throw WorkspaceExceptionManager.createException(80010, userName, path);
        }
        WorkspaceUtil.fileAndDirNameSpecialCharCheck(path);
        FsPath fsPath = new FsPath(path);
        FileSystem fileSystem = this.fsService.getFileSystem(userName, fsPath);
        if (fileSystem.exists(fsPath)) {
            throw WorkspaceExceptionManager.createException(80005, path);
        }
        fileSystem.mkdirs(fsPath);
        return Message.ok();
    }

    @ApiOperation(value="createNewFile", notes="create new file", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="path", required=true, dataType="String", value="Path")})
    @ApiOperationSupport(ignoreParameters={"json"})
    @RequestMapping(path={"/createNewFile"}, method={RequestMethod.POST})
    public Message createNewFile(HttpServletRequest req, @RequestBody JsonNode json) throws IOException, WorkSpaceException {
        String path = json.get("path").textValue();
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("createNewFile " + path));
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw WorkspaceExceptionManager.createException(80004, path);
        }
        if (!this.checkIsUsersDirectory(path, userName)) {
            throw WorkspaceExceptionManager.createException(80010, userName, path);
        }
        WorkspaceUtil.fileAndDirNameSpecialCharCheck(path);
        FsPath fsPath = new FsPath(path);
        FileSystem fileSystem = this.fsService.getFileSystem(userName, fsPath);
        if (fileSystem.exists(fsPath)) {
            throw WorkspaceExceptionManager.createException(80006, path);
        }
        fileSystem.createNewFile(fsPath);
        return Message.ok();
    }

    @ApiOperation(value="rename", notes="rename", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="oldDest", required=true, dataType="String", value="old dest"), @ApiImplicitParam(name="newDest", required=true, dataType="String", value="new dest")})
    @ApiOperationSupport(ignoreParameters={"json"})
    @RequestMapping(path={"/rename"}, method={RequestMethod.POST})
    public Message rename(HttpServletRequest req, @RequestBody JsonNode json) throws IOException, WorkSpaceException {
        String oldDest = json.get("oldDest").textValue();
        String newDest = json.get("newDest").textValue();
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("rename " + newDest));
        if (((Boolean)WorkSpaceConfiguration.FILESYSTEM_PATH_CHECK_TRIGGER.getValue()).booleanValue()) {
            this.LOGGER.info(String.format("path check trigger is open,now check the path,oldDest:%s,newDest:%s", oldDest, newDest));
            PathValidator$.MODULE$.validate(oldDest, userName);
            PathValidator$.MODULE$.validate(newDest, userName);
        }
        if (!this.checkIsUsersDirectory(newDest, userName, false)) {
            throw WorkspaceExceptionManager.createException(80010, userName, newDest);
        }
        if (StringUtils.isEmpty((CharSequence)oldDest)) {
            throw WorkspaceExceptionManager.createException(80004, oldDest);
        }
        if (StringUtils.isEmpty((CharSequence)newDest)) {
            return Message.ok();
        }
        WorkspaceUtil.fileAndDirNameSpecialCharCheck(newDest);
        FsPath fsPathOld = new FsPath(oldDest);
        FsPath fsPathNew = new FsPath(newDest);
        FileSystem fileSystem = this.fsService.getFileSystem(userName, fsPathOld);
        if (fileSystem.exists(fsPathNew)) {
            throw WorkspaceExceptionManager.createException(80007, newDest);
        }
        fileSystem.renameTo(fsPathOld, fsPathNew);
        return Message.ok();
    }

    @ApiOperation(value="move", notes="move", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="filePath", required=true, dataType="String", value="file path"), @ApiImplicitParam(name="newDest", required=true, dataType="String", value="new dest")})
    @ApiOperationSupport(ignoreParameters={"json"})
    @RequestMapping(path={"/move"}, method={RequestMethod.POST})
    public Message move(HttpServletRequest req, @RequestBody JsonNode json) throws IOException, WorkSpaceException {
        String filePath = json.get("filePath").textValue();
        String newDir = json.get("newDir").textValue();
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("move " + filePath));
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            return Message.ok();
        }
        if (StringUtils.isEmpty((CharSequence)newDir)) {
            throw WorkspaceExceptionManager.createException(80004, newDir);
        }
        if (((Boolean)WorkSpaceConfiguration.FILESYSTEM_PATH_CHECK_TRIGGER.getValue()).booleanValue()) {
            this.LOGGER.info(String.format("path check trigger is open,now check the path,oldDest:%s,newDest:%s", filePath, newDir));
            PathValidator$.MODULE$.validate(filePath, userName);
            PathValidator$.MODULE$.validate(newDir, userName);
        }
        if (!this.checkIsUsersDirectory(filePath, userName)) {
            throw WorkspaceExceptionManager.createException(80010, userName, filePath);
        }
        FsPath flieOldPath = new FsPath(filePath);
        String name = flieOldPath.getPath().substring(flieOldPath.getPath().lastIndexOf("/") + 1);
        FsPath flieNewPath = new FsPath(newDir + "/" + name);
        FileSystem fileSystem = this.fsService.getFileSystem(userName, flieOldPath);
        WorkspaceUtil.fileAndDirNameSpecialCharCheck(flieOldPath.getPath());
        WorkspaceUtil.fileAndDirNameSpecialCharCheck(flieNewPath.getPath());
        if (!fileSystem.exists(flieOldPath)) {
            throw WorkspaceExceptionManager.createException(80013, filePath);
        }
        fileSystem.renameTo(flieOldPath, flieNewPath);
        return Message.ok();
    }

    @ApiOperation(value="upload", notes="upload", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="path", required=true, dataType="String", value="path"), @ApiImplicitParam(name="file", required=true, dataType="List<MultipartFile> ")})
    @ApiOperationSupport(ignoreParameters={"json"})
    @RequestMapping(path={"/upload"}, method={RequestMethod.POST})
    public Message upload(HttpServletRequest req, @RequestParam(value="path") String path, @RequestParam(value="file") List<MultipartFile> files) throws IOException, WorkSpaceException {
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw WorkspaceExceptionManager.createException(80004, path);
        }
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("upload " + path));
        LoggerUtils.setJobIdMDC((String)("uploadThread_" + userName));
        this.LOGGER.info("userName {} start to upload File {}", (Object)userName, (Object)path);
        if (!this.checkIsUsersDirectory(path, userName)) {
            throw WorkspaceExceptionManager.createException(80010, userName, path);
        }
        FsPath fsPath = new FsPath(path);
        FileSystem fileSystem = this.fsService.getFileSystem(userName, fsPath);
        for (MultipartFile p : files) {
            String fileName = p.getOriginalFilename();
            WorkspaceUtil.charCheckFileName(fileName);
            FsPath fsPathNew = new FsPath(fsPath.getPath() + "/" + fileName);
            fileSystem.createNewFile(fsPathNew);
            InputStream is = p.getInputStream();
            Throwable throwable = null;
            try {
                OutputStream outputStream = fileSystem.write(fsPathNew, true);
                Throwable throwable2 = null;
                try {
                    IOUtils.copy((InputStream)is, (OutputStream)outputStream);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (outputStream == null) continue;
                    if (throwable2 != null) {
                        try {
                            outputStream.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    outputStream.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                is.close();
            }
        }
        this.LOGGER.info("userName {} Finished to upload File {}", (Object)userName, (Object)path);
        LoggerUtils.removeJobIdMDC();
        return Message.ok();
    }

    @ApiOperation(value="deleteDirOrFile", notes="delete dir or file", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="path", required=true, dataType="String", value="path")})
    @ApiOperationSupport(ignoreParameters={"json"})
    @RequestMapping(path={"/deleteDirOrFile"}, method={RequestMethod.POST})
    public Message deleteDirOrFile(HttpServletRequest req, @RequestBody JsonNode json) throws IOException, WorkSpaceException {
        String path = json.get("path").textValue();
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("deleteDirOrFile " + path));
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw WorkspaceExceptionManager.createException(80004, path);
        }
        if (!this.checkIsUsersDirectory(path, userName)) {
            throw WorkspaceExceptionManager.createException(80010, userName, path);
        }
        FsPath fsPath = new FsPath(path);
        FileSystem fileSystem = this.fsService.getFileSystem(userName, fsPath);
        if (!fileSystem.exists(fsPath)) {
            throw WorkspaceExceptionManager.createException(80008, new Object[0]);
        }
        if (!fileSystem.canWrite(fsPath.getParent()) || !fileSystem.canExecute(fsPath.getParent())) {
            throw WorkspaceExceptionManager.createException(80009, new Object[0]);
        }
        FsRestfulApi.deleteAllFiles(fileSystem, fsPath);
        return Message.ok();
    }

    @ApiOperation(value="getDirFileTrees", notes="get dir file trees", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="path", required=false, dataType="String", value="path")})
    @ApiOperationSupport(ignoreParameters={"json"})
    @RequestMapping(path={"/getDirFileTrees"}, method={RequestMethod.GET})
    public Message getDirFileTrees(HttpServletRequest req, @RequestParam(value="path", required=false) String path) throws IOException, WorkSpaceException {
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw WorkspaceExceptionManager.createException(80004, path);
        }
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("getDirFileTrees " + path));
        if (!this.checkIsUsersDirectory(path, userName)) {
            throw WorkspaceExceptionManager.createException(80010, userName, path);
        }
        FsPath fsPath = new FsPath(path);
        FileSystem fileSystem = this.fsService.getFileSystemForRead(userName, fsPath);
        if (!fileSystem.exists(fsPath)) {
            return Message.ok().data("dirFileTrees", null);
        }
        DirFileTree dirFileTree = new DirFileTree();
        dirFileTree.setPath(fsPath.getSchemaPath());
        if (!fileSystem.canExecute(fsPath) || !fileSystem.canRead(fsPath)) {
            throw WorkspaceExceptionManager.createException(80010, userName, path);
        }
        dirFileTree.setName(new File(path).getName());
        dirFileTree.setChildren(new ArrayList<DirFileTree>());
        HashSet<String> fileNameSet = new HashSet<String>();
        fileNameSet.add(dirFileTree.getPath().trim());
        FsPathListWithError fsPathListWithError = fileSystem.listPathWithError(fsPath);
        if (fsPathListWithError != null) {
            for (FsPath children : fsPathListWithError.getFsPaths()) {
                DirFileTree dirFileTreeChildren = new DirFileTree();
                dirFileTreeChildren.setName(new File(children.getPath()).getName());
                dirFileTreeChildren.setPath(fsPath.getFsType() + "://" + children.getPath());
                dirFileTreeChildren.setProperties(new HashMap<String, String>());
                dirFileTreeChildren.setParentPath(fsPath.getSchemaPath());
                if (fileNameSet.contains(dirFileTreeChildren.getPath().trim())) {
                    this.LOGGER.info("File {} is duplicate", (Object)dirFileTreeChildren.getPath());
                    continue;
                }
                fileNameSet.add(dirFileTreeChildren.getPath().trim());
                if (!children.isdir()) {
                    dirFileTreeChildren.setIsLeaf(true);
                    dirFileTreeChildren.getProperties().put("size", String.valueOf(children.getLength()));
                    dirFileTreeChildren.getProperties().put("modifytime", String.valueOf(children.getModification_time()));
                }
                dirFileTree.getChildren().add(dirFileTreeChildren);
            }
        }
        return Message.ok().data("dirFileTrees", (Object)dirFileTree);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="download", notes="download", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="path", required=true, dataType="String", value="path"), @ApiImplicitParam(name="charset", required=true, dataType="String", value="charset")})
    @ApiOperationSupport(ignoreParameters={"json"})
    @RequestMapping(path={"/download"}, method={RequestMethod.POST})
    public void download(HttpServletRequest req, HttpServletResponse response, @RequestBody Map<String, String> json) throws IOException, WorkSpaceException {
        InputStream inputStream = null;
        ServletOutputStream outputStream = null;
        PrintWriter writer = null;
        try {
            String charset = json.get("charset");
            String path = json.get("path");
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("download " + path));
            LoggerUtils.setJobIdMDC((String)("downloadThread_" + userName));
            this.LOGGER.info("userName {} start to download File {}", (Object)userName, (Object)path);
            if (StringUtils.isEmpty((CharSequence)path)) {
                throw WorkspaceExceptionManager.createException(80004, path);
            }
            if (StringUtils.isEmpty((CharSequence)charset)) {
                charset = Consts.UTF_8.toString();
            }
            if (!this.checkIsUsersDirectory(path, userName)) {
                throw WorkspaceExceptionManager.createException(80010, userName, path);
            }
            FsPath fsPath = new FsPath(path);
            FileSystem fileSystem = this.fsService.getFileSystemForRead(userName, fsPath);
            if (!fileSystem.exists(fsPath)) {
                throw WorkspaceExceptionManager.createException(80011, path);
            }
            inputStream = fileSystem.read(fsPath);
            byte[] buffer = new byte[1024];
            int bytesRead = 0;
            response.setCharacterEncoding(charset);
            Path source = Paths.get(fsPath.getPath(), new String[0]);
            response.addHeader("Content-Type", Files.probeContentType(source));
            response.addHeader("Content-Disposition", "attachment;filename=" + new File(path).getName());
            outputStream = response.getOutputStream();
            while ((bytesRead = inputStream.read(buffer, 0, 1024)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            this.LOGGER.info("userName {} Finished to download File {}", (Object)userName, (Object)path);
        }
        catch (Exception e) {
            try {
                this.LOGGER.error("download failed", (Throwable)e);
                response.reset();
                response.setCharacterEncoding(Consts.UTF_8.toString());
                response.setContentType("text/plain; charset=utf-8");
                writer = response.getWriter();
                writer.append("error(\u9519\u8bef):" + e.getMessage());
                writer.flush();
            }
            catch (Throwable throwable) {
                LoggerUtils.removeJobIdMDC();
                if (outputStream != null) {
                    outputStream.flush();
                }
                IOUtils.closeQuietly(outputStream);
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            LoggerUtils.removeJobIdMDC();
            if (outputStream != null) {
                outputStream.flush();
            }
            IOUtils.closeQuietly(outputStream);
            IOUtils.closeQuietly(inputStream);
            IOUtils.closeQuietly((Writer)writer);
        }
        LoggerUtils.removeJobIdMDC();
        if (outputStream != null) {
            outputStream.flush();
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((Writer)writer);
    }

    @ApiOperation(value="isExist", notes="is exist", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="path", dataType="String", value="path")})
    @RequestMapping(path={"/isExist"}, method={RequestMethod.GET})
    public Message isExist(HttpServletRequest req, @RequestParam(value="path", required=false) String path) throws IOException, WorkSpaceException {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("isExist " + path));
        FsPath fsPath = new FsPath(path);
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw WorkspaceExceptionManager.createException(80004, path);
        }
        if (!this.checkIsUsersDirectory(path, userName)) {
            throw WorkspaceExceptionManager.createException(80010, userName, path);
        }
        FileSystem fileSystem = this.fsService.getFileSystem(userName, fsPath);
        return Message.ok().data("isExist", (Object)fileSystem.exists(fsPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="FileInfo", notes="File_Info", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="path", required=false, dataType="String", value="Path"), @ApiImplicitParam(name="pageSize", required=true, dataType="Integer", defaultValue="5000")})
    @RequestMapping(path={"/fileInfo"}, method={RequestMethod.GET})
    public Message fileInfo(HttpServletRequest req, @RequestParam(value="path", required=false) String path, @RequestParam(value="pageSize", defaultValue="5000") Integer pageSize) throws IOException, WorkSpaceException {
        Message message;
        FsPath fsPath;
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw WorkspaceExceptionManager.createException(80004, path);
        }
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("fileInfo " + path));
        FileSystem fileSystem = this.fsService.getFileSystemForRead(userName, fsPath = new FsPath(path));
        if (!fileSystem.canRead(fsPath)) {
            throw WorkspaceExceptionManager.createException(80012, new Object[0]);
        }
        FileSource fileSource = null;
        try {
            Message message2 = Message.ok();
            fileSource = FileSource$.MODULE$.create(fsPath, (Fs)fileSystem);
            Pair[] fileInfo = fileSource.getFileInfo(pageSize.intValue());
            IOUtils.closeQuietly((Closeable)fileSource);
            if (null != fileInfo && fileInfo.length > 0) {
                message2.data("path", (Object)path);
                message2.data("colNumber", fileInfo[0].getFirst());
                message2.data("rowNumber", fileInfo[0].getSecond());
            } else {
                message2.data("path", (Object)path);
                message2.data("colNumber", (Object)0);
                message2.data("rowNumber", (Object)0);
            }
            message = message2;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileSource);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)fileSource);
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="openFile", notes="open file", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="path", required=false, dataType="String", value="Path"), @ApiImplicitParam(name="page", required=true, dataType="Integer", defaultValue="1"), @ApiImplicitParam(name="pageSize", dataType="Integer", defaultValue="5000"), @ApiImplicitParam(name="nullValue", required=false, dataType="String", defaultValue=""), @ApiImplicitParam(name="enableLimit", required=false, dataType="String", defaultValue=""), @ApiImplicitParam(name="columnIndices", required=false, dataType="array"), @ApiImplicitParam(name="columnPageSize", required=false, dataType="Integer", defaultValue="500"), @ApiImplicitParam(name="pageSize", required=true, dataType="Integer", defaultValue="5000")})
    @RequestMapping(path={"/openFile"}, method={RequestMethod.GET})
    public Message openFile(HttpServletRequest req, @RequestParam(value="path", required=false) String path, @RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="pageSize", defaultValue="5000") Integer pageSize, @RequestParam(value="nullValue", defaultValue="") String nullValue, @RequestParam(value="enableLimit", defaultValue="") String enableLimit, @RequestParam(value="columnPage", required=false, defaultValue="1") Integer columnPage, @RequestParam(value="columnPageSize", required=false, defaultValue="500") Integer columnPageSize) throws IOException, WorkSpaceException {
        Message message = Message.ok();
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw WorkspaceExceptionManager.createException(80004, path);
        }
        if (columnPage < 1 || columnPageSize < 1 || columnPageSize > 500) {
            throw WorkspaceExceptionManager.createException(80036, path);
        }
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("openFile " + path));
        LoggerUtils.setJobIdMDC((String)("openFileThread_" + userName));
        this.LOGGER.info("userName {} start to open File {}", (Object)userName, (Object)path);
        Long startTime = System.currentTimeMillis();
        if (!this.checkIsUsersDirectory(path, userName)) {
            throw WorkspaceExceptionManager.createException(80010, userName, path);
        }
        FsPath fsPath = new FsPath(path);
        FileSystem fileSystem = this.fsService.getFileSystemForRead(userName, fsPath);
        if (!fileSystem.canRead(fsPath)) {
            throw WorkspaceExceptionManager.createException(80012, new Object[0]);
        }
        int[] columnIndices = null;
        FileSource fileSource = null;
        try {
            fileSource = FileSource$.MODULE$.create(fsPath, (Fs)fileSystem);
            if (nullValue != null && "BLANK".equalsIgnoreCase(nullValue)) {
                nullValue = "";
            }
            if (FileSource$.MODULE$.isResultSet(fsPath.getPath())) {
                if (!StringUtils.isEmpty((CharSequence)nullValue)) {
                    fileSource.addParams("nullValue", nullValue);
                }
                if (pageSize > (Integer)WorkSpaceConfiguration.FILESYSTEM_RESULTSET_ROW_LIMIT.getValue()) {
                    throw WorkspaceExceptionManager.createException(80034, WorkSpaceConfiguration.FILESYSTEM_RESULTSET_ROW_LIMIT.getValue());
                }
                if (StringUtils.isNotBlank((CharSequence)enableLimit)) {
                    this.LOGGER.info("set enable limit for thread: {}", (Object)Thread.currentThread().getName());
                    LinkisStorageConf.enableLimitThreadLocal().set(enableLimit);
                    columnIndices = this.genColumnIndices(columnPage, columnPageSize);
                    LinkisStorageConf.columnIndicesThreadLocal().set(columnIndices);
                }
                fileSource = fileSource.page(page.intValue(), pageSize.intValue());
            } else if (fileSystem.getLength(fsPath) > ByteTimeUtils.byteStringAsBytes((String)((String)WorkSpaceConfiguration.FILESYSTEM_FILE_CHECK_SIZE.getValue()))) {
                throw WorkspaceExceptionManager.createException(80032, new Object[0]);
            }
            try {
                Pair result = fileSource.collect()[0];
                this.LOGGER.info("Finished to open File {}, taken {} ms", (Object)path, (Object)(System.currentTimeMillis() - startTime));
                IOUtils.closeQuietly((Closeable)fileSource);
                Object metaMap = result.getFirst();
                Map[] newMap = null;
                try {
                    if (metaMap instanceof Map[]) {
                        Map[] realMap = (Map[])metaMap;
                        int realSize = realMap.length;
                        if ((columnPage - 1) * columnPageSize > realSize) {
                            throw WorkspaceExceptionManager.createException(80036, path);
                        }
                        message.data("totalColumn", (Object)realSize);
                        if (realSize > (Integer)WorkSpaceConfiguration.FILESYSTEM_RESULT_SET_COLUMN_LIMIT.getValue()) {
                            message.data("column_limit_display", (Object)true);
                            message.data("zh_msg", (Object)("\u5168\u91cf\u7ed3\u679c\u96c6\u8d85\u8fc7" + WorkSpaceConfiguration.FILESYSTEM_RESULT_SET_COLUMN_LIMIT.getValue() + "\u5217\uff0c\u9875\u9762\u63d0\u4f9b500\u5217\u6570\u636e\u9884\u89c8\uff0c\u5982\u9700\u67e5\u770b\u5b8c\u6574\u7ed3\u679c\u96c6\uff0c\u8bf7\u4f7f\u7528\u7ed3\u679c\u96c6\u5bfc\u51fa\u529f\u80fd"));
                            message.data("en_msg", (Object)"Because your result set is large, to view the full result set, use the Result set Export feature.");
                        }
                        if (columnIndices == null || columnIndices.length >= realSize) {
                            newMap = realMap;
                        } else {
                            int realLength = columnPage * columnPageSize > realSize ? realSize - (columnPage - 1) * columnPageSize : columnPageSize;
                            newMap = new Map[realLength];
                            for (int i = 0; i < realLength; ++i) {
                                newMap[i] = realMap[columnIndices[i]];
                            }
                        }
                    }
                }
                catch (Exception e) {
                    this.LOGGER.info("Failed to set flag", (Throwable)e);
                }
                message.data("metadata", newMap == null ? metaMap : newMap).data("fileContent", result.getSecond());
                message.data("type", (Object)fileSource.getFileSplits()[0].type());
                message.data("totalLine", (Object)fileSource.getTotalLine());
                Message message2 = message.data("page", (Object)page).data("totalPage", (Object)0);
                return message2;
            }
            catch (ColLengthExceedException e) {
                this.LOGGER.info("Failed to open file {}", (Object)path, (Object)e);
                message.data("type", (Object)fileSource.getFileSplits()[0].type());
                message.data("display_prohibited", (Object)true);
                message.data("zh_msg", (Object)MessageFormat.format("\u7ed3\u679c\u96c6\u5b58\u5728\u5b57\u6bb5\u503c\u5b57\u7b26\u6570\u8d85\u8fc7{0}\uff0c\u5982\u9700\u67e5\u770b\u5168\u90e8\u6570\u636e\u8bf7\u5bfc\u51fa\u6587\u4ef6\u6216\u4f7f\u7528\u5b57\u7b26\u4e32\u622a\u53d6\u51fd\u6570\uff08substring\u3001substr\uff09\u622a\u53d6\u76f8\u5173\u5b57\u7b26\u5373\u53ef\u524d\u7aef\u5c55\u793a\u6570\u636e\u5185\u5bb9", LinkisStorageConf.LINKIS_RESULT_COL_LENGTH()));
                message.data("en_msg", (Object)MessageFormat.format("There is a field value exceed {0} characters or col size exceed {1} in the result set. If you want to view it, please use the result set export function.", LinkisStorageConf.LINKIS_RESULT_COL_LENGTH(), LinkisStorageConf.LINKIS_RESULT_COLUMN_SIZE()));
                Message message3 = message;
                if (StringUtils.isNotBlank((CharSequence)enableLimit)) {
                    LinkisStorageConf.enableLimitThreadLocal().remove();
                }
                LoggerUtils.removeJobIdMDC();
                IOUtils.closeQuietly((Closeable)fileSource);
                return message3;
            }
        }
        finally {
            if (StringUtils.isNotBlank((CharSequence)enableLimit)) {
                LinkisStorageConf.enableLimitThreadLocal().remove();
            }
            LoggerUtils.removeJobIdMDC();
            IOUtils.closeQuietly((Closeable)fileSource);
        }
    }

    private int[] genColumnIndices(Integer columnPage, Integer columnPageSize) {
        int[] indexArray = new int[columnPageSize.intValue()];
        for (int i = 0; i < columnPageSize; ++i) {
            indexArray[i] = (columnPage - 1) * columnPageSize + i;
        }
        return indexArray;
    }

    @ApiOperation(value="saveScript", notes="save script", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="path", required=true, dataType="String", value="path"), @ApiImplicitParam(name="scriptContent", dataType="String"), @ApiImplicitParam(name="params", required=false, dataType="Object", value="params"), @ApiImplicitParam(name="charset", required=false, dataType="String", value="charset")})
    @ApiOperationSupport(ignoreParameters={"json"})
    @RequestMapping(path={"/saveScript"}, method={RequestMethod.POST})
    public Message saveScript(HttpServletRequest req, @RequestBody Map<String, Object> json) throws IOException, WorkSpaceException {
        String path = (String)json.get("path");
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("saveScript " + path));
        LoggerUtils.setJobIdMDC((String)("saveScriptThread_" + userName));
        this.LOGGER.info("userName {} start to saveScript File {}", (Object)userName, (Object)path);
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw WorkspaceExceptionManager.createException(80004, path);
        }
        String charset = (String)json.get("charset");
        if (StringUtils.isEmpty((CharSequence)charset)) {
            charset = Consts.UTF_8.toString();
        }
        if (!this.checkIsUsersDirectory(path, userName)) {
            throw WorkspaceExceptionManager.createException(80010, userName, path);
        }
        String scriptContent = (String)json.get("scriptContent");
        Object params = json.get("params");
        Map map = (Map)params;
        Variable[] v = VariableParser.getVariables((Map)map);
        FsPath fsPath = new FsPath(path);
        FileSystem fileSystem = this.fsService.getFileSystem(userName, fsPath);
        if (!fileSystem.exists(fsPath)) {
            throw WorkspaceExceptionManager.createException(80013, path);
        }
        if (!fileSystem.canWrite(fsPath)) {
            throw WorkspaceExceptionManager.createException(80014, new Object[0]);
        }
        try (ScriptFsWriter scriptFsWriter = ScriptFsWriter.getScriptFsWriter((FsPath)fsPath, (String)charset, (OutputStream)fileSystem.write(fsPath, true));){
            scriptFsWriter.addMetaData((MetaData)new ScriptMetaData(v));
            String[] split = scriptContent.split("\\n");
            for (int i = 0; i < split.length; ++i) {
                if ("".equals(split[i]) || i != split.length - 1) {
                    int n = i;
                    split[n] = split[n] + "\n";
                }
                scriptFsWriter.addRecord((Record)new ScriptRecord(split[i]));
            }
            this.LOGGER.info("userName {} Finished to saveScript File {}", (Object)userName, (Object)path);
            LoggerUtils.removeJobIdMDC();
            Message message = Message.ok();
            return message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="resultsetToExcel", notes="resultset to excel", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="path", required=false, dataType="String", value="path"), @ApiImplicitParam(name="charset", required=true, dataType="String", defaultValue="utf-8"), @ApiImplicitParam(name="outputFileType", required=true, dataType="String", defaultValue="csv"), @ApiImplicitParam(name="csvSeperator", required=true, dataType="String", defaultValue=","), @ApiImplicitParam(name="quoteRetouchEnable", dataType="boolean"), @ApiImplicitParam(name="outputFileName", required=true, dataType="String", defaultValue="downloadResultset"), @ApiImplicitParam(name="sheetName", required=true, dataType="String", defaultValue="result"), @ApiImplicitParam(name="nullValue", required=true, dataType="String", defaultValue="NULL"), @ApiImplicitParam(name="limit", required=true, dataType="Integer", defaultValue="0"), @ApiImplicitParam(name="autoFormat", dataType="Boolean")})
    @RequestMapping(path={"resultsetToExcel"}, method={RequestMethod.GET})
    public void resultsetToExcel(HttpServletRequest req, HttpServletResponse response, @RequestParam(value="path", required=false) String path, @RequestParam(value="charset", defaultValue="utf-8") String charset, @RequestParam(value="outputFileType", defaultValue="csv") String outputFileType, @RequestParam(value="csvSeperator", defaultValue=",") String csvSeperator, @RequestParam(value="csvSeparator", defaultValue=",") String csvSeparator, @RequestParam(value="quoteRetouchEnable", required=false) boolean quoteRetouchEnable, @RequestParam(value="outputFileName", defaultValue="downloadResultset") String outputFileName, @RequestParam(value="sheetName", defaultValue="result") String sheetName, @RequestParam(value="nullValue", defaultValue="NULL") String nullValue, @RequestParam(value="limit", defaultValue="0") Integer limit, @RequestParam(value="autoFormat", defaultValue="false") Boolean autoFormat, @RequestParam(value="keepNewline", defaultValue="false") Boolean keepNewline) throws WorkSpaceException, IOException {
        ServletOutputStream outputStream = null;
        Object fsWriter = null;
        PrintWriter writer = null;
        FileSource fileSource = null;
        if (csvSeparator.equals(",") && !csvSeperator.equals(",")) {
            csvSeparator = csvSeperator;
        }
        this.LOGGER.info("resultsetToExcel with outputFileType:{}, csvSeparator:{}, quoteRetouchEnable:{}, charset:{}", new Object[]{outputFileType, csvSeparator, quoteRetouchEnable, charset});
        try {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("resultsetToExcel " + path));
            LoggerUtils.setJobIdMDC((String)("resultsetToExcelThread_" + userName));
            this.LOGGER.info("userName {} start to resultsetToExcel File {}", (Object)userName, (Object)path);
            FsPath fsPath = new FsPath(path);
            FileSystem fileSystem = this.fsService.getFileSystemForRead(userName, fsPath);
            boolean isLimitDownloadSize = (Boolean)WorkSpaceConfiguration.RESULT_SET_DOWNLOAD_IS_LIMIT.getValue();
            Integer csvDownloadSize = (Integer)WorkSpaceConfiguration.RESULT_SET_DOWNLOAD_MAX_SIZE_CSV.getValue();
            Integer excelDownloadSize = (Integer)WorkSpaceConfiguration.RESULT_SET_DOWNLOAD_MAX_SIZE_EXCEL.getValue();
            if (limit > 0) {
                csvDownloadSize = limit;
                excelDownloadSize = limit;
            }
            if (StringUtils.isEmpty((CharSequence)path)) {
                throw WorkspaceExceptionManager.createException(80004, path);
            }
            if (!this.checkIsUsersDirectory(path, userName)) {
                throw WorkspaceExceptionManager.createException(80010, userName, path);
            }
            response.addHeader("Content-Disposition", "attachment;filename=" + new String(outputFileName.getBytes("UTF-8"), "ISO8859-1") + "." + outputFileType);
            response.setCharacterEncoding(charset);
            outputStream = response.getOutputStream();
            if (nullValue != null && "BLANK".equalsIgnoreCase(nullValue)) {
                nullValue = "";
            }
            fileSource = FileSource$.MODULE$.create(fsPath, (Fs)fileSystem).addParams("nullValue", nullValue);
            switch (outputFileType) {
                case "csv": {
                    fsWriter = FileSource$.MODULE$.isTableResultSet(fileSource) ? CSVFsWriter.getCSVFSWriter((String)charset, (String)csvSeparator, (boolean)quoteRetouchEnable, (OutputStream)outputStream, (boolean)keepNewline) : ScriptFsWriter.getScriptFsWriter((FsPath)new FsPath(outputFileType), (String)charset, (OutputStream)outputStream);
                    response.addHeader("Content-Type", "text/plain");
                    if (!isLimitDownloadSize) break;
                    fileSource = fileSource.page(1, csvDownloadSize.intValue());
                    break;
                }
                case "xlsx": {
                    if (!FileSource$.MODULE$.isTableResultSet(fileSource)) {
                        throw WorkspaceExceptionManager.createException(80024, new Object[0]);
                    }
                    fsWriter = ExcelFsWriter.getExcelFsWriter((String)charset, (String)sheetName, (String)"yyyy-MM-dd HH:mm:ss", (OutputStream)outputStream, (boolean)autoFormat);
                    response.addHeader("Content-Type", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
                    if (!isLimitDownloadSize) break;
                    fileSource = fileSource.page(1, excelDownloadSize.intValue());
                    break;
                }
                default: {
                    WorkspaceExceptionManager.createException(80015, new Object[0]);
                }
            }
            fileSource.write(fsWriter);
            fsWriter.flush();
            this.LOGGER.info("userName {} Finished to resultsetToExcel File {}", (Object)userName, (Object)path);
        }
        catch (Exception e) {
            try {
                this.LOGGER.error("output failed", (Throwable)e);
                response.reset();
                response.setCharacterEncoding(Consts.UTF_8.toString());
                response.setContentType("text/plain; charset=utf-8");
                writer = response.getWriter();
                writer.append("error(\u9519\u8bef):" + e.getMessage());
                writer.flush();
            }
            catch (Throwable throwable) {
                LoggerUtils.removeJobIdMDC();
                if (outputStream != null) {
                    outputStream.flush();
                }
                IOUtils.closeQuietly(fsWriter);
                IOUtils.closeQuietly(fileSource);
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            LoggerUtils.removeJobIdMDC();
            if (outputStream != null) {
                outputStream.flush();
            }
            IOUtils.closeQuietly(fsWriter);
            IOUtils.closeQuietly(fileSource);
            IOUtils.closeQuietly((Writer)writer);
        }
        LoggerUtils.removeJobIdMDC();
        if (outputStream != null) {
            outputStream.flush();
        }
        IOUtils.closeQuietly((Closeable)fsWriter);
        IOUtils.closeQuietly((Closeable)fileSource);
        IOUtils.closeQuietly((Writer)writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="resultsetsToExcel", notes="resultsets to excel", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="path", required=false, dataType="String", value="path"), @ApiImplicitParam(name="outputFileName", required=true, dataType="String", defaultValue="downloadResultset"), @ApiImplicitParam(name="nullValue", required=true, dataType="String", defaultValue="NULL"), @ApiImplicitParam(name="limit", required=true, dataType="Integer", defaultValue="0"), @ApiImplicitParam(name="autoFormat", dataType="Boolean")})
    @RequestMapping(path={"resultsetsToExcel"}, method={RequestMethod.GET})
    public void resultsetsToExcel(HttpServletRequest req, HttpServletResponse response, @RequestParam(value="path", required=false) String path, @RequestParam(value="outputFileName", defaultValue="downloadResultset") String outputFileName, @RequestParam(value="nullValue", defaultValue="NULL") String nullValue, @RequestParam(value="limit", defaultValue="0") Integer limit, @RequestParam(value="autoFormat", defaultValue="false") Boolean autoFormat) throws WorkSpaceException, IOException {
        ServletOutputStream outputStream = null;
        StorageMultiExcelWriter fsWriter = null;
        PrintWriter writer = null;
        FileSource fileSource = null;
        try {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("resultsetsToExcel " + path));
            LoggerUtils.setJobIdMDC((String)("resultsetsToExcelThread_" + userName));
            this.LOGGER.info("userName {} start to resultsetsToExcel File {}", (Object)userName, (Object)path);
            FsPath fsPath = new FsPath(path);
            FileSystem fileSystem = this.fsService.getFileSystemForRead(userName, fsPath);
            if (StringUtils.isEmpty((CharSequence)path)) {
                throw WorkspaceExceptionManager.createException(80004, path);
            }
            if (!this.checkIsUsersDirectory(path, userName)) {
                throw WorkspaceExceptionManager.createException(80010, userName, path);
            }
            FsPathListWithError fsPathListWithError = fileSystem.listPathWithError(fsPath);
            if (fsPathListWithError == null) {
                throw WorkspaceExceptionManager.createException(80029, new Object[0]);
            }
            List fsPathList = fsPathListWithError.getFsPaths();
            ResultSetUtils.sortByNameNum((List)fsPathList);
            FsPath[] fsPaths = fsPathList.toArray(new FsPath[0]);
            boolean isLimitDownloadSize = (Boolean)WorkSpaceConfiguration.RESULT_SET_DOWNLOAD_IS_LIMIT.getValue();
            Integer excelDownloadSize = (Integer)WorkSpaceConfiguration.RESULT_SET_DOWNLOAD_MAX_SIZE_EXCEL.getValue();
            if (limit > 0) {
                excelDownloadSize = limit;
            }
            response.addHeader("Content-Disposition", "attachment;filename=" + new String(outputFileName.getBytes(StandardCharsets.UTF_8), "ISO8859-1") + ".xlsx");
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            outputStream = response.getOutputStream();
            if (nullValue != null && "BLANK".equalsIgnoreCase(nullValue)) {
                nullValue = "";
            }
            if (!FileSource$.MODULE$.isTableResultSet(fileSource = FileSource$.MODULE$.create(fsPaths, (Fs)fileSystem).addParams("nullValue", nullValue))) {
                throw WorkspaceExceptionManager.createException(80024, new Object[0]);
            }
            fsWriter = new StorageMultiExcelWriter((OutputStream)outputStream, autoFormat.booleanValue());
            response.addHeader("Content-Type", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            if (isLimitDownloadSize) {
                fileSource = fileSource.page(1, excelDownloadSize.intValue());
            }
            fileSource.write((FsWriter)fsWriter);
            fsWriter.flush();
            this.LOGGER.info("userName {} Finished to resultsetsToExcel File {}", (Object)userName, (Object)path);
        }
        catch (Exception e) {
            try {
                this.LOGGER.error("output failed", (Throwable)e);
                response.reset();
                response.setCharacterEncoding(Consts.UTF_8.toString());
                response.setContentType("text/plain; charset=utf-8");
                writer = response.getWriter();
                writer.append("error(\u9519\u8bef):" + e.getMessage());
                writer.flush();
            }
            catch (Throwable throwable) {
                LoggerUtils.removeJobIdMDC();
                if (outputStream != null) {
                    outputStream.flush();
                }
                IOUtils.closeQuietly(fsWriter);
                IOUtils.closeQuietly(fileSource);
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            LoggerUtils.removeJobIdMDC();
            if (outputStream != null) {
                outputStream.flush();
            }
            IOUtils.closeQuietly(fsWriter);
            IOUtils.closeQuietly(fileSource);
            IOUtils.closeQuietly((Writer)writer);
        }
        LoggerUtils.removeJobIdMDC();
        if (outputStream != null) {
            outputStream.flush();
        }
        IOUtils.closeQuietly((Closeable)fsWriter);
        IOUtils.closeQuietly((Closeable)fileSource);
        IOUtils.closeQuietly((Writer)writer);
    }

    @ApiOperation(value="formate", notes="formate", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="path", required=false, dataType="String", value="Path"), @ApiImplicitParam(name="encoding", required=true, dataType="String", defaultValue="utf-8"), @ApiImplicitParam(name="fieldDelimiter", required=true, dataType="String", defaultValue=","), @ApiImplicitParam(name="hasHeader", required=true, defaultValue="false", dataType="Boolean"), @ApiImplicitParam(name="quote", required=true, dataType="String", defaultValue="\""), @ApiImplicitParam(name="escapeQuotes", required=true, dataType="Boolean", defaultValue="false")})
    @RequestMapping(path={"formate"}, method={RequestMethod.GET})
    public Message formate(HttpServletRequest req, @RequestParam(value="path", required=false) String path, @RequestParam(value="encoding", defaultValue="utf-8") String encoding, @RequestParam(value="fieldDelimiter", defaultValue=",") String fieldDelimiter, @RequestParam(value="hasHeader", defaultValue="false") Boolean hasHeader, @RequestParam(value="quote", defaultValue="\"") String quote, @RequestParam(value="escapeQuotes", defaultValue="false") Boolean escapeQuotes) throws Exception {
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw WorkspaceExceptionManager.createException(80004, path);
        }
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("formate " + path));
        LoggerUtils.setJobIdMDC((String)("formateThread_" + userName));
        this.LOGGER.info("userName {} start to formate File {}", (Object)userName, (Object)path);
        if (!this.checkIsUsersDirectory(path, userName)) {
            throw WorkspaceExceptionManager.createException(80010, userName, path);
        }
        String suffix = path.substring(path.lastIndexOf("."));
        FsPath fsPath = new FsPath(path);
        HashMap<String, Object> res = new HashMap<String, Object>();
        FileSystem fileSystem = this.fsService.getFileSystemForRead(userName, fsPath);
        try (InputStream in = fileSystem.read(fsPath);){
            if (".xlsx".equalsIgnoreCase(suffix) || ".xls".equalsIgnoreCase(suffix)) {
                List info = ExcelStorageReader.getExcelTitle((InputStream)in, null, (Boolean)hasHeader, (String)suffix);
                res.put("columnName", info.get(1));
                res.put("columnType", info.get(2));
                res.put("sheetName", info.get(0));
            } else {
                String[][] column = null;
                BOMInputStream bomIn = new BOMInputStream(in, false);
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)bomIn, encoding));
                String header = reader.readLine();
                if (StringUtils.isEmpty((CharSequence)header)) {
                    throw WorkspaceExceptionManager.createException(80016, new Object[0]);
                }
                String[] line = header.split(fieldDelimiter, -1);
                int colNum = line.length;
                column = new String[2][colNum];
                if (hasHeader.booleanValue()) {
                    for (int i = 0; i < colNum; ++i) {
                        column[0][i] = line[i];
                        if (escapeQuotes.booleanValue()) {
                            try {
                                column[0][i] = column[0][i].substring(1, column[0][i].length() - 1);
                            }
                            catch (StringIndexOutOfBoundsException e) {
                                throw WorkspaceExceptionManager.createException(80017, new Object[0]);
                            }
                        }
                        column[1][i] = "string";
                    }
                } else {
                    for (int i = 0; i < colNum; ++i) {
                        column[0][i] = "col_" + (i + 1);
                        column[1][i] = "string";
                    }
                }
                res.put("columnName", column[0]);
                res.put("columnType", column[1]);
                this.LOGGER.info("userName {} Finished to formate File {}", (Object)userName, (Object)path);
                LoggerUtils.removeJobIdMDC();
            }
            Message message = Message.ok().data("formate", res);
            return message;
        }
    }

    @ApiOperation(value="getSheetInfo", notes="getSheetInfo", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="path", required=false, dataType="String", value="Path"), @ApiImplicitParam(name="encoding", required=true, dataType="String", defaultValue="utf-8"), @ApiImplicitParam(name="fieldDelimiter", required=true, dataType="String", defaultValue=","), @ApiImplicitParam(name="hasHeader", required=true, defaultValue="false", dataType="Boolean"), @ApiImplicitParam(name="quote", required=true, dataType="String", defaultValue="\""), @ApiImplicitParam(name="escapeQuotes", required=true, dataType="Boolean", defaultValue="false")})
    @RequestMapping(path={"getSheetInfo"}, method={RequestMethod.GET})
    public Message getSheetInfo(HttpServletRequest req, @RequestParam(value="path", required=false) String path, @RequestParam(value="encoding", defaultValue="utf-8") String encoding, @RequestParam(value="fieldDelimiter", defaultValue=",") String fieldDelimiter, @RequestParam(value="hasHeader", defaultValue="false") Boolean hasHeader, @RequestParam(value="quote", defaultValue="\"") String quote, @RequestParam(value="escapeQuotes", defaultValue="false") Boolean escapeQuotes) throws Exception {
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw WorkspaceExceptionManager.createException(80004, path);
        }
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("getSheetInfo " + path));
        LoggerUtils.setJobIdMDC((String)("getSheetInfoThread_" + userName));
        this.LOGGER.info("userName {} start to getSheetInfo File {}", (Object)userName, (Object)path);
        if (!this.checkIsUsersDirectory(path, userName)) {
            throw WorkspaceExceptionManager.createException(80010, userName, path);
        }
        String suffix = path.substring(path.lastIndexOf("."));
        FsPath fsPath = new FsPath(path);
        FileSystem fileSystem = this.fsService.getFileSystemForRead(userName, fsPath);
        try (InputStream in = fileSystem.read(fsPath);){
            HashMap sheetInfo;
            if (".xlsx".equalsIgnoreCase(suffix)) {
                sheetInfo = XlsxUtils.getAllSheetInfo((InputStream)in, null, (Boolean)hasHeader);
            } else if (".xls".equalsIgnoreCase(suffix)) {
                sheetInfo = XlsUtils.getSheetsInfo((InputStream)in, (Boolean)hasHeader);
            } else if (".csv".equalsIgnoreCase(suffix)) {
                ArrayList csvMapList = new ArrayList();
                String[][] column = null;
                BOMInputStream bomIn = new BOMInputStream(in, false);
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)bomIn, encoding));
                String header = reader.readLine();
                if (StringUtils.isEmpty((CharSequence)header)) {
                    throw WorkspaceExceptionManager.createException(80016, new Object[0]);
                }
                String[] line = header.split(fieldDelimiter, -1);
                int colNum = line.length;
                column = new String[2][colNum];
                if (hasHeader.booleanValue()) {
                    for (int i = 0; i < colNum; ++i) {
                        HashMap<String, String> csvMap = new HashMap<String, String>();
                        column[0][i] = line[i];
                        if (escapeQuotes.booleanValue()) {
                            try {
                                csvMap.put(column[0][i].substring(1, column[0][i].length() - 1), "string");
                            }
                            catch (StringIndexOutOfBoundsException e) {
                                throw WorkspaceExceptionManager.createException(80017, new Object[0]);
                            }
                        } else {
                            csvMap.put(column[0][i], "string");
                        }
                        csvMapList.add(csvMap);
                    }
                } else {
                    for (int i = 0; i < colNum; ++i) {
                        HashMap<String, String> csvMap = new HashMap<String, String>();
                        csvMap.put("col_" + (i + 1), "string");
                        csvMapList.add(csvMap);
                    }
                }
                sheetInfo = new HashMap(1);
                sheetInfo.put("sheet_csv", csvMapList);
                this.LOGGER.info("userName {} Finished to getSheetInfo File {}", (Object)userName, (Object)path);
                LoggerUtils.removeJobIdMDC();
            } else {
                LoggerUtils.removeJobIdMDC();
                throw WorkspaceExceptionManager.createException(80004, path);
            }
            Message message = Message.ok().data("sheetInfo", (Object)sheetInfo);
            return message;
        }
    }

    @ApiOperation(value="openLog", notes="open log", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="path", required=false, dataType="String", value="path"), @ApiImplicitParam(name="proxyUser", dataType="String")})
    @RequestMapping(path={"/openLog"}, method={RequestMethod.GET})
    public Message openLog(HttpServletRequest req, @RequestParam(value="path", required=false) String path, @RequestParam(value="proxyUser", required=false) String proxyUser) throws IOException, WorkSpaceException {
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw WorkspaceExceptionManager.createException(80004, path);
        }
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("openLog " + path));
        LoggerUtils.setJobIdMDC((String)("openLogThread_" + userName));
        this.LOGGER.info("userName {} start to openLog File {}", (Object)userName, (Object)path);
        if (proxyUser != null && Configuration.isJobHistoryAdmin((String)userName)) {
            userName = proxyUser;
        }
        if (!this.checkIsUsersDirectory(path, userName)) {
            throw WorkspaceExceptionManager.createException(80010, userName, path);
        }
        FsPath fsPath = new FsPath(path);
        FileSystem fileSystem = this.fsService.getFileSystemForRead(userName, fsPath);
        if (!fileSystem.canRead(fsPath)) {
            throw WorkspaceExceptionManager.createException(80018, new Object[0]);
        }
        if (fileSystem.getLength(fsPath) > ByteTimeUtils.byteStringAsBytes((String)((String)WorkSpaceConfiguration.FILESYSTEM_FILE_CHECK_SIZE.getValue()))) {
            throw WorkspaceExceptionManager.createException(80033, path);
        }
        try (FileSource fileSource = FileSource$.MODULE$.create(fsPath, (Fs)fileSystem).addParams("ifMerge", "false");){
            Pair collect = fileSource.collect()[0];
            StringBuilder[] log = (StringBuilder[])Arrays.stream(new StringBuilder[4]).map(f -> new StringBuilder()).toArray(StringBuilder[]::new);
            ArrayList snd = (ArrayList)collect.getSecond();
            LogLevel start = new LogLevel(LogLevel.Type.ALL);
            snd.stream().map(f -> f[0]).forEach(s -> WorkspaceUtil.logMatch(s, start).forEach(i -> log[i].append((String)s).append("\n")));
            this.LOGGER.info("userName {} Finished to openLog File {}", (Object)userName, (Object)path);
            LoggerUtils.removeJobIdMDC();
            Message message = Message.ok().data("log", Arrays.stream(log).map(StringBuilder::toString).toArray(String[]::new));
            return message;
        }
    }

    private static void deleteAllFiles(FileSystem fileSystem, FsPath fsPath) throws IOException {
        fileSystem.delete(fsPath);
        List list = null;
        if (fileSystem.exists(fsPath)) {
            list = fileSystem.list(fsPath);
        }
        if (list == null) {
            return;
        }
        for (FsPath path : list) {
            FsRestfulApi.deleteAllFiles(fileSystem, path);
        }
        fileSystem.delete(fsPath);
    }

    @ApiOperation(value="chmod", notes="file permission chmod", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="filepath", required=true, dataType="String", value="filepath"), @ApiImplicitParam(name="isRecursion", required=false, dataType="String", value="isRecursion"), @ApiImplicitParam(name="filePermission", required=true, dataType="String", value="filePermission")})
    @RequestMapping(path={"/chmod"}, method={RequestMethod.GET})
    public Message chmod(HttpServletRequest req, @RequestParam(value="filepath", required=true) String filePath, @RequestParam(value="isRecursion", required=false, defaultValue="true") Boolean isRecursion, @RequestParam(value="filePermission", required=true) String filePermission) throws WorkSpaceException, IOException {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("chmod " + filePath));
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            return Message.error((String)MessageFormat.format("Parameter {0} cannot be empty \uff08\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a {0}\uff09", filePath));
        }
        if (StringUtils.isEmpty((CharSequence)filePermission)) {
            return Message.error((String)MessageFormat.format("Parameter {0} cannot be empty \uff08\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a {0}\uff09", filePermission));
        }
        if (!filePath.startsWith("file://") && !filePath.startsWith("hdfs://")) {
            filePath = "file://" + filePath;
        }
        if (!this.checkIsUsersDirectory(filePath, userName, false)) {
            return Message.error((String)MessageFormat.format("File path illegality : {0} \uff08\u6587\u4ef6\u8def\u5f84\u9519\u8bef : {0}\uff09", filePath));
        }
        if (FsRestfulApi.checkFilePermissions(filePermission)) {
            FileSystem fileSystem = this.fsService.getFileSystem(userName, new FsPath(filePath));
            Stack<FsPath> dirsToChmod = new Stack<FsPath>();
            dirsToChmod.push(new FsPath(filePath));
            if (isRecursion.booleanValue()) {
                FsRestfulApi.traverseFolder(new FsPath(filePath), fileSystem, dirsToChmod);
            }
            while (!dirsToChmod.empty()) {
                fileSystem.setPermission((FsPath)dirsToChmod.pop(), filePermission);
            }
            return Message.ok();
        }
        return Message.error((String)MessageFormat.format("File permissions prohibit modification of unreadable files: {0}  \uff08\u6587\u4ef6\u6743\u9650\u7981\u6b62\u4fee\u6539\u4e0d\u53ef\u8bfb: {0}\uff09", filePermission));
    }

    @ApiOperation(value="encrypt-path", notes="encrypt file path", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="filePath", required=true, dataType="String", value="Path")})
    @RequestMapping(path={"/encrypt-path"}, method={RequestMethod.GET})
    public Message encryptPath(HttpServletRequest req, @RequestParam(value="filePath", required=false) String filePath) throws WorkSpaceException, IOException {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("encrypt-path " + filePath));
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            return Message.error((String)MessageFormat.format("Parameter {0} cannot be empty \uff08\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a {0}\uff09", "restultPath"));
        }
        if (!WorkspaceUtil.filePathRegexPattern.matcher(filePath).find()) {
            return Message.error((String)MessageFormat.format("File path illegal symbols : {0} \uff08\u6587\u4ef6\u8def\u5f84\u7ed3\u679c\u96c6\u8def\u5f84\u5305\u542b\u975e\u6cd5\u5b57\u7b26 : {0}\uff09", filePath));
        }
        FileSystem fs = this.fsService.getFileSystem(username, new FsPath(filePath));
        String fileMD5Str = fs.checkSum(new FsPath(filePath));
        return Message.ok().data("data", (Object)fileMD5Str);
    }

    @ApiOperation(value="Python\u6a21\u5757\u4e0a\u4f20", notes="\u4e0a\u4f20Python\u6a21\u5757\u6587\u4ef6\u5e76\u8fd4\u56de\u6587\u4ef6\u5730\u5740", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="file", required=true, dataType="MultipartFile", value="\u4e0a\u4f20\u7684\u6587\u4ef6"), @ApiImplicitParam(name="fileName", required=true, dataType="String", value="\u6587\u4ef6\u540d\u79f0")})
    @RequestMapping(path={"/python-upload"}, method={RequestMethod.POST})
    public Message pythonUpload(HttpServletRequest req, @RequestParam(value="file") MultipartFile file, @RequestParam(value="fileName", required=false) String fileName) throws WorkSpaceException, IOException {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"pythonUpload");
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return Message.error((String)"\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String fileNameSuffix = fileName.substring(0, fileName.lastIndexOf("."));
        if (!fileNameSuffix.matches("^[a-zA-Z][a-zA-Z0-9_]{0,49}$")) {
            return Message.error((String)"\u6a21\u5757\u540d\u79f0\u9519\u8bef\uff0c\u4ec5\u652f\u6301\u6570\u5b57\u5b57\u6bcd\u4e0b\u5212\u7ebf\uff0c\u4e14\u4ee5\u5b57\u6bcd\u5f00\u5934\uff0c\u957f\u5ea6\u6700\u592750");
        }
        if (!file.getOriginalFilename().endsWith(".py") && !file.getOriginalFilename().endsWith(".zip")) {
            return Message.error((String)"\u4ec5\u652f\u6301.py\u548c.zip\u683c\u5f0f\u6a21\u5757\u6587\u4ef6");
        }
        if (file.getSize() > 0x3200000L) {
            return Message.error((String)"\u9650\u5236\u6700\u5927\u5355\u4e2a\u6587\u4ef650M");
        }
        String path = "hdfs:///appcom/linkis/udf/" + username;
        FsPath fsPath = new FsPath(path);
        FileSystem fileSystem = this.fsService.getFileSystem(username, fsPath);
        if (!fileSystem.exists(fsPath)) {
            try {
                fileSystem.mkdirs(fsPath);
                fileSystem.setPermission(fsPath, "770");
            }
            catch (IOException e) {
                return Message.error((String)("\u521b\u5efa\u76ee\u5f55\u5931\u8d25\uff1a" + e.getMessage()));
            }
        }
        String newPath = fsPath.getPath() + "/" + file.getOriginalFilename();
        FsPath fsPathNew = new FsPath(newPath);
        try (InputStream is = file.getInputStream();
             OutputStream outputStream = fileSystem.write(fsPathNew, true);){
            IOUtils.copy((InputStream)is, (OutputStream)outputStream);
        }
        catch (IOException e) {
            return Message.error((String)("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a" + e.getMessage()));
        }
        return Message.ok().data("filePath", (Object)newPath);
    }

    private static boolean checkFilePermissions(String filePermission) {
        char[] ps;
        int ownerPermissions;
        boolean result = false;
        if (StringUtils.isNumeric((CharSequence)filePermission) && (ownerPermissions = Integer.parseInt(String.valueOf((ps = filePermission.toCharArray())[0]))) >= 4) {
            result = true;
        }
        return result;
    }

    private static void traverseFolder(FsPath fsPath, FileSystem fileSystem, Stack<FsPath> dirsToChmod) throws IOException {
        List list = fileSystem.list(fsPath);
        if (list == null) {
            return;
        }
        for (FsPath path : list) {
            if (path.isdir()) {
                FsRestfulApi.traverseFolder(path, fileSystem, dirsToChmod);
            }
            dirsToChmod.push(path);
        }
    }
}

