/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.common.entity.resource;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.text.MessageFormat;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.linkis.manager.common.entity.resource.Resource;
import org.apache.linkis.manager.common.errorcode.ManagerCommonErrorCodeSummary;
import org.apache.linkis.manager.common.exception.ResourceWarnException;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SpecialResource
extends Resource {
    private final Map<String, Object> resources;

    public SpecialResource(Map<String, Object> resources) {
        this.resources = resources;
    }

    public Map<String, Object> getResources() {
        return this.resources;
    }

    private SpecialResource specialResourceOperator(Resource r, BiFunction<Object, Object, Object> op) {
        if (r instanceof SpecialResource) {
            Map<String, Object> rs = ((SpecialResource)r).resources;
            Map<String, Object> resource = this.resources.entrySet().stream().map(entry -> {
                Object v1 = rs.get(entry.getKey());
                return new AbstractMap.SimpleEntry(entry.getKey(), op.apply(entry.getValue(), v1));
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return new SpecialResource(resource);
        }
        return new SpecialResource(new HashMap<String, Object>());
    }

    @Override
    public Resource add(Resource r) {
        return this.specialResourceOperator(r, (v1, v2) -> {
            if (v1 instanceof Integer) {
                return (Integer)v1 + (Integer)v2;
            }
            if (v1 instanceof Double) {
                return (Double)v1 + (Double)v2;
            }
            if (v1 instanceof Long) {
                return (Long)v1 + (Long)v2;
            }
            if (v1 instanceof Float) {
                return Float.valueOf(((Float)v1).floatValue() + ((Float)v2).floatValue());
            }
            if (v1 instanceof Short) {
                return (Short)v1 + (Short)v2;
            }
            throw new ResourceWarnException(ManagerCommonErrorCodeSummary.NOT_RESOURCE_TYPE.getErrorCode(), MessageFormat.format(ManagerCommonErrorCodeSummary.NOT_RESOURCE_TYPE.getErrorDesc(), r.getClass()));
        });
    }

    @Override
    public Resource minus(Resource r) {
        return this.specialResourceOperator(r, (v1, v2) -> {
            if (v1 instanceof Integer) {
                return (Integer)v1 - (Integer)v2;
            }
            if (v1 instanceof Double) {
                return (Double)v1 - (Double)v2;
            }
            if (v1 instanceof Long) {
                return (Long)v1 - (Long)v2;
            }
            if (v1 instanceof Float) {
                return Float.valueOf(((Float)v1).floatValue() - ((Float)v2).floatValue());
            }
            if (v1 instanceof Short) {
                return (Short)v1 - (Short)v2;
            }
            throw new ResourceWarnException(ManagerCommonErrorCodeSummary.NOT_RESOURCE_TYPE.getErrorCode(), MessageFormat.format(ManagerCommonErrorCodeSummary.NOT_RESOURCE_TYPE.getErrorDesc(), r.getClass()));
        });
    }

    @Override
    public Resource multiplied(Resource r) {
        return this.specialResourceOperator(r, (v1, v2) -> {
            if (v1 instanceof Integer) {
                return (Integer)v1 * (Integer)v2;
            }
            if (v1 instanceof Double) {
                return (Double)v1 * (Double)v2;
            }
            if (v1 instanceof Long) {
                return (Long)v1 * (Long)v2;
            }
            if (v1 instanceof Float) {
                return Float.valueOf(((Float)v1).floatValue() * ((Float)v2).floatValue());
            }
            if (v1 instanceof Short) {
                return (Short)v1 * (Short)v2;
            }
            throw new ResourceWarnException(ManagerCommonErrorCodeSummary.NOT_RESOURCE_TYPE.getErrorCode(), MessageFormat.format(ManagerCommonErrorCodeSummary.NOT_RESOURCE_TYPE.getErrorDesc(), r.getClass()));
        });
    }

    @Override
    public Resource multiplied(float rate) {
        Map<String, Object> resourceMap = this.resources.entrySet().stream().map(entry -> {
            Object v = entry.getValue();
            if (v instanceof Integer) {
                return new AbstractMap.SimpleEntry(entry.getKey(), (int)((float)((Integer)v).intValue() * rate));
            }
            if (v instanceof Double) {
                return new AbstractMap.SimpleEntry(entry.getKey(), (Double)v * (double)rate);
            }
            if (v instanceof Long) {
                return new AbstractMap.SimpleEntry(entry.getKey(), (long)((float)((Long)v).longValue() * rate));
            }
            if (v instanceof Float) {
                return new AbstractMap.SimpleEntry(entry.getKey(), Float.valueOf(((Float)v).floatValue() * rate));
            }
            if (v instanceof Short) {
                return new AbstractMap.SimpleEntry(entry.getKey(), (short)((float)((Short)v).shortValue() * rate));
            }
            throw new ResourceWarnException(ManagerCommonErrorCodeSummary.NOT_RESOURCE_TYPE.getErrorCode(), MessageFormat.format(ManagerCommonErrorCodeSummary.NOT_RESOURCE_TYPE.getErrorDesc(), v.getClass()));
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new SpecialResource(resourceMap);
    }

    @Override
    public Resource divide(Resource r) {
        return this.specialResourceOperator(r, (v1, v2) -> {
            if (v1 instanceof Integer) {
                return (Integer)v1 / (Integer)v2;
            }
            if (v1 instanceof Double) {
                return (Double)v1 / (Double)v2;
            }
            if (v1 instanceof Long) {
                return (Long)v1 / (Long)v2;
            }
            if (v1 instanceof Float) {
                return Float.valueOf(((Float)v1).floatValue() / ((Float)v2).floatValue());
            }
            if (v1 instanceof Short) {
                return (Short)v1 / (Short)v2;
            }
            throw new ResourceWarnException(ManagerCommonErrorCodeSummary.NOT_RESOURCE_TYPE.getErrorCode(), MessageFormat.format(ManagerCommonErrorCodeSummary.NOT_RESOURCE_TYPE.getErrorDesc(), r.getClass()));
        });
    }

    @Override
    public Resource divide(int rate) {
        Map<String, Object> map = this.resources.entrySet().stream().map(entry -> {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Integer) {
                int i = (Integer)value;
                return new AbstractMap.SimpleEntry<String, Integer>(key, i / rate);
            }
            if (value instanceof Double) {
                double d = (Double)value;
                return new AbstractMap.SimpleEntry<String, Double>(key, d / (double)rate);
            }
            if (value instanceof Long) {
                long l = (Long)value;
                return new AbstractMap.SimpleEntry<String, Long>(key, l / (long)rate);
            }
            if (value instanceof Float) {
                float f = ((Float)value).floatValue();
                return new AbstractMap.SimpleEntry<String, Float>(key, Float.valueOf(f / (float)rate));
            }
            if (value instanceof Short) {
                short s = (Short)value;
                return new AbstractMap.SimpleEntry<String, Short>(key, (short)(s / rate));
            }
            throw new ResourceWarnException(ManagerCommonErrorCodeSummary.NOT_RESOURCE_TYPE.getErrorCode(), MessageFormat.format(ManagerCommonErrorCodeSummary.NOT_RESOURCE_TYPE.getErrorDesc(), value.getClass()));
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new SpecialResource(map);
    }

    @Override
    public boolean moreThan(Resource r) {
        if (r instanceof SpecialResource) {
            SpecialResource s = (SpecialResource)r;
            Map<String, Object> rs = s.getResources();
            return this.resources.entrySet().stream().noneMatch(entry -> {
                Object v = entry.getValue();
                Object rsV = rs.get(entry.getKey());
                if (v instanceof Integer && rsV instanceof Integer) {
                    return (Integer)v <= (Integer)rsV;
                }
                if (v instanceof Double && rsV instanceof Double) {
                    return (Double)v <= (Double)rsV;
                }
                if (v instanceof Long && rsV instanceof Long) {
                    return (Long)v <= (Long)rsV;
                }
                if (v instanceof Float && rsV instanceof Float) {
                    return ((Float)v).floatValue() <= ((Float)rsV).floatValue();
                }
                if (v instanceof Short && rsV instanceof Short) {
                    return (Short)v <= (Short)rsV;
                }
                throw new ResourceWarnException(ManagerCommonErrorCodeSummary.NOT_RESOURCE_TYPE.getErrorCode(), MessageFormat.format(ManagerCommonErrorCodeSummary.NOT_RESOURCE_TYPE.getErrorDesc(), v.getClass()));
            });
        }
        return true;
    }

    @Override
    public boolean caseMore(Resource r) {
        if (r instanceof SpecialResource) {
            SpecialResource s = (SpecialResource)r;
            Map<String, Object> rs = s.getResources();
            return this.resources.entrySet().stream().anyMatch(entry -> {
                Object v = entry.getValue();
                Object rsV = rs.get(entry.getKey());
                if (v instanceof Integer && rsV instanceof Integer) {
                    return (Integer)v > (Integer)rsV;
                }
                if (v instanceof Double && rsV instanceof Double) {
                    return (Double)v > (Double)rsV;
                }
                if (v instanceof Long && rsV instanceof Long) {
                    return (Long)v > (Long)rsV;
                }
                if (v instanceof Float && rsV instanceof Float) {
                    return ((Float)v).floatValue() > ((Float)rsV).floatValue();
                }
                if (v instanceof Short && rsV instanceof Short) {
                    return (Short)v > (Short)rsV;
                }
                throw new ResourceWarnException(ManagerCommonErrorCodeSummary.NOT_RESOURCE_TYPE.getErrorCode(), MessageFormat.format(ManagerCommonErrorCodeSummary.NOT_RESOURCE_TYPE.getErrorDesc(), v.getClass()));
            });
        }
        return true;
    }

    @Override
    public boolean equalsTo(Resource r) {
        if (r instanceof SpecialResource) {
            SpecialResource s = (SpecialResource)r;
            Map<String, Object> rs = s.getResources();
            return this.resources.entrySet().stream().noneMatch(entry -> {
                Object v = entry.getValue();
                Object rsV = rs.get(entry.getKey());
                if (v instanceof Integer && rsV instanceof Integer) {
                    return ((Integer)v).intValue() != ((Integer)rsV).intValue();
                }
                if (v instanceof Double && rsV instanceof Double) {
                    return ((Double)v).doubleValue() != ((Double)rsV).doubleValue();
                }
                if (v instanceof Long && rsV instanceof Long) {
                    return ((Long)v).longValue() != ((Long)rsV).longValue();
                }
                if (v instanceof Float && rsV instanceof Float) {
                    return ((Float)v).floatValue() != ((Float)rsV).floatValue();
                }
                if (v instanceof Short && rsV instanceof Short) {
                    return ((Short)v).shortValue() != ((Short)rsV).shortValue();
                }
                throw new ResourceWarnException(ManagerCommonErrorCodeSummary.NOT_RESOURCE_TYPE.getErrorCode(), MessageFormat.format(ManagerCommonErrorCodeSummary.NOT_RESOURCE_TYPE.getErrorDesc(), v.getClass()));
            });
        }
        return true;
    }

    @Override
    public boolean notLess(Resource r) {
        if (r instanceof SpecialResource) {
            SpecialResource s = (SpecialResource)r;
            Map<String, Object> rs = s.getResources();
            return this.resources.entrySet().stream().noneMatch(entry -> {
                Object v = entry.getValue();
                Object rsV = rs.get(entry.getKey());
                if (v instanceof Integer && rsV instanceof Integer) {
                    return (Integer)v < (Integer)rsV;
                }
                if (v instanceof Double && rsV instanceof Double) {
                    return (Double)v < (Double)rsV;
                }
                if (v instanceof Long && rsV instanceof Long) {
                    return (Long)v < (Long)rsV;
                }
                if (v instanceof Float && rsV instanceof Float) {
                    return ((Float)v).floatValue() < ((Float)rsV).floatValue();
                }
                if (v instanceof Short && rsV instanceof Short) {
                    return (Short)v < (Short)rsV;
                }
                throw new ResourceWarnException(ManagerCommonErrorCodeSummary.NOT_RESOURCE_TYPE.getErrorCode(), MessageFormat.format(ManagerCommonErrorCodeSummary.NOT_RESOURCE_TYPE.getErrorDesc(), v.getClass()));
            });
        }
        return true;
    }

    @Override
    public boolean less(Resource r) {
        return !this.notLess(r);
    }

    @Override
    public int compare(Resource r) {
        if (this.moreThan(r)) {
            return 1;
        }
        if (this.less(r)) {
            return -1;
        }
        return 0;
    }

    @Override
    public String toJson() {
        return String.format("Special:%s", this.resources);
    }
}

