/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;

public class FilterProjectTransposeRule
extends RelOptRule {
    public static final FilterProjectTransposeRule INSTANCE = new FilterProjectTransposeRule(Filter.class, Project.class, true, true, RelFactories.LOGICAL_BUILDER);
    private final boolean copyFilter;
    private final boolean copyProject;

    public FilterProjectTransposeRule(Class<? extends Filter> filterClass, Class<? extends Project> projectClass, boolean copyFilter, boolean copyProject, RelBuilderFactory relBuilderFactory) {
        this(FilterProjectTransposeRule.operand(filterClass, FilterProjectTransposeRule.operand(projectClass, FilterProjectTransposeRule.any()), new RelOptRuleOperand[0]), copyFilter, copyProject, relBuilderFactory);
    }

    @Deprecated
    public FilterProjectTransposeRule(Class<? extends Filter> filterClass, RelFactories.FilterFactory filterFactory, Class<? extends Project> projectClass, RelFactories.ProjectFactory projectFactory) {
        this(filterClass, projectClass, filterFactory == null, projectFactory == null, RelBuilder.proto(filterFactory, projectFactory));
    }

    protected FilterProjectTransposeRule(RelOptRuleOperand operand, boolean copyFilter, boolean copyProject, RelBuilderFactory relBuilderFactory) {
        super(operand, relBuilderFactory, null);
        this.copyFilter = copyFilter;
        this.copyProject = copyProject;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        Project project = (Project)call.rel(1);
        if (RexOver.containsOver(project.getProjects(), null)) {
            return;
        }
        if (RexUtil.containsCorrelation(filter.getCondition())) {
            return;
        }
        RexNode newCondition = RelOptUtil.pushPastProject(filter.getCondition(), project);
        RelBuilder relBuilder = call.builder();
        RelNode newFilterRel = this.copyFilter ? filter.copy(filter.getTraitSet(), project.getInput(), RexUtil.removeNullabilityCast(relBuilder.getTypeFactory(), newCondition)) : relBuilder.push(project.getInput()).filter(newCondition).build();
        RelNode newProjRel = this.copyProject ? project.copy(project.getTraitSet(), newFilterRel, project.getProjects(), project.getRowType()) : relBuilder.push(newFilterRel).project(project.getProjects(), project.getRowType().getFieldNames()).build();
        call.transformTo(newProjRel);
    }
}

