/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.entrance.execute;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.linkis.common.log.LogUtils$;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.entrance.exception.EntranceErrorCode;
import org.apache.linkis.entrance.exception.EntranceErrorException;
import org.apache.linkis.entrance.execute.EngineExecuteAsyncReturn;
import org.apache.linkis.entrance.execute.EntranceExecutor;
import org.apache.linkis.entrance.execute.EntranceJob;
import org.apache.linkis.entrance.job.EntranceExecuteRequest;
import org.apache.linkis.entrance.orchestrator.EntranceOrchestrationFactory$;
import org.apache.linkis.entrance.utils.JobHistoryHelper$;
import org.apache.linkis.governance.common.entity.ExecutionNodeStatus;
import org.apache.linkis.governance.common.protocol.task.ResponseTaskStatus;
import org.apache.linkis.governance.common.utils.LoggerUtils;
import org.apache.linkis.manager.label.entity.engine.CodeLanguageLabel;
import org.apache.linkis.manager.label.utils.LabelUtil$;
import org.apache.linkis.orchestrator.Orchestration;
import org.apache.linkis.orchestrator.computation.entity.ComputationJobReq;
import org.apache.linkis.orchestrator.computation.entity.ComputationJobReq$;
import org.apache.linkis.orchestrator.computation.operation.log.LogEvent;
import org.apache.linkis.orchestrator.computation.operation.log.LogOperation$;
import org.apache.linkis.orchestrator.computation.operation.log.LogProcessor;
import org.apache.linkis.orchestrator.computation.operation.progress.DefaultProgressOperation$;
import org.apache.linkis.orchestrator.computation.operation.progress.ProgressInfoEvent;
import org.apache.linkis.orchestrator.computation.operation.progress.ProgressProcessor;
import org.apache.linkis.orchestrator.core.OrchestrationFuture;
import org.apache.linkis.orchestrator.core.OrchestrationResponse;
import org.apache.linkis.orchestrator.core.ResultSet;
import org.apache.linkis.orchestrator.domain.JobReq;
import org.apache.linkis.orchestrator.execution.ArrayResultSetTaskResponse;
import org.apache.linkis.orchestrator.execution.FailedTaskResponse;
import org.apache.linkis.orchestrator.execution.ResultSetTaskResponse;
import org.apache.linkis.orchestrator.execution.SucceedTaskResponse;
import org.apache.linkis.orchestrator.execution.impl.DefaultFailedTaskResponse;
import org.apache.linkis.orchestrator.plans.unit.CodeLogicalUnit;
import org.apache.linkis.scheduler.executer.AliasOutputExecuteResponse;
import org.apache.linkis.scheduler.executer.ErrorExecuteResponse;
import org.apache.linkis.scheduler.executer.ExecuteRequest;
import org.apache.linkis.scheduler.executer.ExecuteResponse;
import org.apache.linkis.scheduler.executer.OutputExecuteResponse;
import org.apache.linkis.scheduler.executer.SingleTaskOperateSupport;
import org.apache.linkis.scheduler.queue.Job;
import org.apache.linkis.server.BDPJettyServerHelper$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001B\b\u0011\u0001mA\u0011\u0002\r\u0001\u0003\u0002\u0003\u0006I!M\u001c\t\u000ba\u0002A\u0011A\u001d\t\u000bq\u0002A\u0011A\u001f\t\u000b]\u0003A\u0011\u0001-\t\u000b\t\u0004A\u0011A2\t\u000be\u0004A\u0011\u0001>\t\u000f\u0005\u0015\u0001\u0001\"\u0011\u0002\b!9\u0011\u0011\u0002\u0001\u0005\n\u0005-\u0001bBA\b\u0001\u0011%\u0011\u0011\u0003\u0005\b\u0003O\u0001A\u0011IA\u0015\u0011\u001d\t\t\u0004\u0001C!\u0003SAq!a\r\u0001\t\u0003\nI\u0003C\u0004\u00026\u0001!\t!a\u000e\t\u000f\u0005}\u0002\u0001\"\u0015\u0002B\t9B)\u001a4bk2$XI\u001c;sC:\u001cW-\u0012=fGV$xN\u001d\u0006\u0003#I\tq!\u001a=fGV$XM\u0003\u0002\u0014)\u0005AQM\u001c;sC:\u001cWM\u0003\u0002\u0016-\u00051A.\u001b8lSNT!a\u0006\r\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0012aA8sO\u000e\u00011\u0003\u0002\u0001\u001dA!\u0002\"!\b\u0010\u000e\u0003AI!a\b\t\u0003!\u0015sGO]1oG\u0016,\u00050Z2vi>\u0014\bCA\u0011'\u001b\u0005\u0011#BA\u0012%\u0003!)\u00070Z2vi\u0016\u0014(BA\u0013\u0015\u0003%\u00198\r[3ek2,'/\u0003\u0002(E\tA2+\u001b8hY\u0016$\u0016m]6Pa\u0016\u0014\u0018\r^3TkB\u0004xN\u001d;\u0011\u0005%rS\"\u0001\u0016\u000b\u0005-b\u0013!B;uS2\u001c(BA\u0017\u0015\u0003\u0019\u0019w.\\7p]&\u0011qF\u000b\u0002\b\u0019><w-\u001b8h\u0003\tIG\r\u0005\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14G\u0001\u0003M_:<\u0017B\u0001\u0019\u001f\u0003\u0019a\u0014N\\5u}Q\u0011!h\u000f\t\u0003;\u0001AQ\u0001\r\u0002A\u0002E\nq\u0001Z3bY2{w\rF\u0002?\u0015J\u0003\"a\u0010%\u000e\u0003\u0001S!!\u0011\"\u0002\u00071|wM\u0003\u0002D\t\u0006Iq\u000e]3sCRLwN\u001c\u0006\u0003\u000b\u001a\u000b1bY8naV$\u0018\r^5p]*\u0011q\tF\u0001\r_J\u001c\u0007.Z:ue\u0006$xN]\u0005\u0003\u0013\u0002\u0013A\u0002T8h!J|7-Z:t_JDQaS\u0002A\u00021\u000b!c\u001c:dQ\u0016\u001cHO]1u_J4U\u000f^;sKB\u0011Q\nU\u0007\u0002\u001d*\u0011qJR\u0001\u0005G>\u0014X-\u0003\u0002R\u001d\n\u0019rJ]2iKN$(/\u0019;j_:4U\u000f^;sK\")1k\u0001a\u0001)\u0006\u0019!n\u001c2\u0011\u0005u)\u0016B\u0001,\u0011\u0005-)e\u000e\u001e:b]\u000e,'j\u001c2\u00021\u0011,\u0017\r\u001c)s_\u001e\u0014Xm]:XSRD'+Z:pkJ\u001cW\rF\u0002Z?\u0002\u0004\"AW/\u000e\u0003mS!\u0001\u0018\"\u0002\u0011A\u0014xn\u001a:fgNL!AX.\u0003#A\u0013xn\u001a:fgN\u0004&o\\2fgN|'\u000fC\u0003L\t\u0001\u0007A\nC\u0003b\t\u0001\u0007A+A\u0006f]R\u0014\u0018M\\2f\u0015>\u0014\u0017\u0001\u00043fC2\u0014Vm\u001d9p]N,G\u0003\u00023hYN\u0004\"AM3\n\u0005\u0019\u001c$\u0001B+oSRDQ\u0001[\u0003A\u0002%\fQc\u001c:dQ\u0016\u001cHO]1uS>t'+Z:q_:\u001cX\r\u0005\u0002NU&\u00111N\u0014\u0002\u0016\u001fJ\u001c\u0007.Z:ue\u0006$\u0018n\u001c8SKN\u0004xN\\:f\u0011\u0015iW\u00011\u0001o\u0003Y)g\u000e\u001e:b]\u000e,W\t_3dkR,'+Z9vKN$\bCA8r\u001b\u0005\u0001(BA*\u0013\u0013\t\u0011\bO\u0001\fF]R\u0014\u0018M\\2f\u000bb,7-\u001e;f%\u0016\fX/Z:u\u0011\u0015!X\u00011\u0001v\u00035y'o\u00195fgR\u0014\u0018\r^5p]B\u0011ao^\u0007\u0002\r&\u0011\u0001P\u0012\u0002\u000e\u001fJ\u001c\u0007.Z:ue\u0006$\u0018n\u001c8\u00025I,\u0017/^3tiR{7i\\7qkR\fG/[8o\u0015>\u0014'+Z9\u0015\u0007m\f\u0019\u0001\u0005\u0002}\u007f6\tQP\u0003\u0002\u007f\r\u00061Am\\7bS:L1!!\u0001~\u0005\u0019QuN\u0019*fc\")QN\u0002a\u0001]\u0006)1\r\\8tKR\tA-A\u0006e_>s7+^2dK\u0016$Gc\u00013\u0002\u000e!)Q\u000e\u0003a\u0001]\u0006QAm\\(o\r\u0006LG.\u001a3\u0015\u000f\u0011\f\u0019\"!\u0006\u0002\u0018!)Q.\u0003a\u0001]\")A/\u0003a\u0001k\"9\u0011\u0011D\u0005A\u0002\u0005m\u0011A\u00044bS2,GMU3ta>t7/\u001a\t\u0005\u0003;\t\u0019#\u0004\u0002\u0002 )\u0019\u0011\u0011\u0005$\u0002\u0013\u0015DXmY;uS>t\u0017\u0002BA\u0013\u0003?\u0011!CR1jY\u0016$G+Y:l%\u0016\u001c\bo\u001c8tK\u0006!1.\u001b7m)\t\tY\u0003E\u00023\u0003[I1!a\f4\u0005\u001d\u0011un\u001c7fC:\fQ\u0001]1vg\u0016\faA]3tk6,\u0017!H4fiJ+hN\\5oO>\u00138\r[3tiJ\fG/[8o\rV$XO]3\u0016\u0005\u0005e\u0002\u0003\u0002\u001a\u0002<1K1!!\u00104\u0005\u0019y\u0005\u000f^5p]\u0006Y1-\u00197m\u000bb,7-\u001e;f)\u0011\t\u0019%!\u0013\u0011\u0007\u0005\n)%C\u0002\u0002H\t\u0012q\"\u0012=fGV$XMU3ta>t7/\u001a\u0005\b\u0003\u0017r\u0001\u0019AA'\u0003\u001d\u0011X-];fgR\u00042!IA(\u0013\r\t\tF\t\u0002\u000f\u000bb,7-\u001e;f%\u0016\fX/Z:u\u0001")
public class DefaultEntranceExecutor
extends EntranceExecutor
implements SingleTaskOperateSupport {
    public LogProcessor dealLog(OrchestrationFuture orchestratorFuture, EntranceJob job) {
        LogProcessor logProcessor = (LogProcessor)orchestratorFuture.operate(LogOperation$.MODULE$.LOG());
        logProcessor.registerLogNotify((Function1 & Serializable & scala.Serializable)logEvent -> {
            DefaultEntranceExecutor.$anonfun$dealLog$1(job, logEvent);
            return BoxedUnit.UNIT;
        });
        return logProcessor;
    }

    public ProgressProcessor dealProgressWithResource(OrchestrationFuture orchestratorFuture, EntranceJob entranceJob) {
        ProgressProcessor progressProcessor = (ProgressProcessor)orchestratorFuture.operate(DefaultProgressOperation$.MODULE$.PROGRESS_NAME());
        progressProcessor.doOnObtain((Function1 & Serializable & scala.Serializable)progressInfoEvent -> {
            DefaultEntranceExecutor.$anonfun$dealProgressWithResource$1(this, entranceJob, progressInfoEvent);
            return BoxedUnit.UNIT;
        });
        return progressProcessor;
    }

    public void dealResponse(OrchestrationResponse orchestrationResponse, EntranceExecuteRequest entranceExecuteRequest, Orchestration orchestration) {
        Object object = new Object();
        try {
            LoggerUtils.setJobIdMDC((String)Long.toString(this.getId()));
            OrchestrationResponse orchestrationResponse2 = orchestrationResponse;
            if (orchestrationResponse2 instanceof SucceedTaskResponse) {
                SucceedTaskResponse succeedTaskResponse = (SucceedTaskResponse)orchestrationResponse2;
                SucceedTaskResponse succeedTaskResponse2 = succeedTaskResponse;
                if (succeedTaskResponse2 instanceof ResultSetTaskResponse) {
                    ResultSetTaskResponse resultSetTaskResponse = (ResultSetTaskResponse)succeedTaskResponse2;
                    this.logger().info(new StringBuilder(54).append("JobRequest : ").append(entranceExecuteRequest.jobId()).append(" succeed to execute task, and get result.").toString());
                    entranceExecuteRequest.getJob().getEntranceContext().getOrCreatePersistenceManager().onResultSetCreated(entranceExecuteRequest.getJob(), (OutputExecuteResponse)new AliasOutputExecuteResponse(null, resultSetTaskResponse.getResultSet()));
                } else if (succeedTaskResponse2 instanceof ArrayResultSetTaskResponse) {
                    Object object2;
                    ArrayResultSetTaskResponse arrayResultSetTaskResponse = (ArrayResultSetTaskResponse)succeedTaskResponse2;
                    this.logger().info(new StringBuilder(61).append("JobRequest :  ").append(entranceExecuteRequest.jobId()).append(" succeed to execute task, and get result array.").toString());
                    if (arrayResultSetTaskResponse.getResultSets() != null && arrayResultSetTaskResponse.getResultSets().length > 0) {
                        int resultsetSize = arrayResultSetTaskResponse.getResultSets().length;
                        entranceExecuteRequest.getJob().setResultSize(resultsetSize);
                        object2 = BoxesRunTime.boxToInteger((int)entranceExecuteRequest.getJob().addAndGetResultSize(resultsetSize));
                    } else {
                        object2 = BoxedUnit.UNIT;
                    }
                    ResultSet firstResultSet = (ResultSet)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arrayResultSetTaskResponse.getResultSets())).headOption().orNull(Predef$.MODULE$.$conforms());
                    if (firstResultSet != null) {
                        BoxedUnit cfr_ignored_0 = (BoxedUnit)Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> entranceExecuteRequest.getJob().getEntranceContext().getOrCreatePersistenceManager().onResultSetCreated(entranceExecuteRequest.getJob(), (OutputExecuteResponse)new AliasOutputExecuteResponse(firstResultSet.alias(), firstResultSet.result())), (Function1 & Serializable & scala.Serializable)x0$1 -> {
                            DefaultEntranceExecutor.$anonfun$dealResponse$2(this, entranceExecuteRequest, orchestration, object, x0$1);
                            return BoxedUnit.UNIT;
                        });
                    }
                } else {
                    this.logger().info(new StringBuilder(48).append("JobRequest : ").append(entranceExecuteRequest.jobId()).append(" succeed to execute task,no result.").toString());
                }
                entranceExecuteRequest.getJob().getLogListener().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                    x$3.onLogUpdate((Job)entranceExecuteRequest.getJob(), LogUtils$.MODULE$.generateInfo(new StringBuilder(71).append("Congratulations! Your job : ").append(entranceExecuteRequest.getJob().getId()).append(" executed with status succeed and ").append(entranceExecuteRequest.getJob().addAndGetResultSize(0)).append(" results.").toString()));
                    return BoxedUnit.UNIT;
                });
                BoxedUnit cfr_ignored_1 = (BoxedUnit)Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.doOnSucceed(entranceExecuteRequest), this.logger());
            } else if (orchestrationResponse2 instanceof FailedTaskResponse) {
                FailedTaskResponse failedTaskResponse = (FailedTaskResponse)orchestrationResponse2;
                BoxedUnit cfr_ignored_2 = (BoxedUnit)Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.doOnFailed(entranceExecuteRequest, orchestration, failedTaskResponse), this.logger());
            } else {
                String msg = new StringBuilder(51).append("Job : ").append(entranceExecuteRequest.getJob().getId()).append(" , JobRequest id: ").append(entranceExecuteRequest.jobId()).append(" returned unknown response}").toString();
                this.logger().error(msg);
                entranceExecuteRequest.getJob().getLogListener().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                    x$4.onLogUpdate((Job)entranceExecuteRequest.getJob(), LogUtils$.MODULE$.generateERROR(msg));
                    return BoxedUnit.UNIT;
                });
            }
            LoggerUtils.removeJobIdMDC();
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public JobReq requestToComputationJobReq(EntranceExecuteRequest entranceExecuteRequest) {
        ComputationJobReq.ComputationJobReqBuilder jobReqBuilder = ComputationJobReq$.MODULE$.newBuilder();
        jobReqBuilder.setId(entranceExecuteRequest.jobId());
        jobReqBuilder.setSubmitUser(entranceExecuteRequest.submitUser());
        jobReqBuilder.setExecuteUser(entranceExecuteRequest.executeUser());
        CodeLanguageLabel codeTypeLabel = LabelUtil$.MODULE$.getCodeTypeLabel(entranceExecuteRequest.getLabels());
        if (codeTypeLabel == null) {
            throw new EntranceErrorException(EntranceErrorCode.EXECUTE_REQUEST_INVALID.getErrCode(), "code Type Label is needed");
        }
        ArrayList<String> codes = new ArrayList<String>();
        codes.add(entranceExecuteRequest.code());
        CodeLogicalUnit codeLogicalUnit = new CodeLogicalUnit(codes, codeTypeLabel);
        jobReqBuilder.setCodeLogicalUnit(codeLogicalUnit);
        jobReqBuilder.setLabels(entranceExecuteRequest.getLabels());
        jobReqBuilder.setExecuteUser(entranceExecuteRequest.executeUser());
        jobReqBuilder.setParams(entranceExecuteRequest.properties());
        return jobReqBuilder.build();
    }

    public void close() {
        this.getEngineExecuteAsyncReturn().foreach((Function1 & Serializable & scala.Serializable)e -> {
            e.notifyError(new StringBuilder(40).append(this.toString()).append(" has already been completed with state ").append(this.state()).append(".").toString());
            return BoxedUnit.UNIT;
        });
    }

    private void doOnSucceed(EntranceExecuteRequest entranceExecuteRequest) {
        this.getEngineExecuteAsyncReturn().foreach((Function1 & Serializable & scala.Serializable)jobReturn -> {
            jobReturn.notifyStatus(new ResponseTaskStatus(entranceExecuteRequest.getJob().getId(), ExecutionNodeStatus.Succeed));
            return BoxedUnit.UNIT;
        });
    }

    private void doOnFailed(EntranceExecuteRequest entranceExecuteRequest, Orchestration orchestration, FailedTaskResponse failedResponse) {
        String msg = new StringBuilder(2).append(failedResponse.getErrorCode()).append(", ").append(failedResponse.getErrorMsg()).toString();
        this.getEngineExecuteAsyncReturn().foreach((Function1 & Serializable & scala.Serializable)jobReturn -> {
            DefaultEntranceExecutor.$anonfun$doOnFailed$1(msg, failedResponse, entranceExecuteRequest, jobReturn);
            return BoxedUnit.UNIT;
        });
    }

    public boolean kill() {
        LoggerUtils.setJobIdMDC((String)Long.toString(this.getId()));
        this.logger().info("Entrance start to kill job {} invoke Orchestrator ", (Object)BoxesRunTime.boxToLong((long)this.getId()));
        Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String msg = "You job with id  was cancelled by user!";
            this.getRunningOrchestrationFuture().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                x$5.cancel(msg);
                return BoxedUnit.UNIT;
            });
        }, this.logger());
        LoggerUtils.removeJobIdMDC();
        return true;
    }

    public boolean pause() {
        return true;
    }

    public boolean resume() {
        return true;
    }

    public Option<OrchestrationFuture> getRunningOrchestrationFuture() {
        Option<EngineExecuteAsyncReturn> asyncReturn = this.getEngineExecuteAsyncReturn();
        if (asyncReturn.isDefined()) {
            return ((EngineExecuteAsyncReturn)asyncReturn.get()).getOrchestrationFuture();
        }
        return None$.MODULE$;
    }

    @Override
    public ExecuteResponse callExecute(ExecuteRequest request) {
        ExecuteRequest executeRequest = request;
        if (!(executeRequest instanceof EntranceExecuteRequest)) {
            throw new EntranceErrorException(EntranceErrorCode.EXECUTE_REQUEST_INVALID.getErrCode(), new StringBuilder(33).append("Invalid entranceExecuteRequest : ").append(BDPJettyServerHelper$.MODULE$.gson().toJson((Object)request)).toString());
        }
        EntranceExecuteRequest entranceExecuteRequest = (EntranceExecuteRequest)executeRequest;
        EntranceExecuteRequest entranceExecuteRequest2 = entranceExecuteRequest;
        JobReq compJobReq = this.requestToComputationJobReq(entranceExecuteRequest2);
        return (ExecuteResponse)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> {
            EngineExecuteAsyncReturn engineExecuteAsyncReturn;
            Object object;
            Orchestration orchestration = EntranceOrchestrationFactory$.MODULE$.getOrchestrationSession().orchestrate(compJobReq);
            OrchestrationFuture orchestratorFuture = orchestration.asyncExecute();
            String msg = new StringBuilder(44).append("JobRequest (").append(entranceExecuteRequest2.jobId()).append(") was submitted to Orchestrator.").toString();
            this.logger().info(msg);
            entranceExecuteRequest2.getJob().getLogListener().foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                x$6.onLogUpdate((Job)entranceExecuteRequest2.getJob(), LogUtils$.MODULE$.generateInfo(new StringBuilder(29).append(msg).append("(\u60a8\u7684\u4efb\u52a1\u5df2\u7ecf\u63d0\u4ea4\u7ed9Orchestrator\u8fdb\u884c\u7f16\u6392\u6267\u884c)").toString()));
                return BoxedUnit.UNIT;
            });
            if (entranceExecuteRequest2.getJob().getJobRequest().getMetrics() == null) {
                this.logger().warn("Job Metrics has not been initialized");
                object = BoxedUnit.UNIT;
            } else {
                object = !entranceExecuteRequest2.getJob().getJobRequest().getMetrics().containsKey("jobToOrchestrator") ? entranceExecuteRequest2.getJob().getJobRequest().getMetrics().put("jobToOrchestrator", new Date(System.currentTimeMillis())) : BoxedUnit.UNIT;
            }
            LogProcessor logProcessor = this.dealLog(orchestratorFuture, entranceExecuteRequest2.getJob());
            ProgressProcessor progressAndResourceProcessor = this.dealProgressWithResource(orchestratorFuture, entranceExecuteRequest2.getJob());
            orchestratorFuture.notifyMe((Function1 & Serializable & scala.Serializable)orchestrationResponse -> {
                this.dealResponse(orchestrationResponse, entranceExecuteRequest2, orchestration);
                return BoxedUnit.UNIT;
            });
            if (this.getEngineExecuteAsyncReturn().isDefined()) {
                this.getEngineExecuteAsyncReturn().foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                    x$7.closeOrchestration();
                    return BoxedUnit.UNIT;
                });
                engineExecuteAsyncReturn = (EngineExecuteAsyncReturn)this.getEngineExecuteAsyncReturn().get();
            } else {
                this.logger().info(new StringBuilder(69).append("For job ").append(entranceExecuteRequest2.jobId()).append(" and orchestrator task id ").append(compJobReq.getId()).append(" to create EngineExecuteAsyncReturn").toString());
                engineExecuteAsyncReturn = new EngineExecuteAsyncReturn(request, null);
            }
            EngineExecuteAsyncReturn jobReturn = engineExecuteAsyncReturn;
            jobReturn.setOrchestrationObjects(orchestratorFuture, logProcessor, progressAndResourceProcessor);
            this.setEngineReturn(jobReturn);
            return jobReturn;
        }, (Function1 & Serializable & scala.Serializable)t -> {
            if (this.getEngineExecuteAsyncReturn().isEmpty()) {
                String msg = new StringBuilder(37).append("JobRequest (").append(entranceExecuteRequest2.jobId()).append(") submit failed, reason, ").append(ExceptionUtils.getMessage((Throwable)t)).toString();
                entranceExecuteRequest2.getJob().getLogListener().foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                    x$8.onLogUpdate((Job)entranceExecuteRequest2.getJob(), LogUtils$.MODULE$.generateERROR(ExceptionUtils.getStackTrace((Throwable)t)));
                    return BoxedUnit.UNIT;
                });
                return new ErrorExecuteResponse(msg, t);
            }
            String msg = new StringBuilder(37).append("JobRequest (").append(entranceExecuteRequest2.jobId()).append(") submit failed, reason, ").append(ExceptionUtils.getMessage((Throwable)t)).toString();
            DefaultFailedTaskResponse failedResponse = new DefaultFailedTaskResponse(msg, EntranceErrorCode.SUBMIT_JOB_ERROR.getErrCode(), t);
            this.doOnFailed(entranceExecuteRequest2, null, (FailedTaskResponse)failedResponse);
            return null;
        });
    }

    public static final /* synthetic */ void $anonfun$dealLog$1(EntranceJob job$1, LogEvent logEvent) {
        if (job$1 != null) {
            job$1.getLogListener().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.onLogUpdate((Job)job$1, logEvent.log());
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$dealProgressWithResource$1(DefaultEntranceExecutor $this, EntranceJob entranceJob$1, ProgressInfoEvent progressInfoEvent) {
        if (entranceJob$1 != null) {
            try {
                JobHistoryHelper$.MODULE$.updateJobRequestMetrics(entranceJob$1.getJobRequest(), progressInfoEvent.resourceMap(), progressInfoEvent.infoMap());
            }
            catch (Exception e) {
                $this.logger().error("update job metrics error", (Throwable)e);
            }
            entranceJob$1.getProgressListener().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.onProgressUpdate((Job)entranceJob$1, progressInfoEvent.progress(), entranceJob$1.getProgressInfo());
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$dealResponse$2(DefaultEntranceExecutor $this, EntranceExecuteRequest entranceExecuteRequest$1, Orchestration orchestration$1, Object nonLocalReturnKey1$1, Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof Exception) {
            Exception exception = (Exception)throwable;
            String msg = new StringBuilder(25).append("Persist resultSet error. ").append(exception.getMessage()).toString();
            $this.logger().error(msg);
            DefaultFailedTaskResponse errorExecuteResponse = new DefaultFailedTaskResponse(msg, EntranceErrorCode.RESULT_NOT_PERSISTED_ERROR.getErrCode(), (Throwable)exception);
            $this.dealResponse((OrchestrationResponse)errorExecuteResponse, entranceExecuteRequest$1, orchestration$1);
            throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
        }
        throw new MatchError((Object)throwable);
    }

    public static final /* synthetic */ void $anonfun$doOnFailed$1(String msg$2, FailedTaskResponse failedResponse$1, EntranceExecuteRequest entranceExecuteRequest$3, EngineExecuteAsyncReturn jobReturn) {
        jobReturn.notifyError(msg$2, failedResponse$1.getCause());
        jobReturn.notifyStatus(new ResponseTaskStatus(entranceExecuteRequest$3.getJob().getId(), ExecutionNodeStatus.Failed));
    }

    public DefaultEntranceExecutor(long id) {
        super(id);
    }
}

