/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.entrance.log;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.entrance.conf.EntranceConfiguration$;
import org.apache.linkis.entrance.exception.LogReadFailedException;
import org.apache.linkis.entrance.log.Cache;
import org.apache.linkis.entrance.log.LogReader;
import org.apache.linkis.entrance.log.LoopArray;
import org.apache.linkis.storage.FSFactory$;
import org.apache.linkis.storage.fs.FileSystem;
import org.apache.linkis.storage.utils.StorageUtils$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015c\u0001B\n\u0015\u0001}A\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\te\u0001\u0011\t\u0011)A\u0005K!A1\u0007\u0001B\u0001B\u0003%A\u0007\u0003\u00058\u0001\t\u0005\t\u0015!\u0003&\u0011\u0015A\u0004\u0001\"\u0001:\u0011\u001dy\u0004A1A\u0005\u0002\u0001Ca!\u0013\u0001!\u0002\u0013\t\u0005\"\u0002&\u0001\t\u0003Y\u0005\"\u0003'\u0001\u0001\u0004\u0005\r\u0011\"\u0001N\u0011%1\u0006\u00011AA\u0002\u0013\u0005q\u000bC\u0005_\u0001\u0001\u0007\t\u0011)Q\u0005\u001d\"9q\f\u0001a\u0001\n\u0003\u0001\u0007b\u00023\u0001\u0001\u0004%\t!\u001a\u0005\u0007O\u0002\u0001\u000b\u0015B1\t\u000b!\u0004A\u0011B5\t\u000b=\u0004A\u0011I5\t\u000bA\u0004A\u0011K9\t\u000by\u0004A\u0011I@\u0003\u001d\r\u000b7\r[3M_\u001e\u0014V-\u00193fe*\u0011QCF\u0001\u0004Y><'BA\f\u0019\u0003!)g\u000e\u001e:b]\u000e,'BA\r\u001b\u0003\u0019a\u0017N\\6jg*\u00111\u0004H\u0001\u0007CB\f7\r[3\u000b\u0003u\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0011\u0011\u0005\u0005\u0012S\"\u0001\u000b\n\u0005\r\"\"!\u0003'pOJ+\u0017\rZ3s\u0003\u001dawn\u001a)bi\"\u0004\"AJ\u0018\u000f\u0005\u001dj\u0003C\u0001\u0015,\u001b\u0005I#B\u0001\u0016\u001f\u0003\u0019a$o\\8u})\tA&A\u0003tG\u0006d\u0017-\u0003\u0002/W\u00051\u0001K]3eK\u001aL!\u0001M\u0019\u0003\rM#(/\u001b8h\u0015\tq3&A\u0004dQ\u0006\u00148/\u001a;\u0002\u0017MD\u0017M]3e\u0007\u0006\u001c\u0007.\u001a\t\u0003CUJ!A\u000e\u000b\u0003\u000b\r\u000b7\r[3\u0002\tU\u001cXM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000biZD(\u0010 \u0011\u0005\u0005\u0002\u0001\"\u0002\u0013\u0006\u0001\u0004)\u0003\"\u0002\u001a\u0006\u0001\u0004)\u0003\"B\u001a\u0006\u0001\u0004!\u0004\"B\u001c\u0006\u0001\u0004)\u0013\u0001\u00027pG.,\u0012!\u0011\t\u0003\u0005\u001ek\u0011a\u0011\u0006\u0003\t\u0016\u000bA\u0001\\1oO*\ta)\u0001\u0003kCZ\f\u0017B\u0001%D\u0005\u0019y%M[3di\u0006)An\\2lA\u0005Aq-\u001a;DC\u000eDW-F\u00015\u0003)1\u0017\u000e\\3TsN$X-\\\u000b\u0002\u001dB\u0011q\nV\u0007\u0002!*\u0011\u0011KU\u0001\u0003S>T!a\u0015\r\u0002\r\r|W.\\8o\u0013\t)\u0006K\u0001\u0002Gg\u0006qa-\u001b7f'f\u001cH/Z7`I\u0015\fHC\u0001-]!\tI&,D\u0001,\u0013\tY6F\u0001\u0003V]&$\bbB/\u000b\u0003\u0003\u0005\rAT\u0001\u0004q\u0012\n\u0014a\u00034jY\u0016\u001c\u0016p\u001d;f[\u0002\naa\u00197pg\u0016$W#A1\u0011\u0005e\u0013\u0017BA2,\u0005\u001d\u0011un\u001c7fC:\f!b\u00197pg\u0016$w\fJ3r)\tAf\rC\u0004^\u001b\u0005\u0005\t\u0019A1\u0002\u000f\rdwn]3eA\u0005\t2M]3bi\u0016Le\u000e];u'R\u0014X-Y7\u0016\u0003)\u0004\"a[7\u000e\u00031T!!U#\n\u00059d'aC%oaV$8\u000b\u001e:fC6\fabZ3u\u0013:\u0004X\u000f^*ue\u0016\fW.A\u0004sK\u0006$Gj\\4\u0015\tI,(\u0010 \t\u00033NL!\u0001^\u0016\u0003\u0007%sG\u000fC\u0003w#\u0001\u0007q/\u0001\u0003eK\u0006d\u0007\u0003B-yKaK!!_\u0016\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\"B>\u0012\u0001\u0004\u0011\u0018\u0001\u00034s_6d\u0015N\\3\t\u000fu\f\u0002\u0013!a\u0001e\u0006!1/\u001b>f\u0003\u0015\u0019Gn\\:f)\u0005A\u0006&\u0002\n\u0002\u0004\u0005=\u0001#B-\u0002\u0006\u0005%\u0011bAA\u0004W\t1A\u000f\u001b:poN\u00042a[A\u0006\u0013\r\ti\u0001\u001c\u0002\f\u0013>+\u0005pY3qi&|g.\r\u0004\u001fK\u0005E\u00111I\u0019\nG\u0005M\u00111DA\u001d\u0003;)B!!\u0006\u0002\u0018U\tQ\u0005B\u0004\u0002\u001ay\u0011\r!a\t\u0003\u0003QKA!!\b\u0002 \u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIER1!!\t,\u0003\u0019!\bN]8xgF!\u0011QEA\u0016!\rI\u0016qE\u0005\u0004\u0003SY#a\u0002(pi\"Lgn\u001a\t\u0005\u0003[\t\u0019DD\u0002Z\u0003_I1!!\r,\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u000e\u00028\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003cY\u0013'C\u0012\u0002<\u0005u\u0012qHA\u0011\u001d\rI\u0016QH\u0005\u0004\u0003CY\u0013'\u0002\u0012ZW\u0005\u0005#!B:dC2\f\u0017g\u0001\u0014\u0002\n\u0001")
public class CacheLogReader
extends LogReader {
    private final String logPath;
    private final Cache sharedCache;
    private final String user;
    private final Object lock;
    private Fs fileSystem;
    private boolean closed;

    public Object lock() {
        return this.lock;
    }

    public Cache getCache() {
        return this.sharedCache;
    }

    public Fs fileSystem() {
        return this.fileSystem;
    }

    public void fileSystem_$eq(Fs x$1) {
        this.fileSystem = x$1;
    }

    public boolean closed() {
        return this.closed;
    }

    public void closed_$eq(boolean x$1) {
        this.closed = x$1;
    }

    private InputStream createInputStream() {
        if (!this.logPath.contains(this.user)) {
            throw new LogReadFailedException(new StringBuilder(43).append(this.user).append(" does not have permission to read the path ").append(this.logPath).toString());
        }
        FsPath fsPath = new FsPath(this.logPath);
        if (this.fileSystem() == null) {
            Object object = this.lock();
            synchronized (object) {
                if (this.fileSystem() == null) {
                    this.fileSystem_$eq((Fs)(StorageUtils$.MODULE$.isHDFSPath(fsPath) && EntranceConfiguration$.MODULE$.ENABLE_HDFS_JVM_USER() ? (FileSystem)FSFactory$.MODULE$.getFs(new FsPath(this.logPath)) : (FileSystem)FSFactory$.MODULE$.getFsByProxyUser(new FsPath(this.logPath), this.user)));
                    this.fileSystem().init(new HashMap());
                }
            }
        }
        InputStream inputStream = this.fileSystem().read(fsPath);
        return inputStream;
    }

    @Override
    public InputStream getInputStream() {
        return this.createInputStream();
    }

    @Override
    public int readLog(Function1<String, BoxedUnit> deal, int fromLine, int size) {
        if (this.sharedCache.cachedLogs() == null || this.sharedCache.cachedLogs().isEmpty()) {
            return super.readLog(deal, fromLine, size);
        }
        int min = this.sharedCache.cachedLogs().min();
        int max = this.sharedCache.cachedLogs().max();
        int fakeClearEleNums = this.sharedCache.cachedLogs().fakeClearEleNums();
        if (fromLine > max) {
            return 0;
        }
        int from = fromLine;
        int end = size >= 0 && max >= fromLine + size ? fromLine + size : max + 1;
        int readNums = 0;
        if (fromLine < fakeClearEleNums) {
            readNums = super.readLog(deal, fromLine, size);
            if (fromLine + size < min) {
                return readNums;
            }
            from += readNums;
        }
        LoopArray<String> loopArray = this.sharedCache.cachedLogs();
        ((IterableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(from), end).map((Function1 & Serializable & scala.Serializable)index -> CacheLogReader.$anonfun$readLog$1(loopArray, BoxesRunTime.unboxToInt((Object)index)), IndexedSeq$.MODULE$.canBuildFrom())).foreach(deal);
        return end - from + readNums;
    }

    @Override
    public void close() throws IOException {
        if (this.fileSystem() != null) {
            Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.fileSystem().close(), (Function1 & Serializable & scala.Serializable)t -> {
                CacheLogReader.$anonfun$close$2(this, t);
                return BoxedUnit.UNIT;
            });
            this.fileSystem_$eq(null);
        }
        this.closed_$eq(true);
    }

    public static final /* synthetic */ String $anonfun$readLog$1(LoopArray eta$0$1$1, int index) {
        return (String)eta$0$1$1.get(index);
    }

    public static final /* synthetic */ void $anonfun$close$2(CacheLogReader $this, Throwable t) {
        $this.logger().warn("Error encounters when closing fileSystem.", t);
    }

    public CacheLogReader(String logPath, String charset, Cache sharedCache, String user) {
        this.logPath = logPath;
        this.sharedCache = sharedCache;
        this.user = user;
        super(charset);
        this.lock = new Object();
        this.closed = false;
    }
}

