/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.entrance.persistence;

import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.entrance.EntranceContext;
import org.apache.linkis.entrance.cli.heartbeat.CliHeartbeatMonitor;
import org.apache.linkis.entrance.cs.CSEntranceHelper;
import org.apache.linkis.entrance.execute.EntranceJob;
import org.apache.linkis.entrance.log.FlexibleErrorCodeManager;
import org.apache.linkis.entrance.persistence.PersistenceEngine;
import org.apache.linkis.entrance.persistence.PersistenceManager;
import org.apache.linkis.entrance.persistence.ResultSetEngine;
import org.apache.linkis.governance.common.conf.GovernanceCommonConf;
import org.apache.linkis.governance.common.entity.job.JobRequest;
import org.apache.linkis.protocol.engine.JobProgressInfo;
import org.apache.linkis.scheduler.executer.OutputExecuteResponse;
import org.apache.linkis.scheduler.queue.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Tuple2;

public class QueryPersistenceManager
extends PersistenceManager {
    private static final Logger logger = LoggerFactory.getLogger(QueryPersistenceManager.class);
    private EntranceContext entranceContext;
    private PersistenceEngine persistenceEngine;
    private ResultSetEngine resultSetEngine;
    private CliHeartbeatMonitor cliHeartbeatMonitor;

    public CliHeartbeatMonitor getCliHeartbeatMonitor() {
        return this.cliHeartbeatMonitor;
    }

    public void setCliHeartbeatMonitor(CliHeartbeatMonitor cliHeartbeatMonitor) {
        this.cliHeartbeatMonitor = cliHeartbeatMonitor;
    }

    public void setPersistenceEngine(PersistenceEngine persistenceEngine) {
        this.persistenceEngine = persistenceEngine;
    }

    public void setResultSetEngine(ResultSetEngine resultSetEngine) {
        this.resultSetEngine = resultSetEngine;
    }

    @Override
    public EntranceContext getEntranceContext() {
        return this.entranceContext;
    }

    @Override
    public void setEntranceContext(EntranceContext entranceContext) {
        this.entranceContext = entranceContext;
    }

    @Override
    public PersistenceEngine createPersistenceEngine() {
        return this.persistenceEngine;
    }

    @Override
    public ResultSetEngine createResultSetEngine() {
        return this.resultSetEngine;
    }

    @Override
    public void onResultSetCreated(Job job, OutputExecuteResponse response) {
    }

    public void onProgressUpdate(Job job, float progress, JobProgressInfo[] progressInfo) {
        float updatedProgress = progress;
        if (updatedProgress < 0.0f) {
            logger.error("Got negitive progress : " + progress + ", job : " + ((EntranceJob)job).getJobRequest().getId());
            updatedProgress = -1.0f * progress;
        }
        if (Double.isNaN(updatedProgress)) {
            return;
        }
        EntranceJob entranceJob = (EntranceJob)job;
        float persistedProgress = 0.0f;
        try {
            persistedProgress = Float.parseFloat(entranceJob.getJobRequest().getProgress());
        }
        catch (Exception e) {
            logger.warn("Invalid progress : " + entranceJob.getJobRequest().getProgress(), (Throwable)e);
        }
        if (job.getProgress() >= 0.0f && persistedProgress >= updatedProgress && entranceJob.getUpdateMetrisFlag()) {
            return;
        }
        if (updatedProgress > 1.0f) {
            logger.debug("Progress {} beyond 1 will not be updated", (Object)Float.valueOf(updatedProgress));
            return;
        }
        job.setProgress(updatedProgress);
        entranceJob.setUpdateMetrisFlag(true);
        entranceJob.getJobRequest().setProgress(String.valueOf(updatedProgress));
        this.updateJobStatus(job);
    }

    public void onJobScheduled(Job job) {
        this.updateJobStatus(job);
    }

    public void onJobInited(Job job) {
        this.cliHeartbeatMonitor.registerIfCliJob(job);
    }

    public void onJobRunning(Job job) {
        this.updateJobStatus(job);
    }

    public void onJobWaitForRetry(Job job) {
        this.updateJobStatus(job);
    }

    public void onJobCompleted(Job job) {
        try {
            if (job.isSucceed()) {
                CSEntranceHelper.registerCSRSData(job);
            } else {
                Option<Tuple2<String, String>> tuple2Option;
                JobRequest jobRequest = this.entranceContext.getOrCreateEntranceParser().parseToJobRequest(job);
                if ((null == jobRequest.getErrorCode() || jobRequest.getErrorCode() == 0) && (tuple2Option = FlexibleErrorCodeManager.errorMatch(jobRequest.getErrorDesc())).isDefined()) {
                    logger.info(jobRequest.getId() + " to reset errorCode by errorMsg");
                    Tuple2 errorCodeContent = (Tuple2)tuple2Option.get();
                    jobRequest.setErrorCode(Integer.valueOf(Integer.parseInt((String)errorCodeContent._1)));
                    jobRequest.setErrorDesc((String)errorCodeContent._2);
                }
            }
        }
        catch (Throwable e) {
            logger.error("Failed to register cs rs data ", e);
        }
        this.cliHeartbeatMonitor.unRegisterIfCliJob(job);
        this.updateJobStatus(job);
        job.clear();
    }

    private void updateJobStatus(Job job) {
        JobRequest jobRequest = null;
        if (job.isCompleted()) {
            job.setProgress(1.0f);
        } else if (job.getProgress() >= 1.0f && job instanceof EntranceJob) {
            job.setProgress(GovernanceCommonConf.FAKE_PROGRESS());
            ((EntranceJob)job).getJobRequest().setProgress(String.valueOf(GovernanceCommonConf.FAKE_PROGRESS()));
        }
        try {
            jobRequest = this.entranceContext.getOrCreateEntranceParser().parseToJobRequest(job);
            if (job.isSucceed()) {
                jobRequest.setErrorCode(Integer.valueOf(0));
                jobRequest.setErrorDesc("");
            }
        }
        catch (Exception e) {
            this.entranceContext.getOrCreateLogManager().onLogUpdate(job, e.getMessage());
            logger.error("update job status failed, reason:", (Throwable)e);
        }
        try {
            this.createPersistenceEngine().updateIfNeeded(jobRequest);
        }
        catch (ErrorException e) {
            this.entranceContext.getOrCreateLogManager().onLogUpdate(job, e.getMessage());
            throw e;
        }
    }

    @Override
    public void onResultSizeCreated(Job job, int resultSize) {
    }
}

