/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.entrance.utils;

import com.google.common.net.InetAddresses;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.entrance.conf.EntranceConfiguration$;
import org.apache.linkis.entrance.exception.JobHistoryFailedException;
import org.apache.linkis.entrance.execute.EntranceJob$;
import org.apache.linkis.governance.common.constant.job.JobRequestConstants$;
import org.apache.linkis.governance.common.entity.job.JobRequest;
import org.apache.linkis.governance.common.protocol.job.JobReqBatchUpdate;
import org.apache.linkis.governance.common.protocol.job.JobReqQuery;
import org.apache.linkis.governance.common.protocol.job.JobReqUpdate;
import org.apache.linkis.governance.common.protocol.job.JobRespProtocol;
import org.apache.linkis.governance.common.protocol.job.RequestFailoverJob;
import org.apache.linkis.manager.common.protocol.resource.ResourceWithStatus;
import org.apache.linkis.protocol.query.cache.CacheTaskResult;
import org.apache.linkis.protocol.query.cache.RequestReadCache;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.rpc.Sender$;
import org.apache.linkis.scheduler.queue.SchedulerEventState$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class JobHistoryHelper$
implements Logging {
    public static JobHistoryHelper$ MODULE$;
    private final Sender sender;
    private final int SUCCESS_FLAG;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new JobHistoryHelper$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        JobHistoryHelper$ jobHistoryHelper$ = this;
        synchronized (jobHistoryHelper$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private Sender sender() {
        return this.sender;
    }

    private int SUCCESS_FLAG() {
        return this.SUCCESS_FLAG;
    }

    public CacheTaskResult getCache(String executionCode, String user, java.util.List<String> labelStrList, long readCacheBefore) {
        RequestReadCache requestReadCache = new RequestReadCache(executionCode, user, labelStrList, Predef$.MODULE$.long2Long(readCacheBefore));
        Object object = this.sender().ask((Object)requestReadCache);
        if (object instanceof CacheTaskResult) {
            CacheTaskResult cacheTaskResult = (CacheTaskResult)object;
            return cacheTaskResult;
        }
        return null;
    }

    public String getStatusByTaskID(long taskID) {
        JobRequest task = this.getTaskByTaskID(taskID);
        if (task == null) {
            return SchedulerEventState$.MODULE$.Cancelled().toString();
        }
        return task.getStatus();
    }

    public String getProgressByTaskID(long taskID) {
        JobRequest task = this.getTaskByTaskID(taskID);
        if (task == null) {
            return "0";
        }
        return task.getProgress();
    }

    public String getRequestIpAddr(HttpServletRequest req) {
        .colon.colon addrList = new .colon.colon((Object)((String)Option$.MODULE$.apply((Object)req.getHeader("x-forwarded-for")).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).split(",")[0], (List)new .colon.colon((Object)((String)Option$.MODULE$.apply((Object)req.getHeader("Proxy-Client-IP")).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")), (List)new .colon.colon((Object)((String)Option$.MODULE$.apply((Object)req.getHeader("WL-Proxy-Client-IP")).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")), (List)new .colon.colon((Object)((String)Option$.MODULE$.apply((Object)req.getHeader("HTTP_CLIENT_IP")).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")), (List)new .colon.colon((Object)((String)Option$.MODULE$.apply((Object)req.getHeader("HTTP_X_FORWARDED_FOR")).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")), (List)Nil$.MODULE$)))));
        String afterProxyIp = (String)addrList.find((Function1 & Serializable & scala.Serializable)ip -> BoxesRunTime.boxToBoolean((boolean)JobHistoryHelper$.$anonfun$getRequestIpAddr$6(ip))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        if (StringUtils.isNotEmpty((CharSequence)afterProxyIp)) {
            return afterProxyIp;
        }
        return req.getRemoteAddr();
    }

    public void forceKill(long taskID) {
        JobRequest jobRequest = new JobRequest();
        jobRequest.setId(Predef$.MODULE$.long2Long(taskID));
        jobRequest.setStatus(SchedulerEventState$.MODULE$.Cancelled().toString());
        jobRequest.setProgress(Float.toString(EntranceJob$.MODULE$.JOB_COMPLETED_PROGRESS()));
        jobRequest.setUpdatedTime(new Date(System.currentTimeMillis()));
        JobReqUpdate jobReqUpdate = new JobReqUpdate(jobRequest);
        this.sender().ask((Object)jobReqUpdate);
    }

    public void forceBatchKill(ArrayList<Long> taskIdList) {
        ArrayList jobReqList = new ArrayList();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(taskIdList).asScala()).foreach((Function1 & Serializable & scala.Serializable)taskID -> BoxesRunTime.boxToBoolean((boolean)JobHistoryHelper$.$anonfun$forceBatchKill$1(jobReqList, taskID)));
        JobReqBatchUpdate jobReqBatchUpdate = new JobReqBatchUpdate(jobReqList);
        this.sender().ask((Object)jobReqBatchUpdate);
    }

    public void updateAllConsumeQueueTask(java.util.List<Object> taskIdList, boolean retryWhenUpdateFail) {
        while (!taskIdList.isEmpty()) {
            Boolean bl;
            Boolean bl2;
            ArrayList<Object> updateTaskIds = new ArrayList<Object>();
            if (BoxesRunTime.unboxToInt((Object)EntranceConfiguration$.MODULE$.ENTRANCE_UPDATE_BATCH_SIZE().getValue()) > 0 && taskIdList.size() > BoxesRunTime.unboxToInt((Object)EntranceConfiguration$.MODULE$.ENTRANCE_UPDATE_BATCH_SIZE().getValue())) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), BoxesRunTime.unboxToInt((Object)EntranceConfiguration$.MODULE$.ENTRANCE_UPDATE_BATCH_SIZE().getValue())).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> updateTaskIds.add(taskIdList.get(i)));
                bl2 = BoxedUnit.UNIT;
            } else {
                bl2 = BoxesRunTime.boxToBoolean((boolean)updateTaskIds.addAll(taskIdList));
            }
            ArrayList<Object> list = new ArrayList<Object>();
            list.addAll(taskIdList);
            try {
                java.util.List<Object> successTaskIds = this.updateBatchInstancesEmpty(updateTaskIds);
                bl = BoxesRunTime.boxToBoolean((boolean)(retryWhenUpdateFail ? list.removeAll(successTaskIds) : list.removeAll(updateTaskIds)));
            }
            catch (Exception e) {
                this.logger().warn("update batch instances failed, wait for retry", (Throwable)e);
                Thread.sleep(1000L);
                bl = BoxedUnit.UNIT;
            }
            taskIdList = list;
        }
        return;
    }

    public boolean updateAllConsumeQueueTask$default$2() {
        return false;
    }

    public java.util.List<Object> updateBatchInstancesEmpty(java.util.List<Object> taskIdList) {
        ArrayList jobReqList = new ArrayList();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(taskIdList).asScala()).foreach((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)taskID -> {
            JobRequest jobRequest = new JobRequest();
            jobRequest.setId(Predef$.MODULE$.long2Long(taskID));
            jobRequest.setInstances("");
            return jobReqList.add(jobRequest);
        });
        JobReqBatchUpdate jobReqBatchUpdate = new JobReqBatchUpdate(jobReqList);
        return (java.util.List)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> {
            Object response = MODULE$.sender().ask((Object)jobReqBatchUpdate);
            Object object = response;
            if (object instanceof java.util.List) {
                return taskIdList;
            }
            throw new JobHistoryFailedException("update batch instances from jobhistory not a correct List type");
        }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof ErrorException) {
                ErrorException errorException = (ErrorException)throwable;
                throw errorException;
            }
            if (throwable instanceof Exception) {
                Exception exception = (Exception)throwable;
                JobHistoryFailedException e1 = new JobHistoryFailedException(new StringBuilder(29).append("update batch instances ").append(((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(taskIdList).asScala()).mkString(",")).append(" error").toString());
                e1.initCause(exception);
                throw exception;
            }
            throw new MatchError((Object)throwable);
        });
    }

    public java.util.List<JobRequest> queryWaitForFailoverTask(Map<String, Long> reqMap, java.util.List<String> statusList, long startTimestamp, int limit) {
        RequestFailoverJob requestFailoverJob = new RequestFailoverJob(reqMap, statusList, startTimestamp, limit);
        java.util.List tasks = (java.util.List)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> {
            Object response = MODULE$.sender().ask((Object)requestFailoverJob);
            Object object = response;
            if (object instanceof JobRespProtocol) {
                JobRespProtocol jobRespProtocol = (JobRespProtocol)object;
                int status = jobRespProtocol.getStatus();
                if (status != MODULE$.SUCCESS_FLAG()) {
                    MODULE$.logger().error(new StringBuilder(47).append("query from jobHistory status failed, status is ").append(status).toString());
                    throw new JobHistoryFailedException("query from jobHistory status failed");
                }
                Map data = jobRespProtocol.getData();
                Object v = data.get(JobRequestConstants$.MODULE$.JOB_HISTORY_LIST());
                if (v instanceof List) {
                    List list = (List)v;
                    return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)list).asJava();
                }
                throw new JobHistoryFailedException(new StringBuilder(57).append("query from jobhistory not a correct List type, instances ").append(reqMap.keySet()).toString());
            }
            MODULE$.logger().error("get query response incorrectly");
            throw new JobHistoryFailedException("get query response incorrectly");
        }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof ErrorException) {
                ErrorException errorException = (ErrorException)throwable;
                throw errorException;
            }
            if (throwable instanceof Exception) {
                Exception exception = (Exception)throwable;
                JobHistoryFailedException e1 = new JobHistoryFailedException(new StringBuilder(38).append("query failover task error, instances ").append(reqMap.keySet()).append(" ").toString());
                e1.initCause(exception);
                throw exception;
            }
            throw new MatchError((Object)throwable);
        });
        return tasks;
    }

    public JobRequest getTaskByTaskID(long taskID) {
        JobRequest jobRequest = new JobRequest();
        jobRequest.setId(Predef$.MODULE$.long2Long(taskID));
        jobRequest.setSource(null);
        JobReqQuery jobReqQuery = new JobReqQuery(jobRequest);
        JobRequest task = (JobRequest)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> {
            Object taskResponse = MODULE$.sender().ask((Object)jobReqQuery);
            Object object = taskResponse;
            if (object instanceof JobRespProtocol) {
                JobRespProtocol jobRespProtocol = (JobRespProtocol)object;
                int status = jobRespProtocol.getStatus();
                if (status != MODULE$.SUCCESS_FLAG()) {
                    MODULE$.logger().error(new StringBuilder(47).append("query from jobHistory status failed, status is ").append(status).toString());
                    throw new JobHistoryFailedException("query from jobHistory status failed");
                }
                Map data = jobRespProtocol.getData();
                Object v = data.get(JobRequestConstants$.MODULE$.JOB_HISTORY_LIST());
                if (v instanceof java.util.List) {
                    java.util.List list = (java.util.List)v;
                    if (list.size() > 0) {
                        return (JobRequest)list.get(0);
                    }
                    return null;
                }
                throw new JobHistoryFailedException(new StringBuilder(56).append("query from jobhistory not a correct List type taskId is ").append(taskID).toString());
            }
            MODULE$.logger().error("get query response incorrectly");
            throw new JobHistoryFailedException("get query response incorrectly");
        }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof ErrorException) {
                ErrorException errorException = (ErrorException)throwable;
                throw errorException;
            }
            if (throwable instanceof Exception) {
                Exception exception = (Exception)throwable;
                JobHistoryFailedException e1 = new JobHistoryFailedException(new StringBuilder(19).append("query taskId ").append(taskID).append(" error").toString());
                e1.initCause(exception);
                throw exception;
            }
            throw new MatchError((Object)throwable);
        });
        return task;
    }

    public void updateJobRequestMetrics(JobRequest jobRequest, Map<String, ResourceWithStatus> resourceInfo, Map<String, Object> infoMap) {
        Object object;
        Object object2;
        BoxedUnit boxedUnit;
        HashMap ecResourceMap;
        if (jobRequest.getMetrics() == null) {
            jobRequest.setMetrics(new HashMap());
        }
        Map metricsMap = jobRequest.getMetrics();
        Object resourceMap = metricsMap.get("yarnResource");
        HashMap hashMap = ecResourceMap = resourceInfo == null ? new HashMap() : resourceInfo;
        if (resourceMap != null) {
            ((Map)resourceMap).putAll(ecResourceMap);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = metricsMap.put("yarnResource", ecResourceMap);
        }
        Map<String, Map> engineInstanceMap = null;
        if (metricsMap.containsKey("engineconnMap")) {
            engineInstanceMap = (Map)metricsMap.get("engineconnMap");
            object2 = BoxedUnit.UNIT;
        } else {
            engineInstanceMap = new HashMap();
            object2 = metricsMap.put("engineconnMap", engineInstanceMap);
        }
        if (infoMap != null && infoMap.containsKey("ticketId")) {
            String ticketId = (String)infoMap.get("ticketId");
            Map engineExtraInfoMap = engineInstanceMap.getOrDefault(ticketId, new HashMap());
            engineExtraInfoMap.putAll(infoMap);
            object = engineInstanceMap.put(ticketId, engineExtraInfoMap);
        } else {
            this.logger().warn("Ec info map must contains ticketID");
            object = BoxedUnit.UNIT;
        }
        Object object3 = infoMap != null && infoMap.containsKey("requestECTime") ? metricsMap.put("requestECTime", infoMap.get("requestECTime")) : BoxedUnit.UNIT;
        Object object4 = infoMap != null && infoMap.containsKey("jobToECTIme") ? metricsMap.put("jobToECTIme", infoMap.get("jobToECTIme")) : BoxedUnit.UNIT;
        if (infoMap != null && infoMap.containsKey("engineInstance")) {
            metricsMap.put("engineInstance", infoMap.get("engineInstance"));
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$getRequestIpAddr$6(String ip) {
        return StringUtils.isNotEmpty((CharSequence)ip) && InetAddresses.isInetAddress((String)ip);
    }

    public static final /* synthetic */ boolean $anonfun$forceBatchKill$1(ArrayList jobReqList$1, Long taskID) {
        JobRequest jobRequest = new JobRequest();
        jobRequest.setId(taskID);
        jobRequest.setStatus(SchedulerEventState$.MODULE$.Cancelled().toString());
        jobRequest.setProgress(Float.toString(EntranceJob$.MODULE$.JOB_COMPLETED_PROGRESS()));
        jobRequest.setUpdatedTime(new Date(System.currentTimeMillis()));
        return jobReqList$1.add(jobRequest);
    }

    private JobHistoryHelper$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.sender = Sender$.MODULE$.getSender((String)EntranceConfiguration$.MODULE$.JOBHISTORY_SPRING_APPLICATION_NAME().getValue());
        this.SUCCESS_FLAG = 0;
    }
}

