/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.adapter;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import javax.websocket.CloseReason;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;
import javax.websocket.Session;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.lang.Nullable;
import org.springframework.web.reactive.socket.CloseStatus;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.adapter.AbstractListenerWebSocketSession;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;
import reactor.core.publisher.Sinks;

public class StandardWebSocketSession
extends AbstractListenerWebSocketSession<Session> {
    public StandardWebSocketSession(Session session, HandshakeInfo info, DataBufferFactory factory) {
        this(session, info, factory, (Sinks.Empty<Void>)((Sinks.Empty)null));
    }

    public StandardWebSocketSession(Session session, HandshakeInfo info, DataBufferFactory factory, @Nullable Sinks.Empty<Void> completionSink) {
        super(session, session.getId(), info, factory, completionSink);
    }

    @Deprecated
    public StandardWebSocketSession(Session session, HandshakeInfo info, DataBufferFactory factory, @Nullable MonoProcessor<Void> completionMono) {
        super(session, session.getId(), info, factory, completionMono);
    }

    @Override
    protected boolean canSuspendReceiving() {
        return false;
    }

    @Override
    protected void suspendReceiving() {
    }

    @Override
    protected void resumeReceiving() {
    }

    @Override
    protected boolean sendMessage(WebSocketMessage message) throws IOException {
        ByteBuffer buffer = message.getPayload().asByteBuffer();
        if (WebSocketMessage.Type.TEXT.equals((Object)message.getType())) {
            this.getSendProcessor().setReadyToSend(false);
            String text = new String(buffer.array(), StandardCharsets.UTF_8);
            ((Session)this.getDelegate()).getAsyncRemote().sendText(text, (SendHandler)new SendProcessorCallback());
        } else if (WebSocketMessage.Type.BINARY.equals((Object)message.getType())) {
            this.getSendProcessor().setReadyToSend(false);
            ((Session)this.getDelegate()).getAsyncRemote().sendBinary(buffer, (SendHandler)new SendProcessorCallback());
        } else if (WebSocketMessage.Type.PING.equals((Object)message.getType())) {
            ((Session)this.getDelegate()).getAsyncRemote().sendPing(buffer);
        } else if (WebSocketMessage.Type.PONG.equals((Object)message.getType())) {
            ((Session)this.getDelegate()).getAsyncRemote().sendPong(buffer);
        } else {
            throw new IllegalArgumentException("Unexpected message type: " + (Object)((Object)message.getType()));
        }
        return true;
    }

    @Override
    public boolean isOpen() {
        return ((Session)this.getDelegate()).isOpen();
    }

    @Override
    public Mono<Void> close(CloseStatus status) {
        try {
            CloseReason.CloseCode code = CloseReason.CloseCodes.getCloseCode((int)status.getCode());
            ((Session)this.getDelegate()).close(new CloseReason(code, status.getReason()));
        }
        catch (IOException ex) {
            return Mono.error((Throwable)ex);
        }
        return Mono.empty();
    }

    private final class SendProcessorCallback
    implements SendHandler {
        private SendProcessorCallback() {
        }

        public void onResult(SendResult result) {
            if (result.isOK()) {
                StandardWebSocketSession.this.getSendProcessor().setReadyToSend(true);
                StandardWebSocketSession.this.getSendProcessor().onWritePossible();
            } else {
                StandardWebSocketSession.this.getSendProcessor().cancel();
                StandardWebSocketSession.this.getSendProcessor().onError(result.getException());
            }
        }
    }
}

