/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.interactor.properties;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.cli.application.constants.CliConstants;
import org.apache.linkis.cli.application.exception.PropsException;
import org.apache.linkis.cli.application.exception.error.CommonErrMsg;
import org.apache.linkis.cli.application.exception.error.ErrorLevel;
import org.apache.linkis.cli.application.exception.error.ErrorMsg;
import org.apache.linkis.cli.application.interactor.properties.reader.PropertiesReader;
import org.apache.linkis.cli.application.interactor.properties.reader.PropsFileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropsFilesScanner {
    private static final Logger logger = LoggerFactory.getLogger(PropsFilesScanner.class);

    public List<File> getPropsFiles(String rootPath) {
        List files;
        logger.info("Start scanning for properties files. Root path = \"{}\"", (Object)rootPath);
        if (StringUtils.isBlank((CharSequence)rootPath)) {
            throw new PropsException("PRP0004", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.PropsLoaderErr, "Failed to  properties files because rootPath is empty");
        }
        try {
            files = (List)FileUtils.listFiles((File)new File(rootPath), (String[])CliConstants.CONFIG_EXTENSION, (boolean)false);
        }
        catch (Exception e) {
            throw new PropsException("PRP0005", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.PropsLoaderErr, "Failed to list properties files", e);
        }
        if (files == null || files.size() == 0) {
            throw new PropsException("PRP0006", ErrorLevel.WARN, (ErrorMsg)CommonErrMsg.PropsLoaderErr, "PropsFilesScanner has scanned 0 files given root " + rootPath);
        }
        logger.info("Scanned properties files=\"{}\"", (Object)files.toString());
        return files;
    }

    public List<PropertiesReader> getPropsReaders(String rootPath) {
        List<File> files = new PropsFilesScanner().getPropsFiles(rootPath);
        ArrayList<PropertiesReader> readersList = new ArrayList<PropertiesReader>();
        for (int i = 0; i < files.size(); ++i) {
            String name = files.get(i).getName();
            String path = files.get(i).getAbsolutePath();
            PropsFileReader reader = new PropsFileReader();
            reader.setPropsId(name);
            reader.setPropsPath(path);
            readersList.add(reader);
        }
        return readersList;
    }
}

