/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.mutable;

import java.util.Objects;
import java.util.Set;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.mutable.MutableBiRel;
import org.apache.calcite.rel.mutable.MutableRel;
import org.apache.calcite.rel.mutable.MutableRelType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;

public class MutableJoin
extends MutableBiRel {
    public final RexNode condition;
    public final Set<CorrelationId> variablesSet;
    public final JoinRelType joinType;

    private MutableJoin(RelDataType rowType, MutableRel left, MutableRel right, RexNode condition, JoinRelType joinType, Set<CorrelationId> variablesSet) {
        super(MutableRelType.JOIN, left.cluster, rowType, left, right);
        this.condition = condition;
        this.variablesSet = variablesSet;
        this.joinType = joinType;
    }

    public static MutableJoin of(RelDataType rowType, MutableRel left, MutableRel right, RexNode condition, JoinRelType joinType, Set<CorrelationId> variablesStopped) {
        return new MutableJoin(rowType, left, right, condition, joinType, variablesStopped);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof MutableJoin && this.joinType == ((MutableJoin)obj).joinType && this.condition.toString().equals(((MutableJoin)obj).condition.toString()) && Objects.equals(this.variablesSet, ((MutableJoin)obj).variablesSet) && this.left.equals(((MutableJoin)obj).left) && this.right.equals(((MutableJoin)obj).right);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.left, this.right, this.condition.toString(), this.joinType, this.variablesSet});
    }

    @Override
    public StringBuilder digest(StringBuilder buf) {
        return buf.append("Join(joinType: ").append((Object)this.joinType).append(", condition: ").append(this.condition).append(")");
    }

    @Override
    public MutableRel clone() {
        return MutableJoin.of(this.rowType, this.left.clone(), this.right.clone(), this.condition, this.joinType, this.variablesSet);
    }
}

