/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconn.acessible.executor.lock;

import java.io.Serializable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.linkis.common.conf.TimeType;
import org.apache.linkis.common.listener.Event;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.engineconn.acessible.executor.conf.AccessibleExecutorConfiguration$;
import org.apache.linkis.engineconn.acessible.executor.entity.AccessibleExecutor;
import org.apache.linkis.engineconn.acessible.executor.listener.ExecutorStatusListener;
import org.apache.linkis.engineconn.acessible.executor.listener.event.ExecutorCompletedEvent;
import org.apache.linkis.engineconn.acessible.executor.listener.event.ExecutorCreateEvent;
import org.apache.linkis.engineconn.acessible.executor.listener.event.ExecutorStatusChangedEvent;
import org.apache.linkis.engineconn.acessible.executor.listener.event.ExecutorUnLockEvent;
import org.apache.linkis.engineconn.acessible.executor.lock.TimedLock;
import org.apache.linkis.engineconn.core.EngineConnObject$;
import org.apache.linkis.engineconn.core.executor.ExecutorManager$;
import org.apache.linkis.engineconn.executor.entity.Executor;
import org.apache.linkis.engineconn.executor.entity.SensibleExecutor;
import org.apache.linkis.engineconn.executor.listener.ExecutorListenerBusContext$;
import org.apache.linkis.engineconn.executor.listener.event.EngineConnAsyncEvent;
import org.apache.linkis.manager.common.entity.enumeration.NodeStatus;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ef\u0001B\u0011#\u0001EB\u0001B\u0013\u0001\u0003\u0002\u0004%Ia\u0013\u0005\t\u001f\u0002\u0011\t\u0019!C\u0005!\"Aa\u000b\u0001B\u0001B\u0003&A\nC\u0003X\u0001\u0011\u0005\u0001\fC\u0004$\u0001\u0001\u0007I\u0011A.\t\u000f\u0019\u0004\u0001\u0019!C\u0001O\"1\u0011\u000e\u0001Q!\nqCqA\u001b\u0001C\u0002\u0013\u00051\u000e\u0003\u0004p\u0001\u0001\u0006I\u0001\u001c\u0005\ba\u0002\u0001\r\u0011\"\u0001r\u0011%\t)\u0001\u0001a\u0001\n\u0003\t9\u0001\u0003\u0004{\u0001\u0001\u0006KA\u001d\u0005\t\u0003'\u0001\u0001\u0019!C\u0001\u0017\"I\u0011Q\u0003\u0001A\u0002\u0013\u0005\u0011q\u0003\u0005\b\u00037\u0001\u0001\u0015)\u0003M\u0011!\ti\u0002\u0001b\u0001\n\u0003Y\u0005bBA\u0010\u0001\u0001\u0006I\u0001\u0014\u0005\b\u0003C\u0001A\u0011IA\u0012\u0011\u001d\t\u0019\u0004\u0001C!\u0003kAq!a\u0010\u0001\t\u0003\n\t\u0005C\u0004\u0002D\u0001!I!!\u0011\t\u000f\u0005\u0015\u0003\u0001\"\u0011\u0002B!9\u0011q\t\u0001\u0005\n\u0005%\u0003bBA&\u0001\u0011\u0005\u0013Q\n\u0005\b\u0003\u001f\u0002A\u0011IA'\u0011\u001d\t\t\u0006\u0001C!\u0003'Bq!a\u0017\u0001\t\u0003\ni\u0005C\u0004\u0002^\u0001!\t%a\u0018\t\u000f\u0005\r\u0004\u0001\"\u0003\u0002f!9\u0011\u0011\u0011\u0001\u0005B\u0005\r\u0005bBAK\u0001\u0011\u0005\u0013q\u0013\u0005\b\u0003G\u0003A\u0011IAS\u0005M)enZ5oK\u000e{gN\u001c+j[\u0016$Gj\\2l\u0015\t\u0019C%\u0001\u0003m_\u000e\\'BA\u0013'\u0003!)\u00070Z2vi>\u0014(BA\u0014)\u0003%\t7-Z:tS\ndWM\u0003\u0002*U\u0005QQM\\4j]\u0016\u001cwN\u001c8\u000b\u0005-b\u0013A\u00027j].L7O\u0003\u0002.]\u00051\u0011\r]1dQ\u0016T\u0011aL\u0001\u0004_J<7\u0001A\n\u0006\u0001IBD\b\u0012\t\u0003gYj\u0011\u0001\u000e\u0006\u0002k\u0005)1oY1mC&\u0011q\u0007\u000e\u0002\u0007\u0003:L(+\u001a4\u0011\u0005eRT\"\u0001\u0012\n\u0005m\u0012#!\u0003+j[\u0016$Gj\\2l!\ti$)D\u0001?\u0015\ty\u0004)A\u0003vi&d7O\u0003\u0002BU\u000511m\\7n_:L!a\u0011 \u0003\u000f1{wmZ5oOB\u0011Q\tS\u0007\u0002\r*\u0011q\tJ\u0001\tY&\u001cH/\u001a8fe&\u0011\u0011J\u0012\u0002\u0017\u000bb,7-\u001e;peN#\u0018\r^;t\u0019&\u001cH/\u001a8fe\u00069A/[7f_V$X#\u0001'\u0011\u0005Mj\u0015B\u0001(5\u0005\u0011auN\\4\u0002\u0017QLW.Z8vi~#S-\u001d\u000b\u0003#R\u0003\"a\r*\n\u0005M#$\u0001B+oSRDq!\u0016\u0002\u0002\u0002\u0003\u0007A*A\u0002yIE\n\u0001\u0002^5nK>,H\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005eS\u0006CA\u001d\u0001\u0011\u0015QE\u00011\u0001M+\u0005a\u0006CA/e\u001b\u0005q&BA0a\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003C\n\fA!\u001e;jY*\t1-\u0001\u0003kCZ\f\u0017BA3_\u0005%\u0019V-\\1qQ>\u0014X-\u0001\u0005m_\u000e\\w\fJ3r)\t\t\u0006\u000eC\u0004V\r\u0005\u0005\t\u0019\u0001/\u0002\u000b1|7m\u001b\u0011\u0002!I,G.Z1tKN\u001b\u0007.\u001a3vY\u0016\u0014X#\u00017\u0011\u0005uk\u0017B\u00018_\u0005m\u00196\r[3ek2,G\r\u00165sK\u0006$\u0007k\\8m\u000bb,7-\u001e;pe\u0006\t\"/\u001a7fCN,7k\u00195fIVdWM\u001d\u0011\u0002\u0017I,G.Z1tKR\u000b7o[\u000b\u0002eB\u00121\u000f\u001f\t\u0004;R4\u0018BA;_\u0005=\u00196\r[3ek2,GMR;ukJ,\u0007CA<y\u0019\u0001!\u0011\"\u001f\u0007\u0002\u0002\u0003\u0005)\u0011A>\u0003\u0007}#\u0013'\u0001\u0007sK2,\u0017m]3UCN\\\u0007%\u0005\u0002}\u007fB\u00111'`\u0005\u0003}R\u0012qAT8uQ&tw\rE\u00024\u0003\u0003I1!a\u00015\u0005\r\te._\u0001\u0010e\u0016dW-Y:f)\u0006\u001c8n\u0018\u0013fcR\u0019\u0011+!\u0003\t\u0011U[\u0011\u0011!a\u0001\u0003\u0017\u0001D!!\u0004\u0002\u0012A!Q\f^A\b!\r9\u0018\u0011\u0003\u0003\u000bs\u0006%\u0011\u0011!A\u0001\u0006\u0003Y\u0018\u0001\u00047bgRdunY6US6,\u0017\u0001\u00057bgRdunY6US6,w\fJ3r)\r\t\u0016\u0011\u0004\u0005\b+:\t\t\u00111\u0001M\u00035a\u0017m\u001d;M_\u000e\\G+[7fA\u0005y\u0011\u000e\u001a7f)&lW\rT8dW>+H/\u0001\tjI2,G+[7f\u0019>\u001c7nT;uA\u00059\u0011mY9vSJ,GcA)\u0002&!1QE\u0005a\u0001\u0003O\u0001B!!\u000b\u000205\u0011\u00111\u0006\u0006\u0004\u0003[!\u0013AB3oi&$\u00180\u0003\u0003\u00022\u0005-\"AE!dG\u0016\u001c8/\u001b2mK\u0016CXmY;u_J\f!\u0002\u001e:z\u0003\u000e\fX/\u001b:f)\u0011\t9$!\u0010\u0011\u0007M\nI$C\u0002\u0002<Q\u0012qAQ8pY\u0016\fg\u000e\u0003\u0004&'\u0001\u0007\u0011qE\u0001\be\u0016dW-Y:f)\u0005\t\u0016!\u0003:fg\u0016$Hj\\2l\u000311wN]2f%\u0016dW-Y:f\u0003=\u00198\r[3ek2,G+[7f_V$X#A)\u0002\u0015%\u001c\u0018iY9vSJ,G\r\u0006\u0002\u00028\u0005I\u0011n]#ya&\u0014X\rZ\u0001\r]VlwJ\u001a)f]\u0012Lgn\u001a\u000b\u0003\u0003+\u00022aMA,\u0013\r\tI\u0006\u000e\u0002\u0004\u0013:$\u0018!\u0002:f]\u0016<\u0018\u0001\u0004:fg\u0016$H+[7f_V$HcA)\u0002b!)!\n\ba\u0001\u0019\u0006qQO\u001c7pG.\u001c\u0015\r\u001c7cC\u000e\\GcA)\u0002h!9\u0011\u0011N\u000fA\u0002\u0005-\u0014a\u00027pG.\u001cFO\u001d\t\u0005\u0003[\nYH\u0004\u0003\u0002p\u0005]\u0004cAA9i5\u0011\u00111\u000f\u0006\u0004\u0003k\u0002\u0014A\u0002\u001fs_>$h(C\u0002\u0002zQ\na\u0001\u0015:fI\u00164\u0017\u0002BA?\u0003\u007f\u0012aa\u0015;sS:<'bAA=i\u0005\trN\\#yK\u000e,Ho\u001c:De\u0016\fG/\u001a3\u0015\u0007E\u000b)\tC\u0004\u0002\bz\u0001\r!!#\u0002'\u0015DXmY;u_J\u001c%/Z1uK\u00163XM\u001c;\u0011\t\u0005-\u0015\u0011S\u0007\u0003\u0003\u001bS1!a$G\u0003\u0015)g/\u001a8u\u0013\u0011\t\u0019*!$\u0003'\u0015CXmY;u_J\u001c%/Z1uK\u00163XM\u001c;\u0002'=tW\t_3dkR|'oQ8na2,G/\u001a3\u0015\u0007E\u000bI\nC\u0004\u0002\u001c~\u0001\r!!(\u0002-\u0015DXmY;u_J\u001cu.\u001c9mKR,G-\u0012<f]R\u0004B!a#\u0002 &!\u0011\u0011UAG\u0005Y)\u00050Z2vi>\u00148i\\7qY\u0016$X\rZ#wK:$\u0018aF8o\u000bb,7-\u001e;peN#\u0018\r^;t\u0007\"\fgnZ3e)\r\t\u0016q\u0015\u0005\b\u0003S\u0003\u0003\u0019AAV\u0003i)\u00070Z2vi>\u00148\u000b^1ukN\u001c\u0005.\u00198hK\u0012,e/\u001a8u!\u0011\tY)!,\n\t\u0005=\u0016Q\u0012\u0002\u001b\u000bb,7-\u001e;peN#\u0018\r^;t\u0007\"\fgnZ3e\u000bZ,g\u000e\u001e")
public class EngineConnTimedLock
implements TimedLock,
Logging,
ExecutorStatusListener {
    private long timeout;
    private Semaphore lock;
    private final ScheduledThreadPoolExecutor releaseScheduler;
    private ScheduledFuture<?> releaseTask;
    private long lastLockTime;
    private final long idleTimeLockOut;
    private Logger logger;
    private volatile boolean bitmap$0;

    @Override
    public void onEvent(EngineConnAsyncEvent event) {
        ExecutorStatusListener.onEvent$(this, event);
    }

    @Override
    public void onEventError(Event event, Throwable t) {
        ExecutorStatusListener.onEventError$(this, event, t);
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        EngineConnTimedLock engineConnTimedLock = this;
        synchronized (engineConnTimedLock) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private long timeout() {
        return this.timeout;
    }

    private void timeout_$eq(long x$1) {
        this.timeout = x$1;
    }

    public Semaphore lock() {
        return this.lock;
    }

    public void lock_$eq(Semaphore x$1) {
        this.lock = x$1;
    }

    public ScheduledThreadPoolExecutor releaseScheduler() {
        return this.releaseScheduler;
    }

    public ScheduledFuture<?> releaseTask() {
        return this.releaseTask;
    }

    public void releaseTask_$eq(ScheduledFuture<?> x$1) {
        this.releaseTask = x$1;
    }

    public long lastLockTime() {
        return this.lastLockTime;
    }

    public void lastLockTime_$eq(long x$1) {
        this.lastLockTime = x$1;
    }

    public long idleTimeLockOut() {
        return this.idleTimeLockOut;
    }

    @Override
    public void acquire(AccessibleExecutor executor) {
        this.lock().acquire();
        this.lastLockTime_$eq(System.currentTimeMillis());
        this.scheduleTimeout();
    }

    @Override
    public boolean tryAcquire(AccessibleExecutor executor) {
        boolean succeed;
        block1: {
            if (executor == null || !NodeStatus.Unlock.equals(executor.getStatus())) {
                return false;
            }
            succeed = this.lock().tryAcquire();
            this.logger().debug(new StringBuilder(28).append("try to lock for succeed is  ").append(Boolean.toString(succeed)).toString());
            if (!succeed) break block1;
            this.lastLockTime_$eq(System.currentTimeMillis());
            this.scheduleTimeout();
        }
        return succeed;
    }

    @Override
    public void release() {
        this.logger().debug(new StringBuilder(42).append("try to release for lock: ").append(this.lock().toString()).append(", current thread ").append(Thread.currentThread().getName()).toString());
        if (this.releaseTask() != null) {
            this.releaseTask().cancel(true);
            this.releaseTask_$eq(null);
        }
        this.logger().debug("try to release for lock release success");
        this.unlockCallback(this.lock().toString());
        this.resetLock();
    }

    private void resetLock() {
        this.lock().release();
        this.lock_$eq(new Semaphore(1));
    }

    @Override
    public void forceRelease() {
        if (this.isAcquired()) {
            if (this.releaseTask() != null) {
                this.releaseTask().cancel(true);
                this.releaseTask_$eq(null);
                this.releaseScheduler().purge();
            }
            this.lock().release();
        }
        this.resetLock();
    }

    private synchronized void scheduleTimeout() {
        if (this.releaseTask() == null) {
            this.releaseTask_$eq(this.releaseScheduler().scheduleWithFixedDelay(new Runnable(this){
                private final /* synthetic */ EngineConnTimedLock $outer;

                public synchronized void run() {
                    Executor executor = ExecutorManager$.MODULE$.getInstance().getReportExecutor();
                    if (executor instanceof AccessibleExecutor) {
                        AccessibleExecutor accessibleExecutor = (AccessibleExecutor)executor;
                        if (this.$outer.isAcquired() && NodeStatus.Idle.equals(accessibleExecutor.getStatus()) && this.$outer.isExpired()) {
                            this.$outer.logger().info(new StringBuilder(54).append("Lock : [").append(this.$outer.lock().toString()).append(" was released due to timeout. idleTimeLockOut ").append(this.$outer.idleTimeLockOut()).toString());
                            this.$outer.release();
                            return;
                        }
                        if (this.$outer.isAcquired() && NodeStatus.Busy.equals(accessibleExecutor.getStatus())) {
                            this.$outer.lastLockTime_$eq(System.currentTimeMillis());
                            this.$outer.logger().info("Update lastLockTime because executor is busy.");
                            return;
                        }
                        return;
                    }
                    throw new MatchError((Object)executor);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, 3000L, this.idleTimeLockOut(), TimeUnit.MILLISECONDS));
            this.logger().info("Add scheduled timeout task.");
            return;
        }
    }

    @Override
    public boolean isAcquired() {
        return this.lock().availablePermits() < 1;
    }

    @Override
    public boolean isExpired() {
        if (this.lastLockTime() == 0L) {
            return false;
        }
        if (this.timeout() <= 0L) {
            return false;
        }
        if (BoxesRunTime.unboxToBoolean((Object)AccessibleExecutorConfiguration$.MODULE$.ENGINECONN_ENABLED_LOCK_IDLE_TIME_OUT().getValue())) {
            return System.currentTimeMillis() - this.lastLockTime() > this.idleTimeLockOut();
        }
        return System.currentTimeMillis() - this.lastLockTime() > this.timeout();
    }

    @Override
    public int numOfPending() {
        return this.lock().getQueueLength();
    }

    @Override
    public boolean renew() {
        if (this.isAcquired() && this.releaseTask() != null && this.releaseTask().cancel(false)) {
            this.releaseScheduler().purge();
            this.scheduleTimeout();
            this.lastLockTime_$eq(System.currentTimeMillis());
            return true;
        }
        return false;
    }

    @Override
    public synchronized void resetTimeout(long timeout) {
        if (this.isAcquired()) {
            if (this.releaseTask() != null && !this.isExpired()) {
                this.releaseTask().cancel(true);
                this.timeout_$eq(timeout);
            }
            this.scheduleTimeout();
            return;
        }
        this.logger().error("Lock is not acquired, so cannot be reset-Timeout");
    }

    private void unlockCallback(String lockStr) {
        NodeStatus nodeStatus;
        NodeStatus nodeStatus2;
        Executor executor2 = ExecutorManager$.MODULE$.getInstance().getReportExecutor();
        if (executor2 instanceof SensibleExecutor) {
            SensibleExecutor sensibleExecutor = (SensibleExecutor)executor2;
            nodeStatus2 = sensibleExecutor.getStatus();
        } else {
            nodeStatus2 = nodeStatus = NodeStatus.Idle;
        }
        if (Predef$.MODULE$.Boolean2boolean(NodeStatus.isCompleted((NodeStatus)nodeStatus))) {
            this.logger().info("The node({}) is already in the completed state, and the unlocking is invalid", new Object[]{nodeStatus.toString()});
            return;
        }
        Executor[] executors = (Executor[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ExecutorManager$.MODULE$.getInstance().getExecutors())).filter((Function1 & Serializable & scala.Serializable)executor -> BoxesRunTime.boxToBoolean((boolean)EngineConnTimedLock.$anonfun$unlockCallback$1(executor)));
        if (executors != null && !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])executors)).isEmpty()) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])executors)).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                EngineConnTimedLock.$anonfun$unlockCallback$2(x0$1);
                return BoxedUnit.UNIT;
            });
        }
        ExecutorListenerBusContext$.MODULE$.getExecutorListenerBusContext().getEngineConnAsyncListenerBus().post((Event)new ExecutorUnLockEvent(null, lockStr));
    }

    @Override
    public void onExecutorCreated(ExecutorCreateEvent executorCreateEvent) {
    }

    @Override
    public void onExecutorCompleted(ExecutorCompletedEvent executorCompletedEvent) {
    }

    @Override
    public void onExecutorStatusChanged(ExecutorStatusChangedEvent executorStatusChangedEvent) {
        NodeStatus toStatus = executorStatusChangedEvent.toStatus();
        if (this.isAcquired() && NodeStatus.Idle.equals(toStatus)) {
            this.logger().info(new StringBuilder(52).append("Status changed to ").append(toStatus.name()).append(", update lastUpdatedTime for lock.").toString());
            this.lastLockTime_$eq(System.currentTimeMillis());
            this.scheduleTimeout();
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$unlockCallback$1(Executor executor) {
        return executor != null && !executor.isClosed();
    }

    public static final /* synthetic */ void $anonfun$unlockCallback$2(Executor x0$1) {
        Executor executor = x0$1;
        if (executor instanceof AccessibleExecutor) {
            AccessibleExecutor accessibleExecutor = (AccessibleExecutor)executor;
            accessibleExecutor.transition(NodeStatus.Unlock);
            return;
        }
    }

    public EngineConnTimedLock(long timeout) {
        this.timeout = timeout;
        Logging.$init$((Logging)this);
        ExecutorStatusListener.$init$(this);
        this.lock = new Semaphore(1);
        this.releaseScheduler = new ScheduledThreadPoolExecutor(1);
        this.releaseTask = null;
        this.lastLockTime = 0L;
        this.idleTimeLockOut = ((TimeType)AccessibleExecutorConfiguration$.MODULE$.ENGINECONN_LOCK_CHECK_INTERVAL().getValue(EngineConnObject$.MODULE$.getEngineCreationContext().getOptions())).toLong();
    }
}

