/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.factory;

import io.fabric8.kubernetes.api.model.Quantity;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.utils.ByteTimeUtils;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.engineplugin.spark.config.SparkConfiguration$;
import org.apache.linkis.engineplugin.spark.config.SparkResourceConfiguration$;
import org.apache.linkis.manager.common.conf.RMConfiguration;
import org.apache.linkis.manager.common.entity.resource.DriverAndKubernetesResource;
import org.apache.linkis.manager.common.entity.resource.DriverAndYarnResource;
import org.apache.linkis.manager.common.entity.resource.KubernetesResource;
import org.apache.linkis.manager.common.entity.resource.LoadInstanceResource;
import org.apache.linkis.manager.common.entity.resource.NodeResource;
import org.apache.linkis.manager.common.entity.resource.Resource;
import org.apache.linkis.manager.common.entity.resource.YarnResource;
import org.apache.linkis.manager.engineplugin.common.resource.AbstractEngineResourceFactory;
import org.apache.linkis.manager.engineplugin.common.resource.EngineResourceRequest;
import org.apache.linkis.manager.label.entity.cluster.ClusterLabel;
import org.apache.linkis.manager.label.utils.LabelUtil$;
import org.slf4j.Logger;
import scala.Function0;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u3AAB\u0004\u0001)!)Q\u0006\u0001C\u0001]!)\u0011\u0007\u0001C)e!)\u0001\t\u0001C)\u0003\")1\t\u0001C)\t\")!\f\u0001C\u00017\nq2\u000b]1sW\u0016sw-\u001b8f\u0007>tgNU3t_V\u00148-\u001a$bGR|'/\u001f\u0006\u0003\u0011%\tqAZ1di>\u0014\u0018P\u0003\u0002\u000b\u0017\u0005)1\u000f]1sW*\u0011A\"D\u0001\rK:<\u0017N\\3qYV<\u0017N\u001c\u0006\u0003\u001d=\ta\u0001\\5oW&\u001c(B\u0001\t\u0012\u0003\u0019\t\u0007/Y2iK*\t!#A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001+m1\u0003C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"AB!osJ+g\r\u0005\u0002\u001dI5\tQD\u0003\u0002\u001f?\u0005A!/Z:pkJ\u001cWM\u0003\u0002!C\u000511m\\7n_:T!\u0001\u0004\u0012\u000b\u0005\rj\u0011aB7b]\u0006<WM]\u0005\u0003Ku\u0011Q$\u00112tiJ\f7\r^#oO&tWMU3t_V\u00148-\u001a$bGR|'/\u001f\t\u0003O-j\u0011\u0001\u000b\u0006\u0003S)\nQ!\u001e;jYNT!\u0001I\u0007\n\u00051B#a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\u0002\"\u0001\r\u0001\u000e\u0003\u001d\tQcZ3u\u001b&t'+Z9vKN$(+Z:pkJ\u001cW\r\u0006\u00024wA\u0011A'O\u0007\u0002k)\u0011aD\u000e\u0006\u0003oa\na!\u001a8uSRL(B\u0001\u0011#\u0013\tQTG\u0001\u0005SKN|WO]2f\u0011\u0015a$\u00011\u0001>\u0003U)gnZ5oKJ+7o\\;sG\u0016\u0014V-];fgR\u0004\"\u0001\b \n\u0005}j\"!F#oO&tWMU3t_V\u00148-\u001a*fcV,7\u000f^\u0001\u0016O\u0016$X*\u0019=SKF,Xm\u001d;SKN|WO]2f)\t\u0019$\tC\u0003=\u0007\u0001\u0007Q(\u0001\nhKR\u0014V-];fgR\u0014Vm]8ve\u000e,GCA\u001aF\u0011\u00151E\u00011\u0001H\u0003)\u0001(o\u001c9feRLWm\u001d\t\u0005\u00116{u*D\u0001J\u0015\tQ5*\u0001\u0003vi&d'\"\u0001'\u0002\t)\fg/Y\u0005\u0003\u001d&\u00131!T1q!\t\u0001vK\u0004\u0002R+B\u0011!kF\u0007\u0002'*\u0011AkE\u0001\u0007yI|w\u000e\u001e \n\u0005Y;\u0012A\u0002)sK\u0012,g-\u0003\u0002Y3\n11\u000b\u001e:j]\u001eT!AV\f\u00029\u001d,GOU3rk\u0016\u001cHoS;cKJtW\r^3t%\u0016\u001cx.\u001e:dKR\u00111\u0007\u0018\u0005\u0006\r\u0016\u0001\ra\u0012")
public class SparkEngineConnResourceFactory
implements AbstractEngineResourceFactory,
Logging {
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    public NodeResource createEngineResource(EngineResourceRequest engineResourceRequest) {
        return AbstractEngineResourceFactory.createEngineResource$((AbstractEngineResourceFactory)this, (EngineResourceRequest)engineResourceRequest);
    }

    private Logger logger$lzycompute() {
        SparkEngineConnResourceFactory sparkEngineConnResourceFactory = this;
        synchronized (sparkEngineConnResourceFactory) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public Resource getMinRequestResource(EngineResourceRequest engineResourceRequest) {
        ClusterLabel clusterLabel = (ClusterLabel)LabelUtil$.MODULE$.getLabelFromList(engineResourceRequest.labels(), ClassTag$.MODULE$.apply(ClusterLabel.class));
        if (clusterLabel != null && StringUtils.equals((CharSequence)clusterLabel.getClusterType().toUpperCase(), (CharSequence)((CharSequence)RMConfiguration.DEFAULT_KUBERNETES_TYPE.getValue()))) {
            return this.getRequestKubernetesResource(engineResourceRequest.properties());
        }
        return this.getRequestResource(engineResourceRequest.properties());
    }

    public Resource getMaxRequestResource(EngineResourceRequest engineResourceRequest) {
        ClusterLabel clusterLabel = (ClusterLabel)LabelUtil$.MODULE$.getLabelFromList(engineResourceRequest.labels(), ClassTag$.MODULE$.apply(ClusterLabel.class));
        if (clusterLabel != null && StringUtils.equals((CharSequence)clusterLabel.getClusterType().toUpperCase(), (CharSequence)((CharSequence)RMConfiguration.DEFAULT_KUBERNETES_TYPE.getValue()))) {
            return this.getRequestKubernetesResource(engineResourceRequest.properties());
        }
        return this.getRequestResource(engineResourceRequest.properties());
    }

    public Resource getRequestResource(Map<String, String> properties) {
        int executorNum = BoxesRunTime.unboxToInt((Object)SparkResourceConfiguration$.MODULE$.LINKIS_SPARK_EXECUTOR_INSTANCES().getValue(properties));
        String executorMemory = (String)SparkResourceConfiguration$.MODULE$.LINKIS_SPARK_EXECUTOR_MEMORY().getValue(properties);
        String executorMemoryWithUnit = StringUtils.isNumeric((CharSequence)executorMemory) ? new StringBuilder(1).append(executorMemory).append("g").toString() : executorMemory;
        String driverMemory = (String)SparkResourceConfiguration$.MODULE$.LINKIS_SPARK_DRIVER_MEMORY().getValue(properties);
        String driverMemoryWithUnit = StringUtils.isNumeric((CharSequence)driverMemory) ? new StringBuilder(1).append(driverMemory).append("g").toString() : driverMemory;
        int driverCores = BoxesRunTime.unboxToInt((Object)SparkResourceConfiguration$.MODULE$.LINKIS_SPARK_DRIVER_CORES().getValue(properties));
        return new DriverAndYarnResource(new LoadInstanceResource(ByteTimeUtils.byteStringAsBytes((String)driverMemoryWithUnit), driverCores, 1), new YarnResource(ByteTimeUtils.byteStringAsBytes((String)executorMemoryWithUnit) * (long)executorNum, BoxesRunTime.unboxToInt((Object)SparkResourceConfiguration$.MODULE$.LINKIS_SPARK_EXECUTOR_CORES().getValue(properties)) * executorNum, 0, (String)SparkResourceConfiguration$.MODULE$.LINKIS_QUEUE_NAME().getValue(properties)));
    }

    public Resource getRequestKubernetesResource(Map<String, String> properties) {
        long l;
        String executorMemoryWithUnit;
        long l2;
        int executorNum = BoxesRunTime.unboxToInt((Object)SparkResourceConfiguration$.MODULE$.LINKIS_SPARK_EXECUTOR_INSTANCES().getValue(properties));
        if (properties.containsKey(SparkConfiguration$.MODULE$.SPARK_K8S_EXECUTOR_REQUEST_CORES().key())) {
            Quantity executorCoresQuantity = Quantity.parse((String)((String)SparkConfiguration$.MODULE$.SPARK_K8S_EXECUTOR_REQUEST_CORES().getValue(properties)));
            l2 = (long)(Quantity.getAmountInBytes((Quantity)executorCoresQuantity).doubleValue() * (double)1000);
        } else {
            int sparkDefaultExecutorCores = BoxesRunTime.unboxToInt((Object)SparkResourceConfiguration$.MODULE$.LINKIS_SPARK_EXECUTOR_CORES().getValue(properties));
            properties.put(SparkConfiguration$.MODULE$.SPARK_K8S_EXECUTOR_REQUEST_CORES().key(), Integer.toString(sparkDefaultExecutorCores));
            l2 = (long)sparkDefaultExecutorCores * 1000L;
        }
        long executorCores = l2;
        String executorMemory = (String)SparkResourceConfiguration$.MODULE$.LINKIS_SPARK_EXECUTOR_MEMORY().getValue(properties);
        String string = executorMemoryWithUnit = StringUtils.isNumeric((CharSequence)executorMemory) ? new StringBuilder(1).append(executorMemory).append("g").toString() : executorMemory;
        if (properties.containsKey(SparkConfiguration$.MODULE$.SPARK_K8S_DRIVER_REQUEST_CORES().key())) {
            Quantity executorCoresQuantity = Quantity.parse((String)((String)SparkConfiguration$.MODULE$.SPARK_K8S_DRIVER_REQUEST_CORES().getValue(properties)));
            l = (long)(Quantity.getAmountInBytes((Quantity)executorCoresQuantity).doubleValue() * (double)1000);
        } else {
            int sparkDefaultDriverCores = BoxesRunTime.unboxToInt((Object)SparkResourceConfiguration$.MODULE$.LINKIS_SPARK_DRIVER_CORES().getValue(properties));
            properties.put(SparkConfiguration$.MODULE$.SPARK_K8S_DRIVER_REQUEST_CORES().key(), Integer.toString(sparkDefaultDriverCores));
            l = (long)sparkDefaultDriverCores * 1000L;
        }
        long driverCores = l;
        String driverMemory = (String)SparkResourceConfiguration$.MODULE$.LINKIS_SPARK_DRIVER_MEMORY().getValue(properties);
        String driverMemoryWithUnit = StringUtils.isNumeric((CharSequence)driverMemory) ? new StringBuilder(1).append(driverMemory).append("g").toString() : driverMemory;
        long totalExecutorMemory = ByteTimeUtils.byteStringAsBytes((String)executorMemoryWithUnit) * (long)executorNum + ByteTimeUtils.byteStringAsBytes((String)driverMemoryWithUnit);
        long totalExecutorCores = executorCores * (long)executorNum + driverCores;
        String namespace = (String)SparkConfiguration$.MODULE$.SPARK_K8S_NAMESPACE().getValue(properties);
        return new DriverAndKubernetesResource(new LoadInstanceResource(0L, 0, 0), new KubernetesResource(totalExecutorMemory, totalExecutorCores, namespace));
    }

    public SparkEngineConnResourceFactory() {
        AbstractEngineResourceFactory.$init$((AbstractEngineResourceFactory)this);
        Logging.$init$((Logging)this);
    }
}

