/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.server.conf;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.server.conf.ServerConfiguration;
import org.springframework.boot.context.TypeExcludeFilter;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.stereotype.Component;

@Component
public class DataWorkCloudTypeExcludeFilter
extends TypeExcludeFilter {
    private String[] excludePackages = StringUtils.split((String)((String)ServerConfiguration.BDP_SERVER_EXCLUDE_PACKAGES().getValue()), (String)",");
    private String[] excludeClasses = StringUtils.split((String)((String)ServerConfiguration.BDP_SERVER_EXCLUDE_CLASSES().getValue()), (String)",");
    private String[] excludeAnnotation = StringUtils.split((String)((String)ServerConfiguration.BDP_SERVER_EXCLUDE_ANNOTATION().getValue()), (String)",");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
        String className = metadataReader.getClassMetadata().getClassName();
        if (Arrays.stream(this.excludePackages).anyMatch(className::startsWith)) return true;
        if (Arrays.stream(this.excludeClasses).anyMatch(className::equals)) return true;
        if (!Arrays.stream(this.excludeAnnotation).anyMatch(annotation -> metadataReader.getAnnotationMetadata().hasAnnotation(annotation))) return false;
        return true;
    }

    public boolean equals(Object obj) {
        return obj != null && ((Object)((Object)this)).getClass() == obj.getClass();
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

