/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.common;

import javax.servlet.http.HttpServletRequest;
import springfox.documentation.common.SpringVersion;
import springfox.documentation.common.SpringVersionCapability;
import springfox.documentation.common.Version;
import springfox.documentation.service.PathAdjuster;

public class SwaggerBootstrapUiXForwardPrefixPathAdjuster
implements PathAdjuster {
    static final String X_FORWARDED_PREFIX = "X-Forwarded-Prefix";
    private final HttpServletRequest request;

    public SwaggerBootstrapUiXForwardPrefixPathAdjuster(HttpServletRequest request) {
        this.request = request;
    }

    public String adjustedPath(String path) {
        String prefix = this.request.getHeader(X_FORWARDED_PREFIX);
        if (prefix != null) {
            if (!SpringVersionCapability.supportsXForwardPrefixHeader((Version)new SpringVersion().getVersion())) {
                return prefix + path;
            }
            return prefix;
        }
        return path;
    }
}

