/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.redis;

import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.redis.RedisPersistence;
import org.apache.spark.sql.types.StructType;
import redis.clients.jedis.Pipeline;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001M4AAB\u0004\u0001%!)1\u0005\u0001C\u0001I!)a\u0005\u0001C!O!)!\n\u0001C!\u0017\")\u0011\f\u0001C!5\")!\r\u0001C!G\n1\")\u001b8bef\u0014V\rZ5t!\u0016\u00148/[:uK:\u001cWM\u0003\u0002\t\u0013\u0005)!/\u001a3jg*\u0011!bC\u0001\u0004gFd'B\u0001\u0007\u000e\u0003\u0015\u0019\b/\u0019:l\u0015\tqq\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002!\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aE\r\u0011\u0005Q9R\"A\u000b\u000b\u0003Y\tQa]2bY\u0006L!\u0001G\u000b\u0003\r\u0005s\u0017PU3g!\rQ2$H\u0007\u0002\u000f%\u0011Ad\u0002\u0002\u0011%\u0016$\u0017n\u001d)feNL7\u000f^3oG\u0016\u00042\u0001\u0006\u0010!\u0013\tyRCA\u0003BeJ\f\u0017\u0010\u0005\u0002\u0015C%\u0011!%\u0006\u0002\u0005\u0005f$X-\u0001\u0004=S:LGO\u0010\u000b\u0002KA\u0011!\u0004A\u0001\u0005g\u00064X\rF\u0003)WY\u001aU\t\u0005\u0002\u0015S%\u0011!&\u0006\u0002\u0005+:LG\u000fC\u0003-\u0005\u0001\u0007Q&\u0001\u0005qSB,G.\u001b8f!\tqC'D\u00010\u0015\t\u0001\u0014'A\u0003kK\u0012L7O\u0003\u00023g\u000591\r\\5f]R\u001c(\"\u0001\u0005\n\u0005Uz#\u0001\u0003)ja\u0016d\u0017N\\3\t\u000b]\u0012\u0001\u0019\u0001\u001d\u0002\u0007-,\u0017\u0010\u0005\u0002:\u0001:\u0011!H\u0010\t\u0003wUi\u0011\u0001\u0010\u0006\u0003{E\ta\u0001\u0010:p_Rt\u0014BA \u0016\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011I\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005}*\u0002\"\u0002#\u0003\u0001\u0004i\u0012!\u0002<bYV,\u0007\"\u0002$\u0003\u0001\u00049\u0015a\u0001;uYB\u0011A\u0003S\u0005\u0003\u0013V\u00111!\u00138u\u0003\u0011aw.\u00193\u0015\t!bUJ\u0014\u0005\u0006Y\r\u0001\r!\f\u0005\u0006o\r\u0001\r\u0001\u000f\u0005\u0006\u001f\u000e\u0001\r\u0001U\u0001\u0010e\u0016\fX/\u001b:fI\u000e{G.^7ogB\u0019\u0011K\u0016\u001d\u000f\u0005I#fBA\u001eT\u0013\u00051\u0012BA+\u0016\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0016-\u0003\u0007M+\u0017O\u0003\u0002V+\u0005IQM\\2pI\u0016\u0014vn\u001e\u000b\u0004;mk\u0006\"\u0002/\u0005\u0001\u0004A\u0014aB6fs:\u000bW.\u001a\u0005\u0006\t\u0012\u0001\rA\u0018\t\u0003?\u0002l\u0011!C\u0005\u0003C&\u00111AU8x\u0003%!WmY8eKJ{w\u000fF\u0003_I&T'\u000fC\u0003f\u000b\u0001\u0007a-\u0001\u0004lKfl\u0015\r\u001d\t\u0005)\u001dD\u0004(\u0003\u0002i+\t1A+\u001e9mKJBQ\u0001R\u0003A\u0002uAQa[\u0003A\u00021\faa]2iK6\f\u0007CA7q\u001b\u0005q'BA8\n\u0003\u0015!\u0018\u0010]3t\u0013\t\thN\u0001\u0006TiJ,8\r\u001e+za\u0016DQaT\u0003A\u0002A\u0003")
public class BinaryRedisPersistence
implements RedisPersistence<byte[]> {
    @Override
    public void save(Pipeline pipeline, String key, byte[] value, int ttl) {
        byte[] keyBytes = key.getBytes(StandardCharsets.UTF_8);
        if (ttl > 0) {
            pipeline.setex(keyBytes, ttl, value);
        } else {
            pipeline.set(keyBytes, value);
        }
    }

    @Override
    public void load(Pipeline pipeline, String key, Seq<String> requiredColumns) {
        pipeline.get(key.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public byte[] encodeRow(String keyName, Row value) {
        String[] fields = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])value.schema().fields())).map((Function1 & java.io.Serializable & Serializable)x$1 -> x$1.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Object[] valuesArray = (Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & java.io.Serializable & Serializable)f -> value.getAs(f), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
        return SerializationUtils.serialize((java.io.Serializable)((java.io.Serializable)valuesArray));
    }

    @Override
    public Row decodeRow(Tuple2<String, String> keyMap, byte[] value, StructType schema, Seq<String> requiredColumns) {
        Object[] valuesArray = (Object[])SerializationUtils.deserialize((byte[])value);
        return new GenericRowWithSchema(valuesArray, schema);
    }
}

