/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.ecm.server;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.linkis.DataWorkCloudApplication;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.listener.Event;
import org.apache.linkis.ecm.core.listener.ECMAsyncListenerBus;
import org.apache.linkis.ecm.core.listener.ECMSyncListenerBus;
import org.apache.linkis.ecm.server.LinkisECMApplication;
import org.apache.linkis.ecm.server.conf.ECMConfiguration;
import org.apache.linkis.ecm.server.context.ECMContext;
import org.apache.linkis.ecm.server.listener.ECMClosedEvent;
import org.apache.linkis.ecm.server.listener.ECMReadyEvent;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;

@Configuration
class ECMApplicationListener {
    private final Log logger = LogFactory.getLog(this.getClass());

    ECMApplicationListener() {
    }

    @EventListener
    public void onApplicationReady(ApplicationReadyEvent event) {
        ServiceInstance serviceInstance = DataWorkCloudApplication.getServiceInstance();
        LinkisECMApplication.setECMServiceInstance(serviceInstance);
        ECMContext context = (ECMContext)event.getApplicationContext().getBean(ECMContext.class);
        LinkisECMApplication.setContext(context);
        ECMAsyncListenerBus emAsyncListenerBus = context.getECMAsyncListenerBus();
        ECMSyncListenerBus emSyncListenerBus = context.getECMSyncListenerBus();
        emAsyncListenerBus.start();
        ECMReadyEvent ecmReadyEvent = new ECMReadyEvent(LinkisECMApplication.getParmas());
        emAsyncListenerBus.postToAll((Event)ecmReadyEvent);
        emSyncListenerBus.postToAll((Event)ecmReadyEvent);
        LinkisECMApplication.setReady(true);
        this.logger.info((Object)String.format("ECM:%s is ready", serviceInstance));
    }

    @EventListener
    public void onApplicationClosed(ContextClosedEvent contextClosedEvent) {
        ServiceInstance serviceInstance = DataWorkCloudApplication.getServiceInstance();
        LinkisECMApplication.setReady(false);
        ECMClosedEvent ecmClosedEvent = new ECMClosedEvent();
        LinkisECMApplication.getContext().getECMSyncListenerBus().postToAll((Event)ecmClosedEvent);
        ECMAsyncListenerBus ecmAsyncListenerBus = LinkisECMApplication.getContext().getECMAsyncListenerBus();
        ecmAsyncListenerBus.postToAll((Event)ecmClosedEvent);
        this.logger.info((Object)String.format("wait ECM:%s asyncBus empty", serviceInstance));
        try {
            ecmAsyncListenerBus.waitUntilEmpty(ECMConfiguration.ECM_ASYNC_BUS_WAITTOEMPTY_TIME());
        }
        catch (Throwable e) {
            this.logger.error((Object)"wait ECM asyncBus empty failed", e);
        }
        this.logger.info((Object)"ECM asyncBus is empty");
        ecmAsyncListenerBus.stop();
        this.logger.info((Object)"ECM is closed");
    }
}

