/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.launch;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.utils.JsonUtils$;
import org.apache.linkis.engineplugin.spark.config.SparkConfiguration$;
import org.apache.linkis.engineplugin.spark.config.SparkResourceConfiguration$;
import org.apache.linkis.engineplugin.spark.launch.SparkSubmitProcessEngineConnLaunchBuilder;
import org.apache.linkis.hadoop.common.conf.HadoopConf$;
import org.apache.linkis.manager.common.protocol.bml.BmlResource;
import org.apache.linkis.manager.engineplugin.common.conf.EnvConfiguration$;
import org.apache.linkis.manager.engineplugin.common.launch.entity.EngineConnBuildRequest;
import org.apache.linkis.manager.engineplugin.common.launch.process.Environment$;
import org.apache.linkis.manager.engineplugin.common.launch.process.JavaProcessEngineConnLaunchBuilder;
import org.apache.linkis.manager.engineplugin.common.launch.process.LaunchConstants$;
import org.apache.linkis.manager.engineplugin.common.launch.process.ProcessEngineConnLaunchBuilder;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.engine.EngineConnMode$;
import org.apache.linkis.manager.label.entity.engine.UserCreatorLabel;
import org.apache.linkis.manager.label.utils.LabelUtil$;
import org.apache.linkis.storage.FSFactory$;
import org.apache.linkis.storage.utils.StorageUtils$;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001\u0002\t\u0012\u0001yAQa\u000b\u0001\u0005\u00021BQa\f\u0001\u0005RABQA\u0013\u0001\u0005\u0002-CQa\u0014\u0001\u0005\nACQA\u0015\u0001\u0005\nMCQ!\u0016\u0001\u0005BYCQ\u0001\u0019\u0001\u0005R\u0005DQa\u001c\u0001\u0005\nADQa\u001c\u0001\u0005\nUDq!!\u0001\u0001\t#\n\u0019\u0001C\u0004\u0002\b\u0001!\t&!\u0003\t\r\u0005-\u0001\u0001\"\u0015L\u0011\u0019\ti\u0001\u0001C!\u0017\"9\u0011q\u0002\u0001\u0005R\u0005E\u0001bBA\f\u0001\u0011%\u0011\u0011\u0004\u0002\u001d'B\f'o[#oO&tWmQ8o]2\u000bWO\\2i\u0005VLG\u000eZ3s\u0015\t\u00112#\u0001\u0004mCVt7\r\u001b\u0006\u0003)U\tQa\u001d9be.T!AF\f\u0002\u0019\u0015tw-\u001b8fa2,x-\u001b8\u000b\u0005aI\u0012A\u00027j].L7O\u0003\u0002\u001b7\u00051\u0011\r]1dQ\u0016T\u0011\u0001H\u0001\u0004_J<7\u0001A\n\u0003\u0001}\u0001\"\u0001I\u0015\u000e\u0003\u0005R!AI\u0012\u0002\u000fA\u0014xnY3tg*\u0011!\u0003\n\u0006\u0003K\u0019\naaY8n[>t'B\u0001\f(\u0015\tAs#A\u0004nC:\fw-\u001a:\n\u0005)\n#A\t&bm\u0006\u0004&o\\2fgN,enZ5oK\u000e{gN\u001c'bk:\u001c\u0007NQ;jY\u0012,'/\u0001\u0004=S:LGO\u0010\u000b\u0002[A\u0011a\u0006A\u0007\u0002#\u0005Yq-\u001a;D_6l\u0017M\u001c3t)\t\t$\tE\u00023k]j\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003q}r!!O\u001f\u0011\u0005i\u001aT\"A\u001e\u000b\u0005qj\u0012A\u0002\u001fs_>$h(\u0003\u0002?g\u00051\u0001K]3eK\u001aL!\u0001Q!\u0003\rM#(/\u001b8h\u0015\tq4\u0007C\u0003D\u0005\u0001\u000fA)\u0001\ff]\u001eLg.Z\"p]:\u0014U/\u001b7e%\u0016\fX/Z:u!\t)\u0005*D\u0001G\u0015\t95%\u0001\u0004f]RLG/_\u0005\u0003\u0013\u001a\u0013a#\u00128hS:,7i\u001c8o\u0005VLG\u000e\u001a*fcV,7\u000f^\u0001\u000bSN|enY3N_\u0012,W#\u0001'\u0011\u0005Ij\u0015B\u0001(4\u0005\u001d\u0011un\u001c7fC:\fqaZ3u+N,'\u000f\u0006\u00028#\")1\t\u0002a\u0001\t\u0006Yq-\u001a;US\u000e\\W\r^%e)\t9D\u000bC\u0003D\u000b\u0001\u0007A)\u0001\bhKR,eN^5s_:lWM\u001c;\u0015\u0005]{\u0006\u0003\u0002-^o]j\u0011!\u0017\u0006\u00035n\u000bA!\u001e;jY*\tA,\u0001\u0003kCZ\f\u0017B\u00010Z\u0005\ri\u0015\r\u001d\u0005\u0006\u0007\u001a\u0001\u001d\u0001R\u0001\u0010O\u0016$()\u001c7SKN|WO]2fgR\u0011!M\u001c\t\u00041\u000e,\u0017B\u00013Z\u0005\u0011a\u0015n\u001d;\u0011\u0005\u0019dW\"A4\u000b\u0005!L\u0017a\u00012nY*\u0011!n[\u0001\taJ|Go\\2pY*\u0011QeJ\u0005\u0003[\u001e\u00141BQ7m%\u0016\u001cx.\u001e:dK\")1i\u0002a\u0002\t\u0006!2m\u001c8uK:$Hk\u001c\"nYJ+7o\\;sG\u0016$2!Z9t\u0011\u0015\u0011\b\u00021\u00018\u0003!)8/\u001a:OC6,\u0007\"\u0002;\t\u0001\u00049\u0014aB2p]R,g\u000e\u001e\u000b\u0004KZ<\b\"\u0002:\n\u0001\u00049\u0004\"\u0002=\n\u0001\u0004I\u0018AC2p]R,g\u000e^'baB!\u0001,X\u001c{!\tYh0D\u0001}\u0015\ti8,\u0001\u0003mC:<\u0017BA@}\u0005\u0019y%M[3di\u00069r-\u001a;OK\u000e,7o]1ss\u0016sg/\u001b:p]6,g\u000e\u001e\u000b\u0004c\u0005\u0015\u0001\"B\"\u000b\u0001\b!\u0015AE4fi\u0016CHO]1di*\u000bg/Y(qiN,\u0012aN\u0001\u0014S\u001a\fE\r\u001a%jm\u0016\u001cuN\u001c4jOB\u000bG\u000f[\u0001\u0013K:\f'\r\\3Qk\nd\u0017nY'pIVdW-A\rhKR,enZ5oK\u000e{gN\\'b]\u0006<WM\u001d%p_.\u001cH\u0003BA\n\u0003+\u00012\u0001W28\u0011\u0015\u0019e\u0002q\u0001E\u0003U\u0001X\u000f^*qCJ\\W*Z1tkJ,\u0007+\u0019:b[N$\u0002\"a\u0007\u0002\"\u0005\u0015\u0012q\u0005\t\u0004e\u0005u\u0011bAA\u0010g\t!QK\\5u\u0011\u0019\t\u0019c\u0004a\u0001/\u0006Q\u0001O]8qKJ$\u0018.Z:\t\u000bI|\u0001\u0019A\u001c\t\r\u0005%r\u00021\u00018\u0003!!\u0018nY6fi&#\u0007")
public class SparkEngineConnLaunchBuilder
extends JavaProcessEngineConnLaunchBuilder {
    public String[] getCommands(EngineConnBuildRequest engineConnBuildRequest) {
        Map properties = engineConnBuildRequest.engineConnCreationDesc().properties();
        this.putSparkMeasureParams(properties, this.getUser(engineConnBuildRequest), this.getTicketId(engineConnBuildRequest));
        if (this.isOnceMode()) {
            properties.put(EnvConfiguration$.MODULE$.ENGINE_CONN_MEMORY().key(), SparkResourceConfiguration$.MODULE$.LINKIS_SPARK_DRIVER_MEMORY().getValue(properties));
            return super.getCommands(engineConnBuildRequest);
        }
        return new SparkSubmitProcessEngineConnLaunchBuilder(this).getCommands(engineConnBuildRequest, this.getMainClass(), this.getGcLogDir(engineConnBuildRequest), this.getLogDir(engineConnBuildRequest));
    }

    public boolean isOnceMode() {
        String engineConnMode = LabelUtil$.MODULE$.getEngineConnMode(this.engineConnBuildRequest().labels());
        Enumeration.Value value = EngineConnMode$.MODULE$.toEngineConnMode(engineConnMode);
        Enumeration.Value value2 = EngineConnMode$.MODULE$.Once();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    private String getUser(EngineConnBuildRequest engineConnBuildRequest) {
        return (String)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(engineConnBuildRequest.labels()).asScala()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SparkEngineConnLaunchBuilder.$anonfun$getUser$1(x$1))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Label label = x0$1;
            if (label instanceof UserCreatorLabel) {
                UserCreatorLabel userCreatorLabel = (UserCreatorLabel)label;
                return userCreatorLabel.getUser();
            }
            throw new MatchError((Object)label);
        }).get();
    }

    private String getTicketId(EngineConnBuildRequest engineConnBuildRequest) {
        return engineConnBuildRequest.ticketId();
    }

    public Map<String, String> getEnvironment(EngineConnBuildRequest engineConnBuildRequest) {
        Map environment;
        block0: {
            environment = super.getEnvironment(engineConnBuildRequest);
            if (!this.isOnceMode()) break block0;
            LaunchConstants$.MODULE$.addPathToClassPath(environment, new StringBuilder(8).append("$").append(SparkConfiguration$.MODULE$.SPARK_HOME_ENV()).append("/jars/*").toString());
        }
        return environment;
    }

    public List<BmlResource> getBmlResources(EngineConnBuildRequest engineConnBuildRequest) {
        ArrayList<BmlResource> bmlResources;
        block2: {
            if (!this.isOnceMode()) {
                return super.getBmlResources(engineConnBuildRequest);
            }
            bmlResources = new ArrayList<BmlResource>(super.getBmlResources(engineConnBuildRequest));
            Map properties = engineConnBuildRequest.engineConnCreationDesc().properties();
            String userName = (String)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(engineConnBuildRequest.labels()).asScala()).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SparkEngineConnLaunchBuilder.$anonfun$getBmlResources$1(x$2))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Label label = x0$1;
                if (label instanceof UserCreatorLabel) {
                    UserCreatorLabel userCreatorLabel = (UserCreatorLabel)label;
                    return userCreatorLabel.getUser();
                }
                throw new MatchError((Object)label);
            }).get();
            String ticketId = engineConnBuildRequest.ticketId();
            String string = (String)properties.get("spark.app.main.class.jar.bml.json");
            if (string != null) {
                String string2 = string;
                BmlResource bml2 = this.contentToBmlResource(userName, string2);
                this.logger().info(new StringBuilder(30).append("Add a ").append(SparkEngineConnLaunchBuilder.getBmlString$1(bml2)).append(" for user ").append(userName).append(" and ticketId ").append(ticketId).toString());
                bmlResources.add(bml2);
                properties.remove("spark.app.main.class.jar.bml.json");
            }
            String string3 = (String)properties.get("spark.app.user.class.path.bml.json");
            if (string3 == null) break block2;
            String string4 = string3;
            List contentList = (List)JsonUtils$.MODULE$.jackson().readValue(string4, List.class);
            ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(contentList).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> this.contentToBmlResource(userName, (Map<String, Object>)x$3), Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)bml -> BoxesRunTime.boxToBoolean((boolean)SparkEngineConnLaunchBuilder.$anonfun$getBmlResources$4(this, userName, ticketId, bmlResources, bml)));
            properties.remove("spark.app.user.class.path.bml.json");
        }
        return bmlResources;
    }

    private BmlResource contentToBmlResource(String userName, String content) {
        Map contentMap = (Map)JsonUtils$.MODULE$.jackson().readValue(content, Map.class);
        return this.contentToBmlResource(userName, contentMap);
    }

    private BmlResource contentToBmlResource(String userName, Map<String, Object> contentMap) {
        BmlResource bmlResource = new BmlResource();
        bmlResource.setFileName((String)contentMap.get("fileName"));
        bmlResource.setResourceId((String)contentMap.get("resourceId"));
        bmlResource.setVersion((String)contentMap.get("version"));
        bmlResource.setOwner(userName);
        bmlResource.setVisibility(BmlResource.BmlResourceVisibility.Private);
        return bmlResource;
    }

    public String[] getNecessaryEnvironment(EngineConnBuildRequest engineConnBuildRequest) {
        if (this.isOnceMode()) {
            String[] stringArray = (String[])((Object[])new String[]{SparkConfiguration$.MODULE$.SPARK_HOME_ENV(), SparkConfiguration$.MODULE$.SPARK_CONF_DIR_ENV()});
            return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])super.getNecessaryEnvironment(engineConnBuildRequest))).$plus$plus$colon((Traversable)Predef$.MODULE$.wrapRefArray((Object[])stringArray), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        }
        return super.getNecessaryEnvironment(engineConnBuildRequest);
    }

    public String getExtractJavaOpts() {
        if (this.isOnceMode()) {
            if (!BoxesRunTime.unboxToBoolean((Object)HadoopConf$.MODULE$.KEYTAB_PROXYUSER_ENABLED().getValue())) {
                return super.getExtractJavaOpts();
            }
            return new StringBuilder(0).append(super.getExtractJavaOpts()).append(new StringBuilder(21).append(" -DHADOOP_PROXY_USER=").append(Environment$.MODULE$.variable(Environment$.MODULE$.USER())).toString().trim()).toString();
        }
        return super.getExtractJavaOpts();
    }

    public boolean ifAddHiveConfigPath() {
        if (this.isOnceMode()) {
            return true;
        }
        return super.ifAddHiveConfigPath();
    }

    public boolean enablePublicModule() {
        return !this.isOnceMode();
    }

    public List<String> getEngineConnManagerHooks(EngineConnBuildRequest engineConnBuildRequest) {
        if (this.isOnceMode()) {
            return ProcessEngineConnLaunchBuilder.getEngineConnManagerHooks$((ProcessEngineConnLaunchBuilder)this, (EngineConnBuildRequest)engineConnBuildRequest);
        }
        return Lists.newArrayList((Object[])new String[]{"JarUDFLoadECMHook"});
    }

    private void putSparkMeasureParams(Map<String, String> properties, String userName, String ticketId) {
        String flightRecorderType = (String)SparkConfiguration$.MODULE$.SPARKMEASURE_FLIGHT_RECORDER_TYPE().getValue(properties);
        String sparkMeasureOutput = (String)SparkConfiguration$.MODULE$.SPARKMEASURE_OUTPUT_PREFIX().getValue(properties);
        if (StringUtils.isNotBlank((CharSequence)flightRecorderType)) {
            Object object = "stage".equals(flightRecorderType) ? properties.put(SparkConfiguration$.MODULE$.SPARKMEASURE_FLIGHT_RECORDER_KEY(), SparkConfiguration$.MODULE$.SPARKMEASURE_FLIGHT_STAGE_CLASS()) : ("task".equals(flightRecorderType) ? properties.put(SparkConfiguration$.MODULE$.SPARKMEASURE_FLIGHT_RECORDER_KEY(), SparkConfiguration$.MODULE$.SPARKMEASURE_FLIGHT_TASK_CLASS()) : BoxedUnit.UNIT);
            FsPath fsPath = FsPath.getFsPath((String)new FsPath(sparkMeasureOutput).getSchemaPath(), (String[])new String[]{userName, new StringBuilder(7).append("flight_").append(flightRecorderType).toString(), ticketId});
            Fs fs = FSFactory$.MODULE$.getFs(fsPath);
            Object object2 = !fs.exists(fsPath.getParent()) ? BoxesRunTime.boxToBoolean((boolean)fs.mkdirs(fsPath.getParent())) : BoxedUnit.UNIT;
            String string = StorageUtils$.MODULE$.HDFS();
            String string2 = fsPath.getFsType();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                String outputPath = new StringBuilder(0).append(StorageUtils$.MODULE$.HDFS_SCHEMA()).append(fsPath.getPath()).toString();
                properties.put(SparkConfiguration$.MODULE$.SPARKMEASURE_FLIGHT_RECORDER_OUTPUT_FORMAT_KEY(), SparkConfiguration$.MODULE$.SPARKMEASURE_FLIGHT_RECORDER_OUTPUT_FORMAT_JSON_HADOOP());
                properties.put(SparkConfiguration$.MODULE$.SPARKMEASURE_FLIGHT_RECORDER_OUTPUT_FILENAME_KEY(), outputPath);
                return;
            }
            properties.put(SparkConfiguration$.MODULE$.SPARKMEASURE_FLIGHT_RECORDER_OUTPUT_FORMAT_KEY(), SparkConfiguration$.MODULE$.SPARKMEASURE_FLIGHT_RECORDER_OUTPUT_FORMAT_JSON());
            properties.put(SparkConfiguration$.MODULE$.SPARKMEASURE_FLIGHT_RECORDER_OUTPUT_FILENAME_KEY(), fsPath.getPath());
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$getUser$1(Label x$1) {
        return x$1 instanceof UserCreatorLabel;
    }

    public static final /* synthetic */ boolean $anonfun$getBmlResources$1(Label x$2) {
        return x$2 instanceof UserCreatorLabel;
    }

    private static final String getBmlString$1(BmlResource bml) {
        return new StringBuilder(17).append("BmlResource(").append(bml.getFileName()).append(", ").append(bml.getResourceId()).append(", ").append(bml.getVersion()).append(")").toString();
    }

    public static final /* synthetic */ boolean $anonfun$getBmlResources$4(SparkEngineConnLaunchBuilder $this, String userName$1, String ticketId$1, ArrayList bmlResources$1, BmlResource bml) {
        $this.logger().info(new StringBuilder(30).append("Add a ").append(SparkEngineConnLaunchBuilder.getBmlString$1(bml)).append(" for user ").append(userName$1).append(" and ticketId ").append(ticketId$1).toString());
        return bmlResources$1.add(bml);
    }
}

