/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.metadata.query.service;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.datasourcemanager.common.util.json.Json;
import org.apache.linkis.metadata.query.common.domain.GenerateSqlInfo;
import org.apache.linkis.metadata.query.common.domain.MetaColumnInfo;
import org.apache.linkis.metadata.query.common.exception.MetaRuntimeException;
import org.apache.linkis.metadata.query.common.service.AbstractDbMetaService;
import org.apache.linkis.metadata.query.common.service.MetadataConnection;
import org.apache.linkis.metadata.query.service.conf.SqlParamsMapper;
import org.apache.linkis.metadata.query.service.db2.SqlConnection;
import org.springframework.stereotype.Component;

@Component
public class Db2MetaService
extends AbstractDbMetaService<SqlConnection> {
    public MetadataConnection<SqlConnection> getConnection(String operator, Map<String, Object> params) throws Exception {
        String host = String.valueOf(params.getOrDefault(SqlParamsMapper.PARAM_SQL_HOST.getValue(), ""));
        Integer port = Double.valueOf(String.valueOf(params.getOrDefault(SqlParamsMapper.PARAM_SQL_PORT.getValue(), 0))).intValue();
        String username = String.valueOf(params.getOrDefault(SqlParamsMapper.PARAM_SQL_USERNAME.getValue(), ""));
        String password = String.valueOf(params.getOrDefault(SqlParamsMapper.PARAM_SQL_PASSWORD.getValue(), ""));
        String database = String.valueOf(params.getOrDefault(SqlParamsMapper.PARAM_SQL_DATABASE.getValue(), ""));
        Map extraParams = new HashMap();
        Object sqlParamObj = params.get(SqlParamsMapper.PARAM_SQL_EXTRA_PARAMS.getValue());
        if (null != sqlParamObj) {
            if (!(sqlParamObj instanceof Map)) {
                String paramStr = String.valueOf(sqlParamObj);
                if (StringUtils.isNotBlank((CharSequence)paramStr)) {
                    extraParams = (Map)Json.fromJson((String)paramStr, Map.class, (Class[])new Class[]{String.class, Object.class});
                }
            } else {
                extraParams = (Map)sqlParamObj;
            }
        }
        assert (extraParams != null);
        return new MetadataConnection((Object)new SqlConnection(host, port, username, password, database, extraParams));
    }

    public List<String> queryDatabases(SqlConnection connection) {
        try {
            return connection.getAllDatabases();
        }
        catch (SQLException e) {
            throw new RuntimeException("Fail to get Sql databases(\u83b7\u53d6\u6570\u636e\u5e93\u5217\u8868\u5931\u8d25)", e);
        }
    }

    public List<String> queryTables(SqlConnection connection, String schemaname) {
        try {
            return connection.getAllTables(schemaname);
        }
        catch (SQLException e) {
            throw new RuntimeException("Fail to get Sql tables(\u83b7\u53d6\u8868\u5217\u8868\u5931\u8d25)", e);
        }
    }

    public List<MetaColumnInfo> queryColumns(SqlConnection connection, String schemaname, String table) {
        try {
            return connection.getColumns(schemaname, table);
        }
        catch (ClassNotFoundException | SQLException e) {
            throw new RuntimeException("Fail to get Sql columns(\u83b7\u53d6\u5b57\u6bb5\u5217\u8868\u5931\u8d25)", e);
        }
    }

    public String querySqlConnectUrl(SqlConnection connection) {
        return connection.getSqlConnectUrl();
    }

    public GenerateSqlInfo queryJdbcSql(SqlConnection connection, String database, String table) {
        try {
            return connection.queryJdbcSql(database, table);
        }
        catch (Exception e) {
            throw new MetaRuntimeException("Fail to get jdbc sql (\u83b7\u53d6jdbcSql\u5931\u8d25)", (Throwable)e);
        }
    }
}

