/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.common.serialize.impl.context;

import java.util.HashMap;
import java.util.Map;
import org.apache.linkis.cs.common.entity.source.CommonContextKeyValue;
import org.apache.linkis.cs.common.entity.source.ContextKey;
import org.apache.linkis.cs.common.entity.source.ContextValue;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.apache.linkis.cs.common.serialize.AbstractSerializer;
import org.apache.linkis.cs.common.serialize.helper.ContextSerializationHelper;
import org.apache.linkis.cs.common.utils.CSCommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextKeyValueSerializer
extends AbstractSerializer<CommonContextKeyValue> {
    private static final Logger logger = LoggerFactory.getLogger(ContextKeyValueSerializer.class);

    @Override
    public String getJsonValue(CommonContextKeyValue contextKeyValue) throws CSErrorException {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            ContextKey contextKey = contextKeyValue.getContextKey();
            ContextValue contextValue = contextKeyValue.getContextValue();
            map.put("key", ContextSerializationHelper.getInstance().serialize(contextKey));
            map.put("value", ContextSerializationHelper.getInstance().serialize(contextValue));
            return CSCommonUtils.gson.toJson(map);
        }
        catch (Exception e) {
            logger.error("Failed to serialize contextKeyValue: ", (Throwable)e);
            throw new CSErrorException(97000, "Failed to serialize contextKeyValue");
        }
    }

    @Override
    public CommonContextKeyValue fromJson(String json) throws CSErrorException {
        try {
            Map jsonObj = (Map)CSCommonUtils.gson.fromJson(json, new HashMap().getClass());
            String key = (String)jsonObj.get("key");
            String value = (String)jsonObj.get("value");
            Object contextKey = ContextSerializationHelper.getInstance().deserialize(key);
            Object contextValue = ContextSerializationHelper.getInstance().deserialize(value);
            CommonContextKeyValue contextKeyValue = new CommonContextKeyValue();
            contextKeyValue.setContextKey((ContextKey)contextKey);
            contextKeyValue.setContextValue((ContextValue)contextValue);
            return contextKeyValue;
        }
        catch (Exception e) {
            logger.error("Failed to deserialize contextKeyValue: ", (Throwable)e);
            throw new CSErrorException(97000, "Failed to serialize contextKeyValue");
        }
    }

    @Override
    public String getType() {
        return "commonContextKeyValue";
    }

    @Override
    public boolean accepts(Object obj) {
        return null != obj && obj instanceof CommonContextKeyValue;
    }
}

