/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.am.pointer;

import org.apache.linkis.common.exception.LinkisRetryException;
import org.apache.linkis.manager.am.exception.AMErrorException;
import org.apache.linkis.manager.am.pointer.AbstractNodePointer;
import org.apache.linkis.manager.am.pointer.EMNodPointer;
import org.apache.linkis.manager.common.entity.node.EngineNode;
import org.apache.linkis.manager.common.entity.node.Node;
import org.apache.linkis.manager.common.protocol.em.ECMOperateRequest;
import org.apache.linkis.manager.common.protocol.em.ECMOperateResponse;
import org.apache.linkis.manager.common.protocol.engine.EngineStopRequest;
import org.apache.linkis.manager.common.protocol.engine.EngineStopResponse;
import org.apache.linkis.manager.engineplugin.common.launch.entity.EngineConnLaunchRequest;
import org.apache.linkis.server.BDPJettyServerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEMNodPointer
extends AbstractNodePointer
implements EMNodPointer {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEMNodPointer.class);
    private Node node;

    public DefaultEMNodPointer(Node node) {
        this.node = node;
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public EngineNode createEngine(EngineConnLaunchRequest engineConnLaunchRequest) {
        logger.info("Start to createEngine ask em " + this.getNode().getServiceInstance());
        Object result = this.getSender().ask((Object)engineConnLaunchRequest);
        if (result instanceof EngineNode) {
            EngineNode engineNode = (EngineNode)result;
            logger.info("Succeed to createEngine ask em " + this.getNode().getServiceInstance() + ", engineNode " + engineNode);
            return engineNode;
        }
        throw new LinkisRetryException(30001, "Failed to createEngine ask em " + this.getNode().getServiceInstance() + "result: " + result);
    }

    @Override
    public void stopEngine(EngineStopRequest engineStopRequest) {
        try {
            Object result = this.getSender().ask((Object)engineStopRequest);
            if (result instanceof EngineStopResponse) {
                EngineStopResponse engineStopResponse = (EngineStopResponse)result;
                if (!engineStopResponse.getStopStatus()) {
                    logger.info("Kill engine : " + engineStopRequest.getServiceInstance().toString() + " failed, because " + engineStopResponse.getMsg() + " . Will ask engine to suicide.");
                } else {
                    logger.info("Succeed to kill engine " + engineStopRequest.getServiceInstance().toString() + ".");
                }
            } else {
                logger.warn("Ask em : " + this.getNode().getServiceInstance().toString() + " to kill engine : " + engineStopRequest.getServiceInstance().toString() + " failed, response is : " + BDPJettyServerHelper.gson().toJson(result) + ".");
            }
        }
        catch (Exception e) {
            logger.warn("Ask em : " + this.getNode().getServiceInstance().toString() + " to kill engine : " + engineStopRequest.getServiceInstance().toString() + " failed, exception is : " + e.getMessage() + ".");
        }
    }

    @Override
    public ECMOperateResponse executeOperation(ECMOperateRequest ecmOperateRequest) {
        Object result = this.getSender().ask((Object)ecmOperateRequest);
        if (result instanceof ECMOperateResponse) {
            return (ECMOperateResponse)result;
        }
        throw new AMErrorException(30001, "Failed to execute ECM operation.");
    }
}

