/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.resources;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.EurekaServerContext;
import com.netflix.eureka.EurekaServerContextHolder;
import com.netflix.eureka.cluster.protocol.ReplicationInstance;
import com.netflix.eureka.cluster.protocol.ReplicationInstanceResponse;
import com.netflix.eureka.cluster.protocol.ReplicationList;
import com.netflix.eureka.cluster.protocol.ReplicationListResponse;
import com.netflix.eureka.registry.PeerAwareInstanceRegistry;
import com.netflix.eureka.resources.ApplicationResource;
import com.netflix.eureka.resources.InstanceResource;
import javax.inject.Inject;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/{version}/peerreplication")
@Produces(value={"application/xml", "application/json"})
public class PeerReplicationResource {
    private static final Logger logger = LoggerFactory.getLogger(PeerReplicationResource.class);
    private static final String REPLICATION = "true";
    private final EurekaServerConfig serverConfig;
    private final PeerAwareInstanceRegistry registry;

    @Inject
    PeerReplicationResource(EurekaServerContext server) {
        this.serverConfig = server.getServerConfig();
        this.registry = server.getRegistry();
    }

    public PeerReplicationResource() {
        this(EurekaServerContextHolder.getInstance().getServerContext());
    }

    @Path(value="batch")
    @POST
    public Response batchReplication(ReplicationList replicationList) {
        try {
            ReplicationListResponse batchResponse = new ReplicationListResponse();
            for (ReplicationInstance instanceInfo : replicationList.getReplicationList()) {
                try {
                    batchResponse.addResponse(this.dispatch(instanceInfo));
                }
                catch (Exception e) {
                    batchResponse.addResponse(new ReplicationInstanceResponse(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), null));
                    logger.error("{} request processing failed for batch item {}/{}", new Object[]{instanceInfo.getAction(), instanceInfo.getAppName(), instanceInfo.getId(), e});
                }
            }
            return Response.ok((Object)batchResponse).build();
        }
        catch (Throwable e) {
            logger.error("Cannot execute batch Request", e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private ReplicationInstanceResponse dispatch(ReplicationInstance instanceInfo) {
        ApplicationResource applicationResource = this.createApplicationResource(instanceInfo);
        InstanceResource resource = this.createInstanceResource(instanceInfo, applicationResource);
        String lastDirtyTimestamp = PeerReplicationResource.toString(instanceInfo.getLastDirtyTimestamp());
        String overriddenStatus = PeerReplicationResource.toString(instanceInfo.getOverriddenStatus());
        String instanceStatus = PeerReplicationResource.toString(instanceInfo.getStatus());
        ReplicationInstanceResponse.Builder singleResponseBuilder = new ReplicationInstanceResponse.Builder();
        switch (instanceInfo.getAction()) {
            case Register: {
                singleResponseBuilder = PeerReplicationResource.handleRegister(instanceInfo, applicationResource);
                break;
            }
            case Heartbeat: {
                singleResponseBuilder = PeerReplicationResource.handleHeartbeat(this.serverConfig, resource, lastDirtyTimestamp, overriddenStatus, instanceStatus);
                break;
            }
            case Cancel: {
                singleResponseBuilder = PeerReplicationResource.handleCancel(resource);
                break;
            }
            case StatusUpdate: {
                singleResponseBuilder = PeerReplicationResource.handleStatusUpdate(instanceInfo, resource);
                break;
            }
            case DeleteStatusOverride: {
                singleResponseBuilder = PeerReplicationResource.handleDeleteStatusOverride(instanceInfo, resource);
            }
        }
        return singleResponseBuilder.build();
    }

    ApplicationResource createApplicationResource(ReplicationInstance instanceInfo) {
        return new ApplicationResource(instanceInfo.getAppName(), this.serverConfig, this.registry);
    }

    InstanceResource createInstanceResource(ReplicationInstance instanceInfo, ApplicationResource applicationResource) {
        return new InstanceResource(applicationResource, instanceInfo.getId(), this.serverConfig, this.registry);
    }

    private static ReplicationInstanceResponse.Builder handleRegister(ReplicationInstance instanceInfo, ApplicationResource applicationResource) {
        applicationResource.addInstance(instanceInfo.getInstanceInfo(), REPLICATION);
        return new ReplicationInstanceResponse.Builder().setStatusCode(Response.Status.OK.getStatusCode());
    }

    private static ReplicationInstanceResponse.Builder handleCancel(InstanceResource resource) {
        Response response = resource.cancelLease(REPLICATION);
        return new ReplicationInstanceResponse.Builder().setStatusCode(response.getStatus());
    }

    private static ReplicationInstanceResponse.Builder handleHeartbeat(EurekaServerConfig config, InstanceResource resource, String lastDirtyTimestamp, String overriddenStatus, String instanceStatus) {
        Response response = resource.renewLease(REPLICATION, overriddenStatus, instanceStatus, lastDirtyTimestamp);
        int responseStatus = response.getStatus();
        ReplicationInstanceResponse.Builder responseBuilder = new ReplicationInstanceResponse.Builder().setStatusCode(responseStatus);
        if ("false".equals(config.getExperimental("bugfix.934"))) {
            if (responseStatus == Response.Status.OK.getStatusCode() && response.getEntity() != null) {
                responseBuilder.setResponseEntity((InstanceInfo)response.getEntity());
            }
        } else if ((responseStatus == Response.Status.OK.getStatusCode() || responseStatus == Response.Status.CONFLICT.getStatusCode()) && response.getEntity() != null) {
            responseBuilder.setResponseEntity((InstanceInfo)response.getEntity());
        }
        return responseBuilder;
    }

    private static ReplicationInstanceResponse.Builder handleStatusUpdate(ReplicationInstance instanceInfo, InstanceResource resource) {
        Response response = resource.statusUpdate(instanceInfo.getStatus(), REPLICATION, PeerReplicationResource.toString(instanceInfo.getLastDirtyTimestamp()));
        return new ReplicationInstanceResponse.Builder().setStatusCode(response.getStatus());
    }

    private static ReplicationInstanceResponse.Builder handleDeleteStatusOverride(ReplicationInstance instanceInfo, InstanceResource resource) {
        Response response = resource.deleteStatusUpdate(REPLICATION, instanceInfo.getStatus(), instanceInfo.getLastDirtyTimestamp().toString());
        return new ReplicationInstanceResponse.Builder().setStatusCode(response.getStatus());
    }

    private static <T> String toString(T value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }
}

