/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconn.core.executor;

import com.google.gson.Gson;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.engineconn.common.creation.EngineCreationContext;
import org.apache.linkis.engineconn.common.engineconn.EngineConn;
import org.apache.linkis.engineconn.core.EngineConnObject$;
import org.apache.linkis.engineconn.core.engineconn.EngineConnManager$;
import org.apache.linkis.engineconn.core.executor.LabelExecutorManager;
import org.apache.linkis.engineconn.core.hook.ExecutorHook$;
import org.apache.linkis.engineconn.core.util.EngineConnUtils$;
import org.apache.linkis.engineconn.executor.entity.Executor;
import org.apache.linkis.engineconn.executor.entity.LabelExecutor;
import org.apache.linkis.engineconn.executor.entity.SensibleExecutor;
import org.apache.linkis.manager.engineplugin.common.EngineConnPlugin;
import org.apache.linkis.manager.engineplugin.common.creation.CodeLanguageLabelExecutorFactory;
import org.apache.linkis.manager.engineplugin.common.creation.EngineConnFactory;
import org.apache.linkis.manager.engineplugin.common.creation.ExecutorFactory;
import org.apache.linkis.manager.engineplugin.common.creation.LabelExecutorFactory;
import org.apache.linkis.manager.engineplugin.common.creation.MultiExecutorEngineConnFactory;
import org.apache.linkis.manager.engineplugin.common.creation.SingleExecutorEngineConnFactory;
import org.apache.linkis.manager.engineplugin.common.creation.SingleLabelExecutorEngineConnFactory;
import org.apache.linkis.manager.engineplugin.common.exception.EngineConnPluginErrorException;
import org.apache.linkis.manager.engineplugin.errorcode.EngineconnCoreErrorCodeSummary;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.utils.LabelUtil$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tMb\u0001\u0002\u000f\u001e\u0001)BQ!\u0010\u0001\u0005\u0002yB\u0001\u0002\u0011\u0001\t\u0006\u0004%I!\u0011\u0005\b9\u0002\u0011\r\u0011\"\u0005^\u0011\u0019A\u0007\u0001)A\u0005=\"9\u0011\u000e\u0001b\u0001\n\u0013Q\u0007BB:\u0001A\u0003%1\u000e\u0003\u0005u\u0001!\u0015\r\u0011\"\u0005v\u0011\u001da\bA1A\u0005\u0012uDq!a\u0004\u0001A\u0003%a\u0010\u0003\u0007\u0002\u0012\u0001\u0001\n\u0011aA!\u0002\u0013\t\u0019\u0002C\u0005\u0002,\u0001\u0011\r\u0011\"\u0005\u0002.!A\u0011q\u0006\u0001!\u0002\u0013\tI\u0002C\u0005\u00022\u0001\u0011\r\u0011\"\u0005\u00024!A\u0011Q\u0007\u0001!\u0002\u0013\ty\u0002C\u0004\u00028\u0001!\t\"!\u000f\t\u000f\u0005U\u0004\u0001\"\u0005\u0002x!9\u0011q\u0011\u0001\u0005\u0012\u0005%\u0005\"CAN\u0001E\u0005I\u0011CAO\u0011\u001d\ti\f\u0001C\u0005\u0003\u007fCq!!5\u0001\t\u0003\n\u0019\u000eC\u0004\u0002\\\u0002!\t%!8\t\u000f\u00055\b\u0001\"\u0011\u0002p\"9!Q\u0001\u0001\u0005B\t\u001d\u0001b\u0002B\n\u0001\u0011\u0005#Q\u0003\u0005\b\u00053\u0001A\u0011\tB\u000e\u0011\u001d\u0011I\u0002\u0001C!\u0005WAqAa\f\u0001\t\u0003\u0012\tD\u0001\rMC\n,G.\u0012=fGV$xN]'b]\u0006<WM]%na2T!AH\u0010\u0002\u0011\u0015DXmY;u_JT!\u0001I\u0011\u0002\t\r|'/\u001a\u0006\u0003E\r\n!\"\u001a8hS:,7m\u001c8o\u0015\t!S%\u0001\u0004mS:\\\u0017n\u001d\u0006\u0003M\u001d\na!\u00199bG\",'\"\u0001\u0015\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001Y\u0013'\u000e\t\u0003Y=j\u0011!\f\u0006\u0002]\u0005)1oY1mC&\u0011\u0001'\f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005I\u001aT\"A\u000f\n\u0005Qj\"\u0001\u0006'bE\u0016dW\t_3dkR|'/T1oC\u001e,'\u000f\u0005\u00027w5\tqG\u0003\u00029s\u0005)Q\u000f^5mg*\u0011!hI\u0001\u0007G>lWn\u001c8\n\u0005q:$a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0002\"A\r\u0001\u0002\u0013\u0015DXmY;u_J\u001cX#\u0001\"\u0011\t\rC%*V\u0007\u0002\t*\u0011QIR\u0001\u0005kRLGNC\u0001H\u0003\u0011Q\u0017M^1\n\u0005%#%aA'baB\u00111J\u0015\b\u0003\u0019B\u0003\"!T\u0017\u000e\u00039S!aT\u0015\u0002\rq\u0012xn\u001c;?\u0013\t\tV&\u0001\u0004Qe\u0016$WMZ\u0005\u0003'R\u0013aa\u0015;sS:<'BA).!\t1&,D\u0001X\u0015\tA\u0016,\u0001\u0004f]RLG/\u001f\u0006\u0003=\u0005J!aW,\u0003\u001b1\u000b'-\u001a7Fq\u0016\u001cW\u000f^8s\u0003\u001195k\u0014(\u0016\u0003y\u0003\"a\u00184\u000e\u0003\u0001T!!\u00192\u0002\t\u001d\u001cxN\u001c\u0006\u0003G\u0012\faaZ8pO2,'\"A3\u0002\u0007\r|W.\u0003\u0002hA\n!qi]8o\u0003\u001595k\u0014(!\u0003%IGm\u0011:fCR|'/F\u0001l!\ta\u0017/D\u0001n\u0015\tqw.\u0001\u0004bi>l\u0017n\u0019\u0006\u0003a\u0012\u000b!bY8oGV\u0014(/\u001a8u\u0013\t\u0011XNA\u0007Bi>l\u0017nY%oi\u0016<WM]\u0001\u000bS\u0012\u001c%/Z1u_J\u0004\u0013AC3oO&tWmQ8o]V\ta\u000f\u0005\u0002xu6\t\u0001P\u0003\u0002#s*\u0011!(I\u0005\u0003wb\u0014!\"\u00128hS:,7i\u001c8o\u0003A)gnZ5oK\u000e{gN\u001c)mk\u001eLg.F\u0001\u007f!\ry\u00181B\u0007\u0003\u0003\u0003Q1AOA\u0002\u0015\u0011\t)!a\u0002\u0002\u0019\u0015tw-\u001b8fa2,x-\u001b8\u000b\u0007\u0005%1%A\u0004nC:\fw-\u001a:\n\t\u00055\u0011\u0011\u0001\u0002\u0011\u000b:<\u0017N\\3D_:t\u0007\u000b\\;hS:\f\u0011#\u001a8hS:,7i\u001c8o!2,x-\u001b8!\u0003\rAH%\r\t\bY\u0005U\u0011\u0011DA\u0010\u0013\r\t9\"\f\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u000b1\nY\"a\b\n\u0007\u0005uQFA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002\"\u0005\u001dRBAA\u0012\u0015\u0011\t)#!\u0001\u0002\u0011\r\u0014X-\u0019;j_:LA!!\u000b\u0002$\tyQ\t_3dkR|'OR1di>\u0014\u00180A\u0005gC\u000e$xN]5fgV\u0011\u0011\u0011D\u0001\u000bM\u0006\u001cGo\u001c:jKN\u0004\u0013A\u00043fM\u0006,H\u000e\u001e$bGR|'/_\u000b\u0003\u0003?\tq\u0002Z3gCVdGOR1di>\u0014\u0018\u0010I\u0001\u0012iJL8I]3bi\u0016,\u00050Z2vi>\u0014H#B+\u0002<\u0005%\u0003bBA\u001f\u001f\u0001\u0007\u0011qH\u0001\u0016K:<\u0017N\\3De\u0016\fG/[8o\u0007>tG/\u001a=u!\u0011\t\t%!\u0012\u000e\u0005\u0005\r#bAA\u0013s&!\u0011qIA\"\u0005U)enZ5oK\u000e\u0013X-\u0019;j_:\u001cuN\u001c;fqRDq!a\u0013\u0010\u0001\u0004\ti%\u0001\u0004mC\n,Gn\u001d\t\u0006Y\u0005m\u0011q\n\u0019\u0005\u0003#\n\u0019\u0007\u0005\u0004\u0002T\u0005m\u0013qL\u0007\u0003\u0003+R1\u0001WA,\u0015\u0011\tI&a\u0002\u0002\u000b1\f'-\u001a7\n\t\u0005u\u0013Q\u000b\u0002\u0006\u0019\u0006\u0014W\r\u001c\t\u0005\u0003C\n\u0019\u0007\u0004\u0001\u0005\u0019\u0005\u0015\u0014\u0011JA\u0001\u0002\u0003\u0015\t!a\u001a\u0003\u0007}#C'\u0005\u0003\u0002j\u0005=\u0004c\u0001\u0017\u0002l%\u0019\u0011QN\u0017\u0003\u000f9{G\u000f[5oOB\u0019A&!\u001d\n\u0007\u0005MTFA\u0002B]f\f1bZ3u\u0019\u0006\u0014W\r\\&fsR\u0019!*!\u001f\t\u000f\u0005-\u0003\u00031\u0001\u0002|A)A&a\u0007\u0002~A\"\u0011qPAB!\u0019\t\u0019&a\u0017\u0002\u0002B!\u0011\u0011MAB\t1\t))!\u001f\u0002\u0002\u0003\u0005)\u0011AA4\u0005\ryF%N\u0001\u000fGJ,\u0017\r^3Fq\u0016\u001cW\u000f^8s)\u0015)\u00161RAG\u0011\u001d\ti$\u0005a\u0001\u0003\u007fA\u0011\"a\u0013\u0012!\u0003\u0005\r!a$\u0011\u000b1\nY\"!%1\t\u0005M\u0015q\u0013\t\u0007\u0003'\nY&!&\u0011\t\u0005\u0005\u0014q\u0013\u0003\r\u00033\u000bi)!A\u0001\u0002\u000b\u0005\u0011q\r\u0002\u0004?\u00122\u0014\u0001G2sK\u0006$X-\u0012=fGV$xN\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\u0014\u0016\u0005\u0003C\u000bY\u000bE\u0003-\u00037\t\u0019\u000b\r\u0003\u0002&\u0006%\u0006CBA*\u00037\n9\u000b\u0005\u0003\u0002b\u0005%FaCAM%\u0005\u0005\t\u0011!B\u0001\u0003OZ#!!,\u0011\t\u0005=\u0016\u0011X\u0007\u0003\u0003cSA!a-\u00026\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003ok\u0013AC1o]>$\u0018\r^5p]&!\u00111XAY\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0014GJ,\u0017\r^3MC\n,G.\u0012=fGV$xN\u001d\u000b\u0006+\u0006\u0005\u00171\u0019\u0005\b\u0003{\u0019\u0002\u0019AA \u0011\u001d\tYe\u0005a\u0001\u0003\u000b\u0004R\u0001LA\u000e\u0003\u000f\u0004D!!3\u0002NB1\u00111KA.\u0003\u0017\u0004B!!\u0019\u0002N\u0012a\u0011qZAb\u0003\u0003\u0005\tQ!\u0001\u0002h\t\u0019q\f\n\u001d\u0002%\u001d,g.\u001a:bi\u0016,\u00050Z2vi>\u0014\u0018\n\u001a\u000b\u0003\u0003+\u00042\u0001LAl\u0013\r\tI.\f\u0002\u0004\u0013:$\u0018aE4fi\u0016CXmY;u_J\u0014\u0015\u0010T1cK2\u001cHcA+\u0002`\"9\u00111J\u000bA\u0002\u0005\u0005\b#\u0002\u0017\u0002\u001c\u0005\r\b\u0007BAs\u0003S\u0004b!a\u0015\u0002\\\u0005\u001d\b\u0003BA1\u0003S$A\"a;\u0002`\u0006\u0005\t\u0011!B\u0001\u0003O\u00121a\u0018\u0013:\u0003=\u0019wN\u001c;bS:,\u00050Z2vi>\u0014H\u0003BAy\u0003o\u00042\u0001LAz\u0013\r\t)0\f\u0002\b\u0005>|G.Z1o\u0011\u001d\tYE\u0006a\u0001\u0003s\u0004R\u0001LA\u000e\u0003w\u0004D!!@\u0003\u0002A1\u00111KA.\u0003\u007f\u0004B!!\u0019\u0003\u0002\u0011a!1AA|\u0003\u0003\u0005\tQ!\u0001\u0002h\t!q\fJ\u00191\u0003-9W\r^#yK\u000e,Ho\u001c:\u0015\t\t%!q\u0002\t\u0004-\n-\u0011b\u0001B\u0007/\nAQ\t_3dkR|'\u000f\u0003\u0004\u0003\u0012]\u0001\rAS\u0001\u0003S\u0012\fAbZ3u\u000bb,7-\u001e;peN,\"Aa\u0006\u0011\u000b1\nYB!\u0003\u0002\u001dI,Wn\u001c<f\u000bb,7-\u001e;peR\u0019QK!\b\t\u000f\u0005-\u0013\u00041\u0001\u0003 A)A&a\u0007\u0003\"A\"!1\u0005B\u0014!\u0019\t\u0019&a\u0017\u0003&A!\u0011\u0011\rB\u0014\t1\u0011IC!\b\u0002\u0002\u0003\u0005)\u0011AA4\u0005\u0011yF%M\u0019\u0015\t\t%!Q\u0006\u0005\u0007\u0005#Q\u0002\u0019\u0001&\u0002#\u001d,GOU3q_J$X\t_3dkR|'/\u0006\u0002\u0003\n\u0001")
public class LabelExecutorManagerImpl
implements LabelExecutorManager,
Logging {
    private Map<String, LabelExecutor> executors;
    private EngineConn engineConn;
    private final Gson GSON;
    private final AtomicInteger idCreator;
    private final EngineConnPlugin engineConnPlugin;
    private final /* synthetic */ Tuple2 x$1;
    private final ExecutorFactory[] factories;
    private final ExecutorFactory defaultFactory;
    private Logger logger;
    private volatile byte bitmap$0;

    @Override
    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    @Override
    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    @Override
    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    @Override
    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    @Override
    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    @Override
    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    @Override
    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    @Override
    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        LabelExecutorManagerImpl labelExecutorManagerImpl = this;
        synchronized (labelExecutorManagerImpl) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private Map<String, LabelExecutor> executors$lzycompute() {
        LabelExecutorManagerImpl labelExecutorManagerImpl = this;
        synchronized (labelExecutorManagerImpl) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.executors = new ConcurrentHashMap<String, LabelExecutor>(2);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.executors;
    }

    private Map<String, LabelExecutor> executors() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.executors$lzycompute();
        }
        return this.executors;
    }

    public Gson GSON() {
        return this.GSON;
    }

    private AtomicInteger idCreator() {
        return this.idCreator;
    }

    private EngineConn engineConn$lzycompute() {
        LabelExecutorManagerImpl labelExecutorManagerImpl = this;
        synchronized (labelExecutorManagerImpl) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.engineConn = EngineConnManager$.MODULE$.getEngineConnManager().getEngineConn();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.engineConn;
    }

    public EngineConn engineConn() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.engineConn$lzycompute();
        }
        return this.engineConn;
    }

    public EngineConnPlugin engineConnPlugin() {
        return this.engineConnPlugin;
    }

    public ExecutorFactory[] factories() {
        return this.factories;
    }

    public ExecutorFactory defaultFactory() {
        return this.defaultFactory;
    }

    public LabelExecutor tryCreateExecutor(EngineCreationContext engineCreationContext, Label<?>[] labels) {
        String labelStr = labels != null ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])labels)).toList() : "()";
        this.logger().info(new StringBuilder(38).append("Try to create a executor with labels ").append((Object)labelStr).append(".").toString());
        LabelExecutor labelExecutor = labels == null || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])labels)).isEmpty() ? (LabelExecutor)this.defaultFactory().createExecutor(engineCreationContext, this.engineConn()) : (LabelExecutor)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.factories())).find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LabelExecutorManagerImpl.$anonfun$tryCreateExecutor$1(labels, x0$1))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ExecutorFactory executorFactory = x0$2;
            if (executorFactory instanceof LabelExecutorFactory) {
                LabelExecutorFactory labelExecutorFactory = (LabelExecutorFactory)executorFactory;
                this.logger().info(new StringBuilder(24).append("Use ").append(labelExecutorFactory.getClass().getSimpleName()).append(" to create executor.").toString());
                return labelExecutorFactory.createExecutor(engineCreationContext, this.engineConn(), labels);
            }
            throw new MatchError((Object)executorFactory);
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            this.logger().info("No LabelExecutorFactory matched, use DefaultExecutorFactory to create executor.");
            return (LabelExecutor)this.defaultFactory().createExecutor(engineCreationContext, this.engineConn());
        });
        String codeType = LabelUtil$.MODULE$.getCodeType(labelExecutor.getExecutorLabels());
        this.logger().info(new StringBuilder(35).append("Finished to create ").append(labelExecutor.getClass().getSimpleName()).append("(").append(labelExecutor.getId()).append(") with labels ").append((Object)labelStr).append(".").toString());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ExecutorHook$.MODULE$.getAllExecutorHooks())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isAccepted(codeType))))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.beforeExecutorInit((Executor)labelExecutor);
            return BoxedUnit.UNIT;
        });
        labelExecutor.init();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ExecutorHook$.MODULE$.getAllExecutorHooks())).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isAccepted(codeType))))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.afterExecutorInit((Executor)labelExecutor);
            return BoxedUnit.UNIT;
        });
        this.logger().info(new StringBuilder(20).append("Finished to init ").append(labelExecutor.getClass().getSimpleName()).append("(").append(labelExecutor.getId()).append(").").toString());
        return labelExecutor;
    }

    public String getLabelKey(Label<?>[] labels) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])labels)).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)LabelExecutorManagerImpl.$anonfun$getLabelKey$1(x$6))))).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getStringValue(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("&");
    }

    public LabelExecutor createExecutor(EngineCreationContext engineCreationContext, Label<?>[] labels) {
        if (labels == null || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])labels)).isEmpty()) {
            ExecutorFactory executorFactory = this.defaultFactory();
            if (executorFactory instanceof CodeLanguageLabelExecutorFactory) {
                CodeLanguageLabelExecutorFactory codeLanguageLabelExecutorFactory = (CodeLanguageLabelExecutorFactory)executorFactory;
                Label[] createExecutorLabels = (Label[])((Object[])new Label[]{codeLanguageLabelExecutorFactory.getDefaultCodeLanguageLabel()});
                return this.createLabelExecutor(engineCreationContext, createExecutorLabels);
            }
            LabelExecutor executor = this.tryCreateExecutor(engineCreationContext, null);
            this.executors().put(executor.getId(), executor);
            return executor;
        }
        return this.createLabelExecutor(engineCreationContext, labels);
    }

    public Label<?>[] createExecutor$default$2() {
        return null;
    }

    private LabelExecutor createLabelExecutor(EngineCreationContext engineCreationContext, Label<?>[] labels) {
        BoxedUnit boxedUnit;
        String labelKey = this.getLabelKey(labels);
        if (labelKey == null) {
            throw new EngineConnPluginErrorException(EngineconnCoreErrorCodeSummary.CANNOT_GET_LABEL_KEY.getErrorCode(), MessageFormat.format(EngineconnCoreErrorCodeSummary.CANNOT_GET_LABEL_KEY.getErrorDesc(), this.GSON().toJson(labels)));
        }
        if (!this.executors().isEmpty() && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.factories())).size() <= 1) {
            this.logger().info("For a single Executor EC, if an Executor exists, it will be returned directly");
            return (LabelExecutor)this.getReportExecutor();
        }
        if (!this.executors().containsKey(labelKey)) {
            Map<String, LabelExecutor> map = this.executors();
            synchronized (map) {
                BoxedUnit boxedUnit2;
                if (!this.executors().containsKey(labelKey)) {
                    LabelExecutor executor = this.tryCreateExecutor(engineCreationContext, labels);
                    boxedUnit2 = this.executors().put(labelKey, executor);
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit3 = boxedUnit2;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl17 : MonitorExitStatement: MONITOREXIT : var4_4
                boxedUnit = boxedUnit3;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.executors().get(labelKey);
    }

    @Override
    public int generateExecutorId() {
        return this.idCreator().getAndIncrement();
    }

    @Override
    public LabelExecutor getExecutorByLabels(Label<?>[] labels) {
        BoxedUnit boxedUnit;
        if (!this.executors().isEmpty() && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.factories())).size() <= 1) {
            this.logger().info("For a single Executor EC, if an Executor exists, it will be returned directly");
            return (LabelExecutor)this.getReportExecutor();
        }
        String labelKey = this.getLabelKey(labels);
        if (labelKey == null) {
            return null;
        }
        if (!this.executors().containsKey(labelKey)) {
            Map<String, LabelExecutor> map = this.executors();
            synchronized (map) {
                BoxedUnit boxedUnit2 = !this.executors().containsKey(labelKey) ? this.createExecutor(this.engineConn().getEngineCreationContext(), labels) : BoxedUnit.UNIT;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl12 : MonitorExitStatement: MONITOREXIT : var3_3
                boxedUnit = boxedUnit2;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.executors().get(labelKey);
    }

    @Override
    public boolean containExecutor(Label<?>[] labels) {
        String labelKey = this.getLabelKey(labels);
        return labelKey != null && this.executors().containsKey(labelKey);
    }

    @Override
    public Executor getExecutor(String id) {
        return (Executor)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.executors().values()).asScala()).find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)LabelExecutorManagerImpl.$anonfun$getExecutor$1(id, x$8))).orNull(Predef$.MODULE$.$conforms());
    }

    @Override
    public Executor[] getExecutors() {
        return (Executor[])((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.executors().values()).asScala()).toArray(ClassTag$.MODULE$.apply(Executor.class));
    }

    @Override
    public LabelExecutor removeExecutor(Label<?>[] labels) {
        LabelExecutor labelExecutor;
        Map<String, LabelExecutor> map = this.executors();
        synchronized (map) {
            String labelKey = this.getLabelKey(labels);
            labelExecutor = labelKey != null && this.executors().containsKey(labelKey) ? this.executors().remove(labelKey) : null;
        }
        return labelExecutor;
    }

    @Override
    public Executor removeExecutor(String id) {
        Executor executor;
        Map<String, LabelExecutor> map = this.executors();
        synchronized (map) {
            executor = (Executor)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.executors()).asScala()).find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)LabelExecutorManagerImpl.$anonfun$removeExecutor$1(id, x$9))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    return this.executors().remove(k);
                }
                throw new MatchError((Object)tuple2);
            }).orNull(Predef$.MODULE$.$conforms());
        }
        return executor;
    }

    @Override
    public Executor getReportExecutor() {
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getExecutors())).isEmpty()) {
            Label[] labelArray;
            ExecutorFactory executorFactory = this.defaultFactory();
            if (executorFactory instanceof CodeLanguageLabelExecutorFactory) {
                CodeLanguageLabelExecutorFactory codeLanguageLabelExecutorFactory = (CodeLanguageLabelExecutorFactory)executorFactory;
                labelArray = (Label[])((Object[])new Label[]{codeLanguageLabelExecutorFactory.getDefaultCodeLanguageLabel()});
            } else {
                labelArray = this.engineConn().getEngineCreationContext().getLabels() == null ? (Label[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Label.class)) : (Label[])this.engineConn().getEngineCreationContext().getLabels().toArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Label.class)));
            }
            Label[] labels = labelArray;
            return this.createExecutor(this.engineConn().getEngineCreationContext(), labels);
        }
        return (Executor)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getExecutors())).maxBy((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)LabelExecutorManagerImpl.$anonfun$getReportExecutor$1(x0$1)), (Ordering)Ordering.Int$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$tryCreateExecutor$1(Label[] labels$1, ExecutorFactory x0$1) {
        ExecutorFactory executorFactory = x0$1;
        if (executorFactory instanceof LabelExecutorFactory) {
            LabelExecutorFactory labelExecutorFactory = (LabelExecutorFactory)executorFactory;
            return labelExecutorFactory.canCreate(labels$1);
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$getLabelKey$1(Label x$6) {
        return x$6 != null;
    }

    public static final /* synthetic */ boolean $anonfun$getExecutor$1(String id$1, LabelExecutor x$8) {
        String string = x$8.getId();
        String string2 = id$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$removeExecutor$1(String id$2, Tuple2 x$9) {
        String string = ((Executor)x$9._2()).getId();
        String string2 = id$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ int $anonfun$getReportExecutor$1(Executor x0$1) {
        Executor executor = x0$1;
        if (executor instanceof SensibleExecutor) {
            SensibleExecutor sensibleExecutor = (SensibleExecutor)executor;
            return sensibleExecutor.getStatus().ordinal();
        }
        if (executor != null) {
            Executor executor2 = executor;
            return executor2.getId().hashCode();
        }
        throw new MatchError((Object)executor);
    }

    public LabelExecutorManagerImpl() {
        Tuple2 tuple2;
        Logging.$init$((Logging)this);
        this.GSON = EngineConnUtils$.MODULE$.GSON();
        this.idCreator = new AtomicInteger();
        this.engineConnPlugin = EngineConnObject$.MODULE$.getEngineConnPlugin();
        EngineConnFactory engineConnFactory = this.engineConnPlugin().getEngineConnFactory();
        if (engineConnFactory instanceof SingleExecutorEngineConnFactory) {
            SingleExecutorEngineConnFactory singleExecutorEngineConnFactory = (SingleExecutorEngineConnFactory)engineConnFactory;
            tuple2 = new Tuple2(Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ExecutorFactory.class)), (Object)singleExecutorEngineConnFactory);
        } else if (engineConnFactory instanceof SingleLabelExecutorEngineConnFactory) {
            SingleLabelExecutorEngineConnFactory singleLabelExecutorEngineConnFactory = (SingleLabelExecutorEngineConnFactory)engineConnFactory;
            tuple2 = new Tuple2((Object)new ExecutorFactory[]{singleLabelExecutorEngineConnFactory}, (Object)singleLabelExecutorEngineConnFactory);
        } else if (engineConnFactory instanceof MultiExecutorEngineConnFactory) {
            MultiExecutorEngineConnFactory multiExecutorEngineConnFactory = (MultiExecutorEngineConnFactory)engineConnFactory;
            tuple2 = new Tuple2((Object)multiExecutorEngineConnFactory.getExecutorFactories(), (Object)multiExecutorEngineConnFactory.getDefaultExecutorFactory());
        } else {
            String errorMsg = new StringBuilder(30).append("Not supported ExecutorFactory ").append(engineConnFactory.getClass().getSimpleName()).toString();
            this.logger().error(errorMsg);
            throw new EngineConnPluginErrorException(EngineconnCoreErrorCodeSummary.NOT_SUPPORTED_EF.getErrorCode(), errorMsg);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        ExecutorFactory[] factories = (ExecutorFactory[])tuple22._1();
        ExecutorFactory defaultFactory = (ExecutorFactory)tuple22._2();
        this.x$1 = new Tuple2((Object)factories, (Object)defaultFactory);
        this.factories = (ExecutorFactory[])this.x$1._1();
        this.defaultFactory = (ExecutorFactory)this.x$1._2();
    }
}

