/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.rpc.serializer;

import io.protostuff.LinkedBuffer;
import io.protostuff.ProtostuffIOUtil;
import io.protostuff.Schema;
import io.protostuff.runtime.DefaultIdStrategy;
import io.protostuff.runtime.Delegate;
import io.protostuff.runtime.IdStrategy;
import io.protostuff.runtime.RuntimeEnv;
import io.protostuff.runtime.RuntimeSchema;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.linkis.rpc.serializer.NoneDelegate;
import scala.Option;

public class ProtostuffSerializeUtil {
    private static final Delegate<Option> TIMESTAMP_DELEGATE = new NoneDelegate();
    private static final DefaultIdStrategy idStrategy = (DefaultIdStrategy)RuntimeEnv.ID_STRATEGY;
    private static Map<Class<?>, Schema<?>> schemaCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String serialize(T obj) {
        byte[] data;
        if (obj == null) {
            throw new NullPointerException();
        }
        Class<?> clazz = obj.getClass();
        Schema<?> schema = ProtostuffSerializeUtil.getSchema(clazz);
        LinkedBuffer buffer = LinkedBuffer.allocate((int)512);
        try {
            data = ProtostuffIOUtil.toByteArray(obj, schema, (LinkedBuffer)buffer);
        }
        finally {
            buffer.clear();
        }
        return ProtostuffSerializeUtil.toHexString(data);
    }

    public static <T> T deserialize(String str, Class<T> clazz) {
        Schema<T> schema = ProtostuffSerializeUtil.getSchema(clazz);
        Object obj = schema.newMessage();
        ProtostuffIOUtil.mergeFrom((byte[])ProtostuffSerializeUtil.toByteArray(str), (Object)obj, schema);
        return (T)obj;
    }

    private static <T> Schema<T> getSchema(Class<T> clazz) {
        RuntimeSchema schema = schemaCache.get(clazz);
        if (schema == null && (schema = RuntimeSchema.createFrom(clazz, (IdStrategy)idStrategy)) != null) {
            schemaCache.put(clazz, (Schema<?>)schema);
        }
        return schema;
    }

    public static byte[] toByteArray(String hexString) {
        if (null == hexString) {
            throw new IllegalArgumentException("this hexString must not be null");
        }
        if ("".equals(hexString)) {
            return new byte[0];
        }
        hexString = hexString.toLowerCase();
        byte[] byteArray = new byte[hexString.length() / 2];
        int k = 0;
        for (int i = 0; i < byteArray.length; ++i) {
            byte high = (byte)(Character.digit(hexString.charAt(k), 16) & 0xFF);
            byte low = (byte)(Character.digit(hexString.charAt(k + 1), 16) & 0xFF);
            byteArray[i] = (byte)(high << 4 | low);
            k += 2;
        }
        return byteArray;
    }

    public static String toHexString(byte[] byteArray) {
        if (byteArray == null) {
            throw new IllegalArgumentException("this byteArray must not be null ");
        }
        StringBuilder hexString = new StringBuilder();
        for (int i = 0; i < byteArray.length; ++i) {
            if ((byteArray[i] & 0xFF) < 16) {
                hexString.append("0");
            }
            hexString.append(Integer.toHexString(0xFF & byteArray[i]));
        }
        return hexString.toString().toLowerCase();
    }

    static {
        idStrategy.registerDelegate(TIMESTAMP_DELEGATE);
        schemaCache = new ConcurrentHashMap();
    }
}

